---
title: Client Configuration
weight: 4
---

## SQS Client Options

Note that there are a [variety of options](https://git.xarth.tv/eventbus/client/blob/master/subscriber/sqsclient/config.go) that you can use to configure your subscriber client.
The configuration options include:

* `VisibilityTimeout`: timeout set by SQS during which SQS prevents other potential consumers from receiving and processing the same message. (Default: 30s)

* `MinPollers`: number of goroutines concurrently polling. (Default: 2)

* `DeliverConcurrency`: number of concurrent goroutines to process incoming events. (Default: 100)

* `HookCallback`: used to provide a callback that is fired for internal poller events.

* `FineTuning.DeliverChannelDepth`: depth of buffered delivery channel. (Default: 100)

* `FineTuning.AckChannelDepth`: depth of buffered ack channel. (Default: `DeliverConcurrency`)

* `FineTuning.ShutdownCancelRequests`: cancels all outgoing requests on shutdown after this duration. (Default: 30s)
