---
title: Express-Bus CLI Tool
weight: 7
---

{{% notice note %}}
The `express-bus` command line tool is dangerous and can be used to enqueue or delete from production SQS queues. Proceed with caution!
{{% /notice %}}

Using the `express-bus` command line tool, you can inspect events directly from your SQS queue to debug operational issues. The tool also allows you to delete events and requeue (from a deadletter queue), all of which support complex filter and matching expressions.

The tool also includes a subcommand `ship`, which allows you to inject predefined EventBus events from a JSON file directly onto a target SQS queue. This can in turn be used to create workflows like reliable and repeatable integration tests.

## Prerequisites

To use the tool, AWS credentials are needed in your toolchain. Use a tool like `ada` or fetch credentials from Isengard for your AWS account. The following APIs are invoked by `express-bus`:

* `sqs:SendMessage`
* `sqs:ReceiveMessage`
* `sqs:GetQueueUrl`

## Installation

```
go get code.justin.tv/eventbus/express
cd $GOPATH/src/code.justin.tv/eventbus/express
make build
./express-bus <...>
```

## Receive Events

Refer to `express-bus receive -h` for documentation of supported flags and arguments.

#### Example Output

```raw
$ express-bus receive -u https://queue-url -n 2 --action requeue
WARNING! You are about to requeue up to 2 messages from a deadletter queue to its primary queue.
Primary queue URL:    https://queue-url
Deadletter queue URL: https://queue-url-deadletter
Proceed? (y/n): y
Message 1 of 2
===========================
SQS:
	MessageID: 8eb270da-c76c-46ed-b60a-b6efa2b5d281
	FirstReceiveTime: 52741-01-27T10:18:33-08:00
	ReceiveCount: 8
	Attributes: (None)
SNS:
	MessageID: 065b8a6b-b3f2-51fa-a006-dd92e4d789cc
	Attributes:
		eventbus-rand-e6: {"Type":"Number","Value":"160375"}
		eventbus-event-type: {"Type":"String","Value":"ContentTagsUpdate"}
	EventBus:
		Type: ContentTagsUpdate
		Header:
			MessageID: 8f5f1a73-38fd-4001-9276-4f5e655a279d
			CreatedAt: 2020-10-08T18:05:25Z
			Environment: staging
		Payload:
			{
				"content_id": "112387342",
				"content_type": 1,
				"tags": [
					{
						"id": "f273aa1e-f50b-4161-b77d-fa924b9e4317",
						"name": "auto___lang_pt",
						"localizations": {
							"en-us": "Português"
						}
					}
				]
			}

Message successfully requeued

Message 2 of 2
===========================
SQS:
	MessageID: ecafd386-f69d-4667-a6e3-11ea27f81502
	FirstReceiveTime: 52741-01-27T08:24:07-08:00
	ReceiveCount: 8
	Attributes: (None)
SNS:
	MessageID: 0c9c4344-2d79-5de9-936e-14bd7a670f98
	Attributes:
		eventbus-rand-e6: {"Type":"Number","Value":"161802"}
		eventbus-event-type: {"Type":"String","Value":"ContentTagsUpdate"}
	EventBus:
		Type: ContentTagsUpdate
		Header:
			MessageID: ae33f24f-db58-460c-93d8-994916ddec34
			CreatedAt: 2020-10-08T18:05:18Z
			Environment: staging
		Payload:
			{
				"content_id": "110106406",
				"content_type": 1,
				"tags": [
					{
						"id": "febe1c9b-c788-4118-aa4c-74b9ae608640",
						"name": "auto___lang_fr",
						"localizations": {
							"en-us": "Français"
						}
					}
				]
			}

Message successfully requeued

```


#### Filter Expressions

Expressions are flexible and use the following ruleset: https://github.com/antonmedv/expr/blob/master/docs/Language-Definition.md#language-definition

To make comparisons against fields within the EventBus payload, use the root keyword `P` or `Payload`.

*Examples:*

```
Age > 1 * day

# Compound expression
ReceiveCount > 4 and EventBus.Header.Environment = staging

# Find messages that weren't supposed to be there
IsEventBus == false

# Find events where the UserFollowUserCreate payload matches the from_user_id
P.FromUserId = "12345"
```

#### More Information

See the [repo README](https://git.xarth.tv/eventbus/express/blob/master/README.md)

