---
title: Subscriber FAQ
weight: 2
---

### How can I tell if my integration is working? How can I tell if I am receiving events?

We recommend posting a metric or simply logging within the handler to verify that the service is properly receiving events.

### What is the SLA for receiving a published event on the Event Bus?

The Event Bus is a fancy wrapper for the SNS+SQS wiring. Thus, it's fairly difficult to have a strict SLA imposed by our service since it is so dramatically impacted by variables out of our control. All this being said, our internal testing has shown end to end latency with p50 = ~65 ms.

### My lambda subscriber is not working. What's going on?

The call to [`lambda.Start()`](https://godoc.org/github.com/aws/aws-lambda-go/lambda#Start) is blocking, make sure events are actually flowing to your integration. If this is not the issue, check out some of the other [invocation debugging tips]( https://git.xarth.tv/pages/eventbus/docs/subscribers/lambda_handlers/#invocation-problems). It may also help to check the aws console for lambda invocations to determine if the lambda has been invoked or not. Double check that you followed all of [these steps](https://git.xarth.tv/pages/eventbus/docs/subscribers/lambda_handlers/#attach-your-subscription-target) as well.

### My subscriber is not receiving events. How can I debug this?

Make sure you check to see if the number of visible messages are piling up in the sqs console. Double check that you have followed all the steps in the [SQS setup](https://git.xarth.tv/pages/eventbus/docs/subscribers/sqs_queues/#create-an-sqs-queue-in-your-account). 
