---
title: Subscription Targets
weight: 1
---

Subscription targets allow subscribers to define where events will go. You can define as many subscription targets as your service needs, then assign subscriptions to those subscription targets independently.

For example, perhaps your service consists of a Go container in ECS, and a lambda which exists for administrative tasks. You could make a target for the Go service to subscribe to both `UserCreate` and `UserUpdate`, and a separate target that subscribes to `UserDestroy` for a lambda to do your GDPR compliance tasks.

## Types of Targets

Today, the only type of subscription target supported is [SQS]({{< ref "subscribers/sqs_queues.md" >}}). If you need support for a different type of subscription target, reach out to the Event Bus team so they can prioritize it.

## Deregistering a Target

If you no longer need a subscription target, you can deregister it via the Event Bus dashboard. Do this before removing any infrastructure associated with the target (e.g. the SQS queue in your AWS account).

From the dashboard, find your service and click the **Edit Targets** button. Then find the subscription target you wish to remove, and click the **X** to the right of its name.
