---
title: Troubleshooting
weight: 9
---

{{% notice note %}}
This page is a work in progress. If you encounter an error not discussed on this page, please notify the Event Bus team so we can add it!
{{% /notice %}}

## I get an "unauthorized" error when logging into the dashboard

You must be in the `infra` LDAP group to access the dashboard. If you aren't in this LDAP group (you can check [here](https://dashboard.internal.justin.tv/ldaptools/edit)), send a request to IT via [support.xarth.tv](https://support.xarth.tv).

## I don't see my LDAP group when registering my service in the dashboard

The LDAP groups listed are the Twitch LDAP groups (not Amazon LDAP) that you belong to. Additionally, the LDAP group must be prefixed with `team-`. If you still believe an LDAP group is missing from the list, check [here](https://dashboard.internal.justin.tv/ldaptools/edit) to make sure you belong to that LDAP group.

## I'm seeing "MissingRegion: could not find region configuration"

Your application's AWS client doesn't know what region you're in. There are two common ways to fix this:

Set the `AWS_REGION` environment variable to the region of your application. For example `AWS_REGION=us-west-2`.

Alternatively, you can set the region manually when creating the AWS session:

```go
import "github.com/aws/aws-sdk-go/aws/session"

session, err := session.NewSession(&aws.Config{
    Region: aws.String("us-west-2"),
})
```
