---
title: Updating the CloudFormation
weight: 8
---

Sometimes you'll want to update the CloudFormation template to get the latest features. Be sure to test this process in staging before continuing to production.

Examples in this documentation use the latest version of the CloudFormation template, however if you wish to pin your version consult [CloudFormation Versions]({{< ref "getting_started/cloudformation_versions.md" >}}).

### From Terraform

Terraform will retrieve the CloudFormation template from S3 on each run. Thus running your application's Terraform will automatically use the latest version of the Event Bus CloudFormation template (unless you pinned the version).

### From CloudFormation

Updating your application's CloudFormation stack automatically updates child stacks, including the CloudFormation stack for the EventBus. Thus running your application's CloudFormation will automatically use the latest version of the Event Bus CloudFormation template (unless you pinned the version).

### From the AWS Console

1. Go into the AWS console and click **Services > CloudFormation**
1. Select the "EventBus" stack
1. Click the **Update** button on the top-right
1. Select "Replace current template"
1. Select "Amazon S3 URL"
1. Enter `https://eventbus-setup.s3-us-west-2.amazonaws.com/cloudformation.yaml`
1. Click **Next** three times
1. Acknowledge the pop-up and click **Update stack**
