#!/bin/sh

# args:
# $1 - Hugo binary path
# $2 - publish directory

set -e

HUGO=$1
PUBLISH_DIR=$2

DIR=$(dirname "$0")

cd $DIR/..

if [ "$(git status -s)" ]; then
    git status
    echo "The working directory is dirty. Please commit any pending changes."
    exit 1;
fi

SHA=$(git rev-parse HEAD)

echo "Deleting old publication"
rm -rf ${PUBLISH_DIR}
mkdir ${PUBLISH_DIR}

echo "Creating gh-pages branch in ./public"
git -C ${PUBLISH_DIR} init
git -C ${PUBLISH_DIR} checkout -b gh-pages

echo "Generating site"
${HUGO} -d ${PUBLISH_DIR}

echo "Updating gh-pages branch"
git -C ${PUBLISH_DIR} add --all
git -C ${PUBLISH_DIR} -c user.email=root@jenkins.internal.justin.tv -c user.name='Jenkins' commit -m "Publishing to gh-pages ($SHA)"

echo "Pushing gh-pages branch"
git -C ${PUBLISH_DIR} push -f git@git.xarth.tv:eventbus/docs gh-pages:gh-pages 2>&1