package main

import (
	"fmt"
	"log"
	"os"
	"os/signal"

	"code.justin.tv/eventbus/eventsub-websocket-client-wip-golang"
)

func main() {
	log.Println("Let's do EventSub WebSockets!")

	interrupt := make(chan os.Signal, 1)
	signal.Notify(interrupt, os.Interrupt)

	c := eventsub.NewWebSocketClient()

	err := c.Start()
	if err != nil {
		panic(err)
	}

	<-interrupt
	fmt.Println("")
	log.Println("Received interrupt, cleaning up now")
	err = c.Stop()
	if err != nil {
		panic(err)
	}
	log.Println("Cleaned up successfully. Goodbye.")
}
