package eventtypes

import (
	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/eventbus/schema/pkg/active_subscription"
	"code.justin.tv/eventbus/schema/pkg/authorization"
	"code.justin.tv/eventbus/schema/pkg/automod_chat_message_caught"
	"code.justin.tv/eventbus/schema/pkg/automod_settings_moderation_action"
	"code.justin.tv/eventbus/schema/pkg/automod_terms_moderation_action"
	"code.justin.tv/eventbus/schema/pkg/bits_use"
	"code.justin.tv/eventbus/schema/pkg/boost_order"
	"code.justin.tv/eventbus/schema/pkg/bounty_status"
	"code.justin.tv/eventbus/schema/pkg/channel"
	"code.justin.tv/eventbus/schema/pkg/channel_endorsement_list"
	"code.justin.tv/eventbus/schema/pkg/channel_points_community_goal"
	"code.justin.tv/eventbus/schema/pkg/channel_points_custom_reward"
	"code.justin.tv/eventbus/schema/pkg/channel_points_custom_reward_redemption"
	"code.justin.tv/eventbus/schema/pkg/chat_ban"
	"code.justin.tv/eventbus/schema/pkg/chat_moderation_action"
	"code.justin.tv/eventbus/schema/pkg/chat_unban_request"
	"code.justin.tv/eventbus/schema/pkg/cheer"
	"code.justin.tv/eventbus/schema/pkg/clock"
	"code.justin.tv/eventbus/schema/pkg/commercial"
	"code.justin.tv/eventbus/schema/pkg/content_tags"
	"code.justin.tv/eventbus/schema/pkg/creator_subscription_settings"
	"code.justin.tv/eventbus/schema/pkg/emoticon"
	"code.justin.tv/eventbus/schema/pkg/entitlement_badge"
	"code.justin.tv/eventbus/schema/pkg/entitlement_drop_batch"
	"code.justin.tv/eventbus/schema/pkg/entitlement_emote"
	"code.justin.tv/eventbus/schema/pkg/entitlement_subscription"
	"code.justin.tv/eventbus/schema/pkg/host_moderation_action"
	"code.justin.tv/eventbus/schema/pkg/hype_train"
	"code.justin.tv/eventbus/schema/pkg/igdb_game"
	"code.justin.tv/eventbus/schema/pkg/poll_synchronization"
	"code.justin.tv/eventbus/schema/pkg/promo_campaign"
	"code.justin.tv/eventbus/schema/pkg/promotion_impression"
	"code.justin.tv/eventbus/schema/pkg/raid_moderation_action"
	"code.justin.tv/eventbus/schema/pkg/stream"
	"code.justin.tv/eventbus/schema/pkg/subscriber_badge"
	"code.justin.tv/eventbus/schema/pkg/subscriber_badge_flair"
	"code.justin.tv/eventbus/schema/pkg/user"
	"code.justin.tv/eventbus/schema/pkg/user_ban"
	"code.justin.tv/eventbus/schema/pkg/user_block_user"
	"code.justin.tv/eventbus/schema/pkg/user_data_request"
	"code.justin.tv/eventbus/schema/pkg/user_follow_user"
	"code.justin.tv/eventbus/schema/pkg/user_gift_subscription_user"
	"code.justin.tv/eventbus/schema/pkg/user_multi_factor_auth"
	"code.justin.tv/eventbus/schema/pkg/user_password"
	"code.justin.tv/eventbus/schema/pkg/user_recover"
	"code.justin.tv/eventbus/schema/pkg/user_session"
	"code.justin.tv/eventbus/schema/pkg/user_social_media_link"
	"code.justin.tv/eventbus/schema/pkg/user_subscribe_user_notice"
)

type Builder func() eventbus.Message

var MessageBuilders = map[string]Builder{
	"ActiveSubscriptionCreate":       func() eventbus.Message { return new(active_subscription.ActiveSubscriptionCreate) },
	"ActiveSubscriptionDelete":       func() eventbus.Message { return new(active_subscription.ActiveSubscriptionDelete) },
	"AuthorizationDelete":            func() eventbus.Message { return new(authorization.AuthorizationDelete) },
	"AutomodChatMessageCaughtCreate": func() eventbus.Message { return new(automod_chat_message_caught.AutomodChatMessageCaughtCreate) },
	"AutomodChatMessageCaughtUpdate": func() eventbus.Message { return new(automod_chat_message_caught.AutomodChatMessageCaughtUpdate) },
	"AutomodSettingsModerationActionCreate": func() eventbus.Message {
		return new(automod_settings_moderation_action.AutomodSettingsModerationActionCreate)
	},
	"AutomodTermsModerationActionCreate": func() eventbus.Message {
		return new(automod_terms_moderation_action.AutomodTermsModerationActionCreate)
	},
	"BitsUseCreate":                    func() eventbus.Message { return new(bits_use.BitsUseCreate) },
	"BoostOrderCreate":                 func() eventbus.Message { return new(boost_order.BoostOrderCreate) },
	"BoostOrderDelete":                 func() eventbus.Message { return new(boost_order.BoostOrderDelete) },
	"BoostOrderUpdate":                 func() eventbus.Message { return new(boost_order.BoostOrderUpdate) },
	"BountyStatusUpdate":               func() eventbus.Message { return new(bounty_status.BountyStatusUpdate) },
	"ChannelUpdate":                    func() eventbus.Message { return new(channel.ChannelUpdate) },
	"ChannelEndorsementListUpdate":     func() eventbus.Message { return new(channel_endorsement_list.ChannelEndorsementListUpdate) },
	"ChannelPointsCommunityGoalUpdate": func() eventbus.Message { return new(channel_points_community_goal.ChannelPointsCommunityGoalUpdate) },
	"ChannelPointsCustomRewardCreate":  func() eventbus.Message { return new(channel_points_custom_reward.ChannelPointsCustomRewardCreate) },
	"ChannelPointsCustomRewardDelete":  func() eventbus.Message { return new(channel_points_custom_reward.ChannelPointsCustomRewardDelete) },
	"ChannelPointsCustomRewardUpdate":  func() eventbus.Message { return new(channel_points_custom_reward.ChannelPointsCustomRewardUpdate) },
	"ChannelPointsCustomRewardRedemptionCreate": func() eventbus.Message {
		return new(channel_points_custom_reward_redemption.ChannelPointsCustomRewardRedemptionCreate)
	},
	"ChannelPointsCustomRewardRedemptionUpdate": func() eventbus.Message {
		return new(channel_points_custom_reward_redemption.ChannelPointsCustomRewardRedemptionUpdate)
	},
	"ChatBanCreate":                     func() eventbus.Message { return new(chat_ban.ChatBanCreate) },
	"ChatBanDelete":                     func() eventbus.Message { return new(chat_ban.ChatBanDelete) },
	"ChatModerationActionCreate":        func() eventbus.Message { return new(chat_moderation_action.ChatModerationActionCreate) },
	"ChatUnbanRequestCreate":            func() eventbus.Message { return new(chat_unban_request.ChatUnbanRequestCreate) },
	"ChatUnbanRequestUpdate":            func() eventbus.Message { return new(chat_unban_request.ChatUnbanRequestUpdate) },
	"CheerCreate":                       func() eventbus.Message { return new(cheer.CheerCreate) },
	"ClockUpdate":                       func() eventbus.Message { return new(clock.ClockUpdate) },
	"CommercialUpdate":                  func() eventbus.Message { return new(commercial.CommercialUpdate) },
	"ContentTagsUpdate":                 func() eventbus.Message { return new(content_tags.ContentTagsUpdate) },
	"CreatorSubscriptionSettingsUpdate": func() eventbus.Message { return new(creator_subscription_settings.CreatorSubscriptionSettingsUpdate) },
	"EmoticonCreate":                    func() eventbus.Message { return new(emoticon.EmoticonCreate) },
	"EmoticonDelete":                    func() eventbus.Message { return new(emoticon.EmoticonDelete) },
	"EntitlementBadgeCreate":            func() eventbus.Message { return new(entitlement_badge.EntitlementBadgeCreate) },
	"EntitlementBadgeDelete":            func() eventbus.Message { return new(entitlement_badge.EntitlementBadgeDelete) },
	"EntitlementBadgeUpdate":            func() eventbus.Message { return new(entitlement_badge.EntitlementBadgeUpdate) },
	"EntitlementDropBatchCreate":        func() eventbus.Message { return new(entitlement_drop_batch.EntitlementDropBatchCreate) },
	"EntitlementEmoteCreate":            func() eventbus.Message { return new(entitlement_emote.EntitlementEmoteCreate) },
	"EntitlementEmoteDelete":            func() eventbus.Message { return new(entitlement_emote.EntitlementEmoteDelete) },
	"EntitlementEmoteUpdate":            func() eventbus.Message { return new(entitlement_emote.EntitlementEmoteUpdate) },
	"EntitlementSubscriptionCreate":     func() eventbus.Message { return new(entitlement_subscription.EntitlementSubscriptionCreate) },
	"EntitlementSubscriptionDelete":     func() eventbus.Message { return new(entitlement_subscription.EntitlementSubscriptionDelete) },
	"EntitlementSubscriptionUpdate":     func() eventbus.Message { return new(entitlement_subscription.EntitlementSubscriptionUpdate) },
	"HostModerationActionCreate":        func() eventbus.Message { return new(host_moderation_action.HostModerationActionCreate) },
	"HostModerationActionDelete":        func() eventbus.Message { return new(host_moderation_action.HostModerationActionDelete) },
	"HypeTrainCreate":                   func() eventbus.Message { return new(hype_train.HypeTrainCreate) },
	"HypeTrainDelete":                   func() eventbus.Message { return new(hype_train.HypeTrainDelete) },
	"HypeTrainUpdate":                   func() eventbus.Message { return new(hype_train.HypeTrainUpdate) },
	"IgdbGameCreate":                    func() eventbus.Message { return new(igdb_game.IgdbGameCreate) },
	"IgdbGameDelete":                    func() eventbus.Message { return new(igdb_game.IgdbGameDelete) },
	"IgdbGameUpdate":                    func() eventbus.Message { return new(igdb_game.IgdbGameUpdate) },
	"PollSynchronizationUpdate":         func() eventbus.Message { return new(poll_synchronization.PollSynchronizationUpdate) },
	"PromoCampaignUpdate":               func() eventbus.Message { return new(promo_campaign.PromoCampaignUpdate) },
	"PromotionImpressionCreate":         func() eventbus.Message { return new(promotion_impression.PromotionImpressionCreate) },
	"RaidModerationActionCreate":        func() eventbus.Message { return new(raid_moderation_action.RaidModerationActionCreate) },
	"RaidModerationActionDelete":        func() eventbus.Message { return new(raid_moderation_action.RaidModerationActionDelete) },
	"StreamCreate":                      func() eventbus.Message { return new(stream.StreamCreate) },
	"StreamDelete":                      func() eventbus.Message { return new(stream.StreamDelete) },
	"StreamUpdate":                      func() eventbus.Message { return new(stream.StreamUpdate) },
	"SubscriberBadgeCreate":             func() eventbus.Message { return new(subscriber_badge.SubscriberBadgeCreate) },
	"SubscriberBadgeFlairCreate":        func() eventbus.Message { return new(subscriber_badge_flair.SubscriberBadgeFlairCreate) },
	"UserCreate":                        func() eventbus.Message { return new(user.UserCreate) },
	"UserDelete":                        func() eventbus.Message { return new(user.UserDelete) },
	"UserDestroy":                       func() eventbus.Message { return new(user.UserDestroy) },
	"UserUndelete":                      func() eventbus.Message { return new(user.UserUndelete) },
	"UserUpdate":                        func() eventbus.Message { return new(user.UserUpdate) },
	"UserBanCreate":                     func() eventbus.Message { return new(user_ban.UserBanCreate) },
	"UserBanDelete":                     func() eventbus.Message { return new(user_ban.UserBanDelete) },
	"UserBlockUserCreate":               func() eventbus.Message { return new(user_block_user.UserBlockUserCreate) },
	"UserDataRequestCreate":             func() eventbus.Message { return new(user_data_request.UserDataRequestCreate) },
	"UserFollowUserCreate":              func() eventbus.Message { return new(user_follow_user.UserFollowUserCreate) },
	"UserFollowUserDelete":              func() eventbus.Message { return new(user_follow_user.UserFollowUserDelete) },
	"UserGiftSubscriptionUserCreate":    func() eventbus.Message { return new(user_gift_subscription_user.UserGiftSubscriptionUserCreate) },
	"UserMultiFactorAuthUpdate":         func() eventbus.Message { return new(user_multi_factor_auth.UserMultiFactorAuthUpdate) },
	"UserPasswordUpdate":                func() eventbus.Message { return new(user_password.UserPasswordUpdate) },
	"UserRecoverCreate":                 func() eventbus.Message { return new(user_recover.UserRecoverCreate) },
	"UserSessionDelete":                 func() eventbus.Message { return new(user_session.UserSessionDelete) },
	"UserSocialMediaLinkCreate":         func() eventbus.Message { return new(user_social_media_link.UserSocialMediaLinkCreate) },
	"UserSocialMediaLinkDelete":         func() eventbus.Message { return new(user_social_media_link.UserSocialMediaLinkDelete) },
	"UserSocialMediaLinkUpdate":         func() eventbus.Message { return new(user_social_media_link.UserSocialMediaLinkUpdate) },
	"UserSubscribeUserNoticeCreate":     func() eventbus.Message { return new(user_subscribe_user_notice.UserSubscribeUserNoticeCreate) },
}
