package sqsutil

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestAccountIDFromQueueURL(t *testing.T) {
	type test struct {
		input, output, err string
	}
	tests := []test{
		{"https://sqs.us-west-2.amazonaws.com/311539646041/eventbus-abcd", "311539646041", ""},
		{"https://sqs.amazonaws.com/1224/eventbus-q", "1224", ""},

		{"https://sqs.amazonaws.com/1224/eventbus-q/fake", "", "Expected 2 parts, got [1224 eventbus-q fake]"},
		{"abc", "", "Expected 2 parts, got [abc]"},
	}

	for _, testCase := range tests {
		output, err := AccountIDFromQueueURL(testCase.input)
		assert.Equal(t, testCase.output, output)
		if err != nil {
			assert.Equal(t, testCase.err, err.Error())
		}
	}
}
