// Code generated by protoc-gen-go. DO NOT EDIT.
// source: active_subscription/create.proto

package active_subscription

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Platform represents the platform on which the entitlement was created.
type Platform int32

const (
	Platform_PLATFORM_INVALID Platform = 0
	Platform_PLATFORM_ANDROID Platform = 1
	Platform_PLATFORM_IOS     Platform = 2
	Platform_PLATFORM_WEB     Platform = 3
)

var Platform_name = map[int32]string{
	0: "PLATFORM_INVALID",
	1: "PLATFORM_ANDROID",
	2: "PLATFORM_IOS",
	3: "PLATFORM_WEB",
}
var Platform_value = map[string]int32{
	"PLATFORM_INVALID": 0,
	"PLATFORM_ANDROID": 1,
	"PLATFORM_IOS":     2,
	"PLATFORM_WEB":     3,
}

func (x Platform) String() string {
	return proto.EnumName(Platform_name, int32(x))
}
func (Platform) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_fbf878baeb798244, []int{0}
}

// A `SubscriptionType` identifies the method by which a subscription entitlement was created.
type SubscriptionType int32

const (
	SubscriptionType_SUBSCRIPTION_TYPE_INVALID SubscriptionType = 0
	SubscriptionType_SUBSCRIPTION_TYPE_GIFT    SubscriptionType = 1
	SubscriptionType_SUBSCRIPTION_TYPE_PAID    SubscriptionType = 2
	SubscriptionType_SUBSCRIPTION_TYPE_PRIME   SubscriptionType = 3
	// Signifies the user initiated the creation of this entitlement by linking their prime and twitch account.
	// A primelink subscription entitlement is always to the primelink product(s), and not to products owned by real Twitch channels.
	SubscriptionType_SUBSCRIPTION_TYPE_PRIMELINK SubscriptionType = 4
	// Can be a channel's own subscription to themself granted upon reaching Affiliate status, or a subscription created by Twitch internally.
	SubscriptionType_SUBSCRIPTION_TYPE_ADMIN           SubscriptionType = 5
	SubscriptionType_SUBSCRIPTION_TYPE_SUB_TOKEN       SubscriptionType = 6
	SubscriptionType_SUBSCRIPTION_TYPE_CODE_REDEMPTION SubscriptionType = 7
)

var SubscriptionType_name = map[int32]string{
	0: "SUBSCRIPTION_TYPE_INVALID",
	1: "SUBSCRIPTION_TYPE_GIFT",
	2: "SUBSCRIPTION_TYPE_PAID",
	3: "SUBSCRIPTION_TYPE_PRIME",
	4: "SUBSCRIPTION_TYPE_PRIMELINK",
	5: "SUBSCRIPTION_TYPE_ADMIN",
	6: "SUBSCRIPTION_TYPE_SUB_TOKEN",
	7: "SUBSCRIPTION_TYPE_CODE_REDEMPTION",
}
var SubscriptionType_value = map[string]int32{
	"SUBSCRIPTION_TYPE_INVALID":         0,
	"SUBSCRIPTION_TYPE_GIFT":            1,
	"SUBSCRIPTION_TYPE_PAID":            2,
	"SUBSCRIPTION_TYPE_PRIME":           3,
	"SUBSCRIPTION_TYPE_PRIMELINK":       4,
	"SUBSCRIPTION_TYPE_ADMIN":           5,
	"SUBSCRIPTION_TYPE_SUB_TOKEN":       6,
	"SUBSCRIPTION_TYPE_CODE_REDEMPTION": 7,
}

func (x SubscriptionType) String() string {
	return proto.EnumName(SubscriptionType_name, int32(x))
}
func (SubscriptionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_fbf878baeb798244, []int{1}
}

// ActiveSubscriptionCreate is a downstream event of EntitlementSubscriptionCreate and EntitlementSubscriptionUpdate.
// It is scheduled to trigger when a user's entitled subscription becomes active, as defined by the starts_at value.
// A subscription entitlement can be canceled before it starts, meaning that the subscription entitlement will never
// become active, thus not emitting an ActiveSubscriptionCreate event.
// Despite the Create verb, this event does not represent the creation or mutation of any data, just that a previously
// created subscription entitlement has become active. EntitlementSubscriptionCreate represents the creation event, and
// is triggered when a user subscribes or commits to subscribe.
type ActiveSubscriptionCreate struct {
	// Entitlement ID
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Twitch User ID of the user who owns this entitlement.
	OwnerUserId string `protobuf:"bytes,2,opt,name=owner_user_id,json=ownerUserId,proto3" json:"owner_user_id,omitempty"`
	// The Platform from which the entitlement came from.
	Platform Platform `protobuf:"varint,3,opt,name=platform,proto3,enum=active_subscription.Platform" json:"platform,omitempty"`
	// ID for the product the user is entitled to.
	ProductId string `protobuf:"bytes,4,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
	// Twitch User ID of the broadcaster who owns the product.
	ProductOwnerUserId string `protobuf:"bytes,5,opt,name=product_owner_user_id,json=productOwnerUserId,proto3" json:"product_owner_user_id,omitempty"`
	// Identifier for the origin object that caused this entitlement.
	OriginId string `protobuf:"bytes,6,opt,name=origin_id,json=originId,proto3" json:"origin_id,omitempty"`
	// When the entitlement starts.
	StartsAt *timestamp.Timestamp `protobuf:"bytes,7,opt,name=starts_at,json=startsAt,proto3" json:"starts_at,omitempty"`
	// When the entitlement expires.
	EndsAt *timestamp.Timestamp `protobuf:"bytes,8,opt,name=ends_at,json=endsAt,proto3" json:"ends_at,omitempty"`
	// The subscription type of this entitlement.
	Type                 SubscriptionType `protobuf:"varint,9,opt,name=type,proto3,enum=active_subscription.SubscriptionType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ActiveSubscriptionCreate) Reset()         { *m = ActiveSubscriptionCreate{} }
func (m *ActiveSubscriptionCreate) String() string { return proto.CompactTextString(m) }
func (*ActiveSubscriptionCreate) ProtoMessage()    {}
func (*ActiveSubscriptionCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_fbf878baeb798244, []int{0}
}
func (m *ActiveSubscriptionCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActiveSubscriptionCreate.Unmarshal(m, b)
}
func (m *ActiveSubscriptionCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActiveSubscriptionCreate.Marshal(b, m, deterministic)
}
func (dst *ActiveSubscriptionCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActiveSubscriptionCreate.Merge(dst, src)
}
func (m *ActiveSubscriptionCreate) XXX_Size() int {
	return xxx_messageInfo_ActiveSubscriptionCreate.Size(m)
}
func (m *ActiveSubscriptionCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_ActiveSubscriptionCreate.DiscardUnknown(m)
}

var xxx_messageInfo_ActiveSubscriptionCreate proto.InternalMessageInfo

func (m *ActiveSubscriptionCreate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ActiveSubscriptionCreate) GetOwnerUserId() string {
	if m != nil {
		return m.OwnerUserId
	}
	return ""
}

func (m *ActiveSubscriptionCreate) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_INVALID
}

func (m *ActiveSubscriptionCreate) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *ActiveSubscriptionCreate) GetProductOwnerUserId() string {
	if m != nil {
		return m.ProductOwnerUserId
	}
	return ""
}

func (m *ActiveSubscriptionCreate) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *ActiveSubscriptionCreate) GetStartsAt() *timestamp.Timestamp {
	if m != nil {
		return m.StartsAt
	}
	return nil
}

func (m *ActiveSubscriptionCreate) GetEndsAt() *timestamp.Timestamp {
	if m != nil {
		return m.EndsAt
	}
	return nil
}

func (m *ActiveSubscriptionCreate) GetType() SubscriptionType {
	if m != nil {
		return m.Type
	}
	return SubscriptionType_SUBSCRIPTION_TYPE_INVALID
}

func init() {
	proto.RegisterType((*ActiveSubscriptionCreate)(nil), "active_subscription.ActiveSubscriptionCreate")
	proto.RegisterEnum("active_subscription.Platform", Platform_name, Platform_value)
	proto.RegisterEnum("active_subscription.SubscriptionType", SubscriptionType_name, SubscriptionType_value)
}

func init() {
	proto.RegisterFile("active_subscription/create.proto", fileDescriptor_create_fbf878baeb798244)
}

var fileDescriptor_create_fbf878baeb798244 = []byte{
	// 470 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x93, 0x51, 0x6f, 0xda, 0x3e,
	0x14, 0xc5, 0xff, 0x09, 0x14, 0x92, 0xdb, 0xff, 0x2a, 0xcb, 0x5b, 0xb7, 0x0c, 0x84, 0xca, 0x2a,
	0x55, 0x42, 0x7d, 0x08, 0x5a, 0xfb, 0x30, 0xf5, 0x31, 0x90, 0x74, 0xb2, 0x0a, 0x49, 0x94, 0x84,
	0x4d, 0xeb, 0x4b, 0x14, 0x88, 0x8b, 0x2c, 0x15, 0x1c, 0x39, 0x66, 0x53, 0xbf, 0xc3, 0xbe, 0xc4,
	0xbe, 0xe9, 0x84, 0x81, 0x0d, 0xd6, 0x4c, 0x7b, 0x3d, 0xe7, 0x77, 0xae, 0xaf, 0xce, 0x95, 0xa1,
	0x9b, 0xcd, 0x24, 0xfb, 0x4a, 0xd3, 0x72, 0x35, 0x2d, 0x67, 0x82, 0x15, 0x92, 0xf1, 0x65, 0x7f,
	0x26, 0x68, 0x26, 0xa9, 0x5d, 0x08, 0x2e, 0x39, 0x7e, 0x59, 0x41, 0xb4, 0xce, 0xe6, 0x9c, 0xcf,
	0x1f, 0x69, 0x5f, 0x21, 0xd3, 0xd5, 0x43, 0x5f, 0xb2, 0x05, 0x2d, 0x65, 0xb6, 0x28, 0x36, 0xa9,
	0xf3, 0x1f, 0x35, 0xb0, 0x1c, 0x15, 0x8c, 0xf7, 0x72, 0x43, 0x35, 0x18, 0x9f, 0x80, 0xce, 0x72,
	0x4b, 0xeb, 0x6a, 0x3d, 0x33, 0xd2, 0x59, 0x8e, 0xcf, 0xe1, 0x05, 0xff, 0xb6, 0xa4, 0x22, 0x5d,
	0x95, 0x54, 0xa4, 0x2c, 0xb7, 0x74, 0x65, 0x1d, 0x2b, 0x71, 0x52, 0x52, 0x41, 0x72, 0x7c, 0x03,
	0x46, 0xf1, 0x98, 0xc9, 0x07, 0x2e, 0x16, 0x56, 0xad, 0xab, 0xf5, 0x4e, 0xae, 0x3a, 0x76, 0xc5,
	0x66, 0x76, 0xb8, 0x85, 0xa2, 0x5f, 0x38, 0xee, 0x00, 0x14, 0x82, 0xe7, 0xab, 0x99, 0x5c, 0xcf,
	0xae, 0xab, 0xd9, 0xe6, 0x56, 0x21, 0x39, 0x7e, 0x0f, 0xa7, 0x3b, 0xfb, 0x70, 0x8b, 0x23, 0x45,
	0xe2, 0xad, 0x19, 0xec, 0x2d, 0xd3, 0x06, 0x93, 0x0b, 0x36, 0x67, 0xcb, 0x35, 0xd6, 0x50, 0x98,
	0xb1, 0x11, 0x48, 0x8e, 0x3f, 0x80, 0x59, 0xca, 0x4c, 0xc8, 0x32, 0xcd, 0xa4, 0xd5, 0xec, 0x6a,
	0xbd, 0xe3, 0xab, 0x96, 0xbd, 0xe9, 0xcb, 0xde, 0xf5, 0x65, 0x27, 0xbb, 0xbe, 0x22, 0x63, 0x03,
	0x3b, 0x12, 0x5f, 0x43, 0x93, 0x2e, 0x73, 0x15, 0x33, 0xfe, 0x19, 0x6b, 0xac, 0x51, 0x47, 0xe2,
	0x1b, 0xa8, 0xcb, 0xa7, 0x82, 0x5a, 0xa6, 0xea, 0xe4, 0xa2, 0xb2, 0x93, 0xfd, 0x13, 0x24, 0x4f,
	0x05, 0x8d, 0x54, 0xe4, 0xf2, 0x1e, 0x8c, 0x5d, 0x5b, 0xf8, 0x15, 0xa0, 0x70, 0xe4, 0x24, 0xb7,
	0x41, 0x34, 0x4e, 0x89, 0xff, 0xc9, 0x19, 0x11, 0x17, 0xfd, 0x77, 0xa0, 0x3a, 0xbe, 0x1b, 0x05,
	0xc4, 0x45, 0x1a, 0x46, 0xf0, 0xff, 0x6f, 0x36, 0x88, 0x91, 0x7e, 0xa0, 0x7c, 0xf6, 0x06, 0xa8,
	0x76, 0xf9, 0x5d, 0x07, 0xf4, 0xe7, 0xb3, 0xb8, 0x03, 0x6f, 0xe3, 0xc9, 0x20, 0x1e, 0x46, 0x24,
	0x4c, 0x48, 0xe0, 0xa7, 0xc9, 0x97, 0xd0, 0xdb, 0x7b, 0xad, 0x05, 0xaf, 0x9f, 0xdb, 0x1f, 0xc9,
	0x6d, 0x82, 0xb4, 0x6a, 0x2f, 0x74, 0x88, 0x8b, 0x74, 0xdc, 0x86, 0x37, 0x15, 0x5e, 0x44, 0xc6,
	0x1e, 0xaa, 0xe1, 0x33, 0x68, 0xff, 0xc5, 0x1c, 0x11, 0xff, 0x0e, 0xd5, 0xab, 0xd3, 0x8e, 0x3b,
	0x26, 0x3e, 0x3a, 0xaa, 0x4e, 0xc7, 0x93, 0x41, 0x9a, 0x04, 0x77, 0x9e, 0x8f, 0x1a, 0xf8, 0x02,
	0xde, 0x3d, 0x07, 0x86, 0x81, 0xeb, 0xa5, 0x91, 0xe7, 0x7a, 0x63, 0x25, 0xa2, 0xe6, 0xe0, 0xf4,
	0xbe, 0xea, 0x1b, 0x4d, 0x1b, 0xea, 0xb0, 0xd7, 0x3f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x88, 0x5a,
	0x0c, 0xce, 0x86, 0x03, 0x00, 0x00,
}
