// Code generated by protoc-gen-go. DO NOT EDIT.
// source: active_subscription/delete.proto

package active_subscription

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// ActiveSubscriptionDelete is a downstream of EntitlementSubscriptionCreate and EntitlementSubscriptionUpdate that is
// scheduled to trigger when an *active* subscription entitlement ends.
// A subscription entitlement is considered active when `starts_at <= time.Now() < ends_at`. Similarly, an active
// subscription ends (or "expires") when `starts_at < ends_at <= time.Now()`. This means that a future subscription
// entitlement (`time.Now() < starts_at`) that is canceled before it starts will not emit a ActiveSubscriptionDelete
// event since it was never active.
type ActiveSubscriptionDelete struct {
	// Entitlement ID
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Twitch User ID of the user who owns this entitlement.
	OwnerUserId string `protobuf:"bytes,2,opt,name=owner_user_id,json=ownerUserId,proto3" json:"owner_user_id,omitempty"`
	// The Platform from which the entitlement came from.
	Platform Platform `protobuf:"varint,3,opt,name=platform,proto3,enum=active_subscription.Platform" json:"platform,omitempty"`
	// ID for the product the user is entitled to.
	ProductId string `protobuf:"bytes,4,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
	// Twitch User ID of the broadcaster who owns the product.
	ProductOwnerUserId string `protobuf:"bytes,5,opt,name=product_owner_user_id,json=productOwnerUserId,proto3" json:"product_owner_user_id,omitempty"`
	// Identifier for the origin object that caused this entitlement.
	OriginId string `protobuf:"bytes,6,opt,name=origin_id,json=originId,proto3" json:"origin_id,omitempty"`
	// When the entitlement starts.
	StartsAt *timestamp.Timestamp `protobuf:"bytes,7,opt,name=starts_at,json=startsAt,proto3" json:"starts_at,omitempty"`
	// When the entitlement expires.
	EndsAt *timestamp.Timestamp `protobuf:"bytes,8,opt,name=ends_at,json=endsAt,proto3" json:"ends_at,omitempty"`
	// The subscription type of this entitlement.
	Type                 SubscriptionType `protobuf:"varint,9,opt,name=type,proto3,enum=active_subscription.SubscriptionType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ActiveSubscriptionDelete) Reset()         { *m = ActiveSubscriptionDelete{} }
func (m *ActiveSubscriptionDelete) String() string { return proto.CompactTextString(m) }
func (*ActiveSubscriptionDelete) ProtoMessage()    {}
func (*ActiveSubscriptionDelete) Descriptor() ([]byte, []int) {
	return fileDescriptor_delete_edc5759fac1b8ba3, []int{0}
}
func (m *ActiveSubscriptionDelete) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActiveSubscriptionDelete.Unmarshal(m, b)
}
func (m *ActiveSubscriptionDelete) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActiveSubscriptionDelete.Marshal(b, m, deterministic)
}
func (dst *ActiveSubscriptionDelete) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActiveSubscriptionDelete.Merge(dst, src)
}
func (m *ActiveSubscriptionDelete) XXX_Size() int {
	return xxx_messageInfo_ActiveSubscriptionDelete.Size(m)
}
func (m *ActiveSubscriptionDelete) XXX_DiscardUnknown() {
	xxx_messageInfo_ActiveSubscriptionDelete.DiscardUnknown(m)
}

var xxx_messageInfo_ActiveSubscriptionDelete proto.InternalMessageInfo

func (m *ActiveSubscriptionDelete) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ActiveSubscriptionDelete) GetOwnerUserId() string {
	if m != nil {
		return m.OwnerUserId
	}
	return ""
}

func (m *ActiveSubscriptionDelete) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_INVALID
}

func (m *ActiveSubscriptionDelete) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *ActiveSubscriptionDelete) GetProductOwnerUserId() string {
	if m != nil {
		return m.ProductOwnerUserId
	}
	return ""
}

func (m *ActiveSubscriptionDelete) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *ActiveSubscriptionDelete) GetStartsAt() *timestamp.Timestamp {
	if m != nil {
		return m.StartsAt
	}
	return nil
}

func (m *ActiveSubscriptionDelete) GetEndsAt() *timestamp.Timestamp {
	if m != nil {
		return m.EndsAt
	}
	return nil
}

func (m *ActiveSubscriptionDelete) GetType() SubscriptionType {
	if m != nil {
		return m.Type
	}
	return SubscriptionType_SUBSCRIPTION_TYPE_INVALID
}

func init() {
	proto.RegisterType((*ActiveSubscriptionDelete)(nil), "active_subscription.ActiveSubscriptionDelete")
}

func init() {
	proto.RegisterFile("active_subscription/delete.proto", fileDescriptor_delete_edc5759fac1b8ba3)
}

var fileDescriptor_delete_edc5759fac1b8ba3 = []byte{
	// 318 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x91, 0x41, 0x6b, 0xc2, 0x40,
	0x10, 0x85, 0x89, 0x5a, 0x4d, 0x56, 0xea, 0x61, 0x8b, 0x10, 0x2c, 0xd2, 0x20, 0x14, 0x3c, 0x45,
	0xaa, 0x87, 0xe2, 0xd1, 0xd2, 0x8b, 0xa7, 0x96, 0xd4, 0x5e, 0x7a, 0x09, 0x6b, 0x76, 0x94, 0x05,
	0xcd, 0x2e, 0xbb, 0x93, 0x16, 0x7f, 0x4e, 0xff, 0x69, 0x71, 0x62, 0x4a, 0x0a, 0x81, 0x1e, 0x77,
	0xe6, 0x7b, 0x6f, 0x1f, 0x6f, 0x58, 0x24, 0x32, 0x54, 0x9f, 0x90, 0xba, 0x62, 0xeb, 0x32, 0xab,
	0x0c, 0x2a, 0x9d, 0xcf, 0x24, 0x1c, 0x00, 0x21, 0x36, 0x56, 0xa3, 0xe6, 0x37, 0x0d, 0xc4, 0xa8,
	0x51, 0x96, 0x59, 0x10, 0x95, 0x6c, 0x74, 0xb7, 0xd7, 0x7a, 0x7f, 0x80, 0x19, 0xbd, 0xb6, 0xc5,
	0x6e, 0x86, 0xea, 0x08, 0x0e, 0xc5, 0xd1, 0x94, 0xc0, 0xe4, 0xbb, 0xcd, 0xc2, 0x15, 0xb9, 0xbc,
	0xd5, 0x4c, 0x9e, 0xe9, 0x6b, 0x3e, 0x60, 0x2d, 0x25, 0x43, 0x2f, 0xf2, 0xa6, 0x41, 0xd2, 0x52,
	0x92, 0x4f, 0xd8, 0xb5, 0xfe, 0xca, 0xc1, 0xa6, 0x85, 0x03, 0x9b, 0x2a, 0x19, 0xb6, 0x68, 0xd5,
	0xa7, 0xe1, 0xbb, 0x03, 0xbb, 0x96, 0x7c, 0xc9, 0x7c, 0x73, 0x10, 0xb8, 0xd3, 0xf6, 0x18, 0xb6,
	0x23, 0x6f, 0x3a, 0x98, 0x8f, 0xe3, 0x86, 0x98, 0xf1, 0xeb, 0x05, 0x4a, 0x7e, 0x71, 0x3e, 0x66,
	0xcc, 0x58, 0x2d, 0x8b, 0x0c, 0xcf, 0xde, 0x1d, 0xf2, 0x0e, 0x2e, 0x93, 0xb5, 0xe4, 0x0f, 0x6c,
	0x58, 0xad, 0xff, 0xa6, 0xb8, 0x22, 0x92, 0x5f, 0x96, 0x2f, 0xb5, 0x30, 0xb7, 0x2c, 0xd0, 0x56,
	0xed, 0x55, 0x7e, 0xc6, 0xba, 0x84, 0xf9, 0xe5, 0x60, 0x2d, 0xf9, 0x23, 0x0b, 0x1c, 0x0a, 0x8b,
	0x2e, 0x15, 0x18, 0xf6, 0x22, 0x6f, 0xda, 0x9f, 0x8f, 0xe2, 0xb2, 0xaf, 0xb8, 0xea, 0x2b, 0xde,
	0x54, 0x7d, 0x25, 0x7e, 0x09, 0xaf, 0x90, 0x2f, 0x58, 0x0f, 0x72, 0x49, 0x32, 0xff, 0x5f, 0x59,
	0xf7, 0x8c, 0xae, 0x90, 0x2f, 0x59, 0x07, 0x4f, 0x06, 0xc2, 0x80, 0x3a, 0xb9, 0x6f, 0xec, 0xa4,
	0x7e, 0x82, 0xcd, 0xc9, 0x40, 0x42, 0x92, 0xa7, 0xe1, 0x47, 0xd3, 0xf5, 0xb7, 0x5d, 0xfa, 0x6d,
	0xf1, 0x13, 0x00, 0x00, 0xff, 0xff, 0xf8, 0x96, 0x90, 0x63, 0x3d, 0x02, 0x00, 0x00,
}
