// Code generated by protoc-gen-go. DO NOT EDIT.
// source: channel_points_custom_reward_redemption/create.proto

package channel_points_custom_reward_redemption

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// RedemptionStatus is the different statuses a custom reward redemption can be in.
type RedemptionStatus int32

const (
	RedemptionStatus_REDEMPTION_STATUS_INVALID RedemptionStatus = 0
	// The redemption hasn’t had an action taken on it.
	RedemptionStatus_REDEMPTION_STATUS_UNFULFILLED RedemptionStatus = 1
	// The redemption has been acted upon and fulfilled.
	RedemptionStatus_REDEMPTION_STATUS_FULFILLED RedemptionStatus = 2
	// The redemption has been canceled and the points were refunded.
	RedemptionStatus_REDEMPTION_STATUS_CANCELED RedemptionStatus = 3
	// The redemption was reported.
	RedemptionStatus_REDEMPTION_STATUS_REPORTED RedemptionStatus = 4
)

var RedemptionStatus_name = map[int32]string{
	0: "REDEMPTION_STATUS_INVALID",
	1: "REDEMPTION_STATUS_UNFULFILLED",
	2: "REDEMPTION_STATUS_FULFILLED",
	3: "REDEMPTION_STATUS_CANCELED",
	4: "REDEMPTION_STATUS_REPORTED",
}
var RedemptionStatus_value = map[string]int32{
	"REDEMPTION_STATUS_INVALID":     0,
	"REDEMPTION_STATUS_UNFULFILLED": 1,
	"REDEMPTION_STATUS_FULFILLED":   2,
	"REDEMPTION_STATUS_CANCELED":    3,
	"REDEMPTION_STATUS_REPORTED":    4,
}

func (x RedemptionStatus) String() string {
	return proto.EnumName(RedemptionStatus_name, int32(x))
}
func (RedemptionStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_195ad6c39cf80382, []int{0}
}

// ChannelPointsCustomRewardRedemptionCreate is triggered when a custom reward is redeemed on a channel.
type ChannelPointsCustomRewardRedemptionCreate struct {
	// The redemption's unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the user who redeemed the reward.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// The ID of the channel the reward was redeemed on.
	BroadcasterUserId string `protobuf:"bytes,3,opt,name=broadcaster_user_id,json=broadcasterUserId,proto3" json:"broadcaster_user_id,omitempty"`
	// The reward that was redeemed.
	Reward *CustomReward `protobuf:"bytes,4,opt,name=reward,proto3" json:"reward,omitempty"`
	// The user-supplied input, if any.
	UserInput string `protobuf:"bytes,5,opt,name=user_input,json=userInput,proto3" json:"user_input,omitempty"`
	// The status of the redemption (UNFULFILLED, FULFILLED etc).
	Status RedemptionStatus `protobuf:"varint,6,opt,name=status,proto3,enum=channel_points_custom_reward_redemption.RedemptionStatus" json:"status,omitempty"`
	// The time the redemption was redeemed.
	RedeemedAt           *timestamp.Timestamp `protobuf:"bytes,7,opt,name=redeemed_at,json=redeemedAt,proto3" json:"redeemed_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ChannelPointsCustomRewardRedemptionCreate) Reset() {
	*m = ChannelPointsCustomRewardRedemptionCreate{}
}
func (m *ChannelPointsCustomRewardRedemptionCreate) String() string { return proto.CompactTextString(m) }
func (*ChannelPointsCustomRewardRedemptionCreate) ProtoMessage()    {}
func (*ChannelPointsCustomRewardRedemptionCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_195ad6c39cf80382, []int{0}
}
func (m *ChannelPointsCustomRewardRedemptionCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate.Unmarshal(m, b)
}
func (m *ChannelPointsCustomRewardRedemptionCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate.Marshal(b, m, deterministic)
}
func (dst *ChannelPointsCustomRewardRedemptionCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate.Merge(dst, src)
}
func (m *ChannelPointsCustomRewardRedemptionCreate) XXX_Size() int {
	return xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate.Size(m)
}
func (m *ChannelPointsCustomRewardRedemptionCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate proto.InternalMessageInfo

func (m *ChannelPointsCustomRewardRedemptionCreate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetBroadcasterUserId() string {
	if m != nil {
		return m.BroadcasterUserId
	}
	return ""
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetReward() *CustomReward {
	if m != nil {
		return m.Reward
	}
	return nil
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetUserInput() string {
	if m != nil {
		return m.UserInput
	}
	return ""
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetStatus() RedemptionStatus {
	if m != nil {
		return m.Status
	}
	return RedemptionStatus_REDEMPTION_STATUS_INVALID
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetRedeemedAt() *timestamp.Timestamp {
	if m != nil {
		return m.RedeemedAt
	}
	return nil
}

// CustomReward contains basic information about the reward that was redeemed.
type CustomReward struct {
	// The reward’s unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the channel the reward belongs to.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// A short title used to describe the reward.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// The user-facing prompt that was shown when the user redeemed the reward.
	Prompt string `protobuf:"bytes,4,opt,name=prompt,proto3" json:"prompt,omitempty"`
	// Number of points the reward cost.
	Cost                 int64    `protobuf:"varint,5,opt,name=cost,proto3" json:"cost,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CustomReward) Reset()         { *m = CustomReward{} }
func (m *CustomReward) String() string { return proto.CompactTextString(m) }
func (*CustomReward) ProtoMessage()    {}
func (*CustomReward) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_195ad6c39cf80382, []int{1}
}
func (m *CustomReward) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomReward.Unmarshal(m, b)
}
func (m *CustomReward) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomReward.Marshal(b, m, deterministic)
}
func (dst *CustomReward) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomReward.Merge(dst, src)
}
func (m *CustomReward) XXX_Size() int {
	return xxx_messageInfo_CustomReward.Size(m)
}
func (m *CustomReward) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomReward.DiscardUnknown(m)
}

var xxx_messageInfo_CustomReward proto.InternalMessageInfo

func (m *CustomReward) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CustomReward) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *CustomReward) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *CustomReward) GetPrompt() string {
	if m != nil {
		return m.Prompt
	}
	return ""
}

func (m *CustomReward) GetCost() int64 {
	if m != nil {
		return m.Cost
	}
	return 0
}

func init() {
	proto.RegisterType((*ChannelPointsCustomRewardRedemptionCreate)(nil), "channel_points_custom_reward_redemption.ChannelPointsCustomRewardRedemptionCreate")
	proto.RegisterType((*CustomReward)(nil), "channel_points_custom_reward_redemption.CustomReward")
	proto.RegisterEnum("channel_points_custom_reward_redemption.RedemptionStatus", RedemptionStatus_name, RedemptionStatus_value)
}

func init() {
	proto.RegisterFile("channel_points_custom_reward_redemption/create.proto", fileDescriptor_create_195ad6c39cf80382)
}

var fileDescriptor_create_195ad6c39cf80382 = []byte{
	// 432 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x93, 0x41, 0x6f, 0xd3, 0x30,
	0x14, 0xc7, 0x49, 0xdb, 0x65, 0xea, 0x1b, 0x9a, 0x8a, 0x41, 0x10, 0x8a, 0xca, 0xca, 0x2e, 0x74,
	0x1c, 0x52, 0x69, 0xc0, 0x01, 0x71, 0x2a, 0x69, 0x26, 0x45, 0xea, 0xba, 0xe2, 0xa6, 0x1c, 0xb8,
	0x58, 0x69, 0x6c, 0x46, 0xa4, 0x26, 0x8e, 0xec, 0x17, 0x21, 0xae, 0x7c, 0x27, 0xbe, 0x1f, 0xaa,
	0xdd, 0xb0, 0x42, 0x77, 0xc8, 0x2d, 0xf6, 0xfb, 0xfb, 0xf7, 0xde, 0xfb, 0x49, 0x81, 0x77, 0xe9,
	0xf7, 0xa4, 0x28, 0xc4, 0x86, 0x95, 0x32, 0x2b, 0x50, 0xb3, 0xb4, 0xd2, 0x28, 0x73, 0xa6, 0xc4,
	0x8f, 0x44, 0x71, 0xa6, 0x04, 0x17, 0x79, 0x89, 0x99, 0x2c, 0xc6, 0xa9, 0x12, 0x09, 0x0a, 0xbf,
	0x54, 0x12, 0x25, 0x79, 0xdd, 0xf0, 0x55, 0xff, 0xec, 0x56, 0xca, 0xdb, 0x8d, 0x18, 0x9b, 0x67,
	0xeb, 0xea, 0xdb, 0x18, 0xb3, 0x5c, 0x68, 0x4c, 0xf2, 0xd2, 0x92, 0xce, 0x7f, 0xb5, 0xe1, 0x22,
	0xb0, 0xb0, 0x85, 0x61, 0x05, 0x06, 0x45, 0x0d, 0x89, 0xfe, 0x05, 0x05, 0xa6, 0x3b, 0x39, 0x85,
	0x56, 0xc6, 0x3d, 0x67, 0xe8, 0x8c, 0xba, 0xb4, 0x95, 0x71, 0xf2, 0x0c, 0x8e, 0x2b, 0x2d, 0x14,
	0xcb, 0xb8, 0xd7, 0x32, 0x97, 0xee, 0xf6, 0x18, 0x71, 0xe2, 0xc3, 0xe3, 0xb5, 0x92, 0x09, 0x4f,
	0x13, 0x8d, 0x42, 0xb1, 0x3a, 0xd4, 0x36, 0xa1, 0x47, 0x7b, 0xa5, 0x95, 0xcd, 0x5f, 0x83, 0x6b,
	0x87, 0xf7, 0x3a, 0x43, 0x67, 0x74, 0x72, 0xf9, 0xde, 0x6f, 0xb8, 0xa1, 0xff, 0xcf, 0xbc, 0x3b,
	0x08, 0x19, 0x00, 0xd8, 0x96, 0x45, 0x59, 0xa1, 0x77, 0x64, 0xba, 0x76, 0xcd, 0x68, 0xdb, 0x0b,
	0xf2, 0x19, 0x5c, 0x8d, 0x09, 0x56, 0xda, 0x73, 0x87, 0xce, 0xe8, 0xf4, 0xf2, 0x43, 0xe3, 0x6e,
	0x77, 0x46, 0x96, 0x06, 0x40, 0x77, 0x20, 0xf2, 0x11, 0x4e, 0xb6, 0x31, 0x91, 0x0b, 0xce, 0x12,
	0xf4, 0x8e, 0xcd, 0x16, 0x7d, 0xdf, 0xea, 0xf7, 0x6b, 0xfd, 0x7e, 0x5c, 0xeb, 0xa7, 0x50, 0xc7,
	0x27, 0x78, 0xfe, 0x13, 0x1e, 0xee, 0xaf, 0xd1, 0x5c, 0xf3, 0x13, 0x38, 0xc2, 0x0c, 0x37, 0x62,
	0x27, 0xd6, 0x1e, 0xc8, 0x53, 0x70, 0x4b, 0x25, 0xf3, 0x12, 0x8d, 0xcc, 0x2e, 0xdd, 0x9d, 0x08,
	0x81, 0x4e, 0x2a, 0xb5, 0xf5, 0xd1, 0xa6, 0xe6, 0xfb, 0xcd, 0x6f, 0x07, 0x7a, 0xff, 0x2f, 0x45,
	0x06, 0xf0, 0x9c, 0x86, 0xd3, 0xf0, 0x7a, 0x11, 0x47, 0x37, 0x73, 0xb6, 0x8c, 0x27, 0xf1, 0x6a,
	0xc9, 0xa2, 0xf9, 0x97, 0xc9, 0x2c, 0x9a, 0xf6, 0x1e, 0x90, 0x57, 0x30, 0x38, 0x2c, 0xaf, 0xe6,
	0x57, 0xab, 0xd9, 0x55, 0x34, 0x9b, 0x85, 0xd3, 0x9e, 0x43, 0xce, 0xe0, 0xc5, 0x61, 0xe4, 0x2e,
	0xd0, 0x22, 0x2f, 0xa1, 0x7f, 0x18, 0x08, 0x26, 0xf3, 0x20, 0xdc, 0xd6, 0xdb, 0xf7, 0xd7, 0x69,
	0xb8, 0xb8, 0xa1, 0x71, 0x38, 0xed, 0x75, 0x3e, 0x5d, 0x7c, 0x6d, 0xfa, 0x0f, 0xac, 0x5d, 0x63,
	0xff, 0xed, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x3b, 0xfd, 0x9f, 0xf6, 0x6b, 0x03, 0x00, 0x00,
}
