// Code generated by protoc-gen-go. DO NOT EDIT.
// source: commercial/update.proto

package commercial

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The different types of possible commercial formats.
type CommercialType int32

const (
	// An unknown or invalid ad format.
	CommercialType_COMMERCIAL_TYPE_INVALID CommercialType = 0
	// The standard ad format.
	CommercialType_COMMERCIAL_TYPE_STANDARD CommercialType = 1
	// The Picture-By-Picture ad format.
	CommercialType_COMMERCIAL_TYPE_PICTURE_BY_PICTURE CommercialType = 2
	// Auto-ad played in the standard ad format.
	CommercialType_COMMERCIAL_TYPE_AUTO_STANDARD CommercialType = 3
	// Auto-ad played in the Picture-By-Picture ad format.
	CommercialType_COMMERCIAL_TYPE_AUTO_PICTURE_BY_PICTURE CommercialType = 4
)

var CommercialType_name = map[int32]string{
	0: "COMMERCIAL_TYPE_INVALID",
	1: "COMMERCIAL_TYPE_STANDARD",
	2: "COMMERCIAL_TYPE_PICTURE_BY_PICTURE",
	3: "COMMERCIAL_TYPE_AUTO_STANDARD",
	4: "COMMERCIAL_TYPE_AUTO_PICTURE_BY_PICTURE",
}
var CommercialType_value = map[string]int32{
	"COMMERCIAL_TYPE_INVALID":                 0,
	"COMMERCIAL_TYPE_STANDARD":                1,
	"COMMERCIAL_TYPE_PICTURE_BY_PICTURE":      2,
	"COMMERCIAL_TYPE_AUTO_STANDARD":           3,
	"COMMERCIAL_TYPE_AUTO_PICTURE_BY_PICTURE": 4,
}

func (x CommercialType) String() string {
	return proto.EnumName(CommercialType_name, int32(x))
}
func (CommercialType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_029baca9543b7069, []int{0}
}

// The different commercial status types that can be returned.
type CommercialStatus int32

const (
	// Indicates an unknown or invalid failure.
	CommercialStatus_COMMERCIAL_STATUS_INVALID CommercialStatus = 0
	// Indicates a commercial was successfully injected into the stream.
	CommercialStatus_COMMERCIAL_STATUS_SUCCESS CommercialStatus = 1
	// Indicates a timeout occurred.
	CommercialStatus_COMMERCIAL_STATUS_TIMEOUT CommercialStatus = 2
	// Indicates a commercial was not successfully injected into the stream.
	CommercialStatus_COMMERCIAL_STATUS_INJECTION_FAILED CommercialStatus = 3
)

var CommercialStatus_name = map[int32]string{
	0: "COMMERCIAL_STATUS_INVALID",
	1: "COMMERCIAL_STATUS_SUCCESS",
	2: "COMMERCIAL_STATUS_TIMEOUT",
	3: "COMMERCIAL_STATUS_INJECTION_FAILED",
}
var CommercialStatus_value = map[string]int32{
	"COMMERCIAL_STATUS_INVALID":          0,
	"COMMERCIAL_STATUS_SUCCESS":          1,
	"COMMERCIAL_STATUS_TIMEOUT":          2,
	"COMMERCIAL_STATUS_INJECTION_FAILED": 3,
}

func (x CommercialStatus) String() string {
	return proto.EnumName(CommercialStatus_name, int32(x))
}
func (CommercialStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_029baca9543b7069, []int{1}
}

// CommercialUpdate indicates the status change of an ad request.
// It is triggered when GoTranscode confirms whether or not an ad
// was successfully injected into the stream as an ID3 tag or when
// a timeout occurs.
type CommercialUpdate struct {
	// The ID of the commercial.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The type of requested commercial.
	Type CommercialType `protobuf:"varint,2,opt,name=type,proto3,enum=commercial.CommercialType" json:"type,omitempty"`
	// The user/channel ID of the broadcaster.
	UserId string `protobuf:"bytes,3,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// The duration of the requested commercial in seconds.
	Duration int32 `protobuf:"varint,4,opt,name=duration,proto3" json:"duration,omitempty"`
	// The ID of the user that requested the commercial.
	RequesterUserId string `protobuf:"bytes,5,opt,name=requester_user_id,json=requesterUserId,proto3" json:"requester_user_id,omitempty"`
	// The status of the commercial request.
	Status               CommercialStatus `protobuf:"varint,6,opt,name=status,proto3,enum=commercial.CommercialStatus" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *CommercialUpdate) Reset()         { *m = CommercialUpdate{} }
func (m *CommercialUpdate) String() string { return proto.CompactTextString(m) }
func (*CommercialUpdate) ProtoMessage()    {}
func (*CommercialUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_029baca9543b7069, []int{0}
}
func (m *CommercialUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommercialUpdate.Unmarshal(m, b)
}
func (m *CommercialUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommercialUpdate.Marshal(b, m, deterministic)
}
func (dst *CommercialUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommercialUpdate.Merge(dst, src)
}
func (m *CommercialUpdate) XXX_Size() int {
	return xxx_messageInfo_CommercialUpdate.Size(m)
}
func (m *CommercialUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_CommercialUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_CommercialUpdate proto.InternalMessageInfo

func (m *CommercialUpdate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CommercialUpdate) GetType() CommercialType {
	if m != nil {
		return m.Type
	}
	return CommercialType_COMMERCIAL_TYPE_INVALID
}

func (m *CommercialUpdate) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *CommercialUpdate) GetDuration() int32 {
	if m != nil {
		return m.Duration
	}
	return 0
}

func (m *CommercialUpdate) GetRequesterUserId() string {
	if m != nil {
		return m.RequesterUserId
	}
	return ""
}

func (m *CommercialUpdate) GetStatus() CommercialStatus {
	if m != nil {
		return m.Status
	}
	return CommercialStatus_COMMERCIAL_STATUS_INVALID
}

func init() {
	proto.RegisterType((*CommercialUpdate)(nil), "commercial.CommercialUpdate")
	proto.RegisterEnum("commercial.CommercialType", CommercialType_name, CommercialType_value)
	proto.RegisterEnum("commercial.CommercialStatus", CommercialStatus_name, CommercialStatus_value)
}

func init() { proto.RegisterFile("commercial/update.proto", fileDescriptor_update_029baca9543b7069) }

var fileDescriptor_update_029baca9543b7069 = []byte{
	// 356 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x92, 0xc1, 0x4e, 0xb3, 0x40,
	0x14, 0x85, 0xff, 0xa1, 0x2d, 0xbf, 0xde, 0x98, 0x8a, 0xb3, 0x29, 0xd6, 0x36, 0xa9, 0x5d, 0x68,
	0x53, 0x13, 0x4c, 0xd4, 0x17, 0xa0, 0x80, 0xc9, 0x98, 0xb6, 0x34, 0x30, 0x98, 0xd4, 0x0d, 0xc1,
	0x32, 0x0b, 0x12, 0x2b, 0x08, 0xc3, 0xa2, 0x4f, 0xe2, 0x03, 0xf9, 0x34, 0xbe, 0x85, 0x71, 0x6a,
	0xa1, 0x25, 0xec, 0xe6, 0xe6, 0x9c, 0xf3, 0xe5, 0x9e, 0xcc, 0x85, 0xce, 0x2a, 0x5e, 0xaf, 0x59,
	0xba, 0x8a, 0x82, 0xb7, 0xdb, 0x3c, 0x09, 0x03, 0xce, 0xb4, 0x24, 0x8d, 0x79, 0x8c, 0xa1, 0x14,
	0x86, 0xdf, 0x08, 0x14, 0xa3, 0x18, 0x3d, 0x61, 0xc3, 0x6d, 0x90, 0xa2, 0x50, 0x45, 0x03, 0x34,
	0x3a, 0x76, 0xa4, 0x28, 0xc4, 0x1a, 0x34, 0xf9, 0x26, 0x61, 0xaa, 0x34, 0x40, 0xa3, 0xf6, 0x5d,
	0x57, 0x2b, 0xf3, 0x5a, 0x99, 0xa5, 0x9b, 0x84, 0x39, 0xc2, 0x87, 0x3b, 0xf0, 0x3f, 0xcf, 0x58,
	0xea, 0x47, 0xa1, 0xda, 0x10, 0x10, 0xf9, 0x77, 0x24, 0x21, 0xee, 0xc2, 0x51, 0x98, 0xa7, 0x01,
	0x8f, 0xe2, 0x77, 0xb5, 0x39, 0x40, 0xa3, 0x96, 0x53, 0xcc, 0x78, 0x0c, 0x67, 0x29, 0xfb, 0xc8,
	0x59, 0xc6, 0x59, 0xea, 0xef, 0xe2, 0x2d, 0x11, 0x3f, 0x2d, 0x04, 0x6f, 0xcb, 0x79, 0x00, 0x39,
	0xe3, 0x01, 0xcf, 0x33, 0x55, 0x16, 0x2b, 0xf5, 0xea, 0x57, 0x72, 0x85, 0xc7, 0xf9, 0xf3, 0x8e,
	0xbf, 0x10, 0xb4, 0x0f, 0xf7, 0xc5, 0x17, 0xd0, 0x31, 0xec, 0xd9, 0xcc, 0x72, 0x0c, 0xa2, 0x4f,
	0x7d, 0xba, 0x5c, 0x58, 0x3e, 0x99, 0x3f, 0xeb, 0x53, 0x62, 0x2a, 0xff, 0x70, 0x0f, 0xd4, 0xaa,
	0xe8, 0x52, 0x7d, 0x6e, 0xea, 0x8e, 0xa9, 0x20, 0x7c, 0x05, 0xc3, 0xaa, 0xba, 0x20, 0x06, 0xf5,
	0x1c, 0xcb, 0x9f, 0x2c, 0x77, 0x4f, 0x45, 0xc2, 0x97, 0xd0, 0xaf, 0xfa, 0x74, 0x8f, 0xda, 0x25,
	0xaa, 0x81, 0x6f, 0xe0, 0xba, 0xd6, 0x52, 0xc3, 0x6b, 0x8e, 0x3f, 0x0f, 0x7e, 0x6c, 0x5b, 0x11,
	0xf7, 0xe1, 0x7c, 0x8f, 0xe0, 0x52, 0x9d, 0x7a, 0xee, 0x5e, 0x93, 0x5a, 0xd9, 0xf5, 0x0c, 0xc3,
	0x72, 0x5d, 0x05, 0xd5, 0xcb, 0x94, 0xcc, 0x2c, 0xdb, 0xa3, 0x8a, 0x54, 0x69, 0x5a, 0xc0, 0x9f,
	0x2c, 0x83, 0x12, 0x7b, 0xee, 0x3f, 0xea, 0x64, 0x6a, 0x99, 0x4a, 0x63, 0x72, 0xf2, 0xb2, 0x77,
	0x59, 0xaf, 0xb2, 0x38, 0xb6, 0xfb, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x7e, 0x2e, 0x93,
	0x87, 0x02, 0x00, 0x00,
}
