// Code generated by protoc-gen-go. DO NOT EDIT.
// source: poll_synchronization/update.proto

package poll_synchronization

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// This is the type of poll being updated.
type PollType int32

const (
	// Something went wrong determining the state.
	PollType_POLL_TYPE_INVALID PollType = 0
	// The poll is a channel poll
	PollType_POLL_TYPE_CHANNEL PollType = 1
	// The poll is an ad poll
	PollType_POLL_TYPE_AD PollType = 2
)

var PollType_name = map[int32]string{
	0: "POLL_TYPE_INVALID",
	1: "POLL_TYPE_CHANNEL",
	2: "POLL_TYPE_AD",
}
var PollType_value = map[string]int32{
	"POLL_TYPE_INVALID": 0,
	"POLL_TYPE_CHANNEL": 1,
	"POLL_TYPE_AD":      2,
}

func (x PollType) String() string {
	return proto.EnumName(PollType_name, int32(x))
}
func (PollType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_e963f086fdcd63f9, []int{0}
}

// This describes what type of update is being made to the poll. This is different than
// the PollStatus in the Poll message, as that describes the current state of the poll
// and not the reason for the eventbus event. They are similar, but are not the same.
type PollSynchronizationUpdateType int32

const (
	// This is not a valid poll update type.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_INVALID PollSynchronizationUpdateType = 0
	// The poll has just been created by the backend service.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_CREATE PollSynchronizationUpdateType = 1
	// The poll was just updated by the backend.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_UPDATE PollSynchronizationUpdateType = 2
	// The poll has just been completed naturally.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_COMPLETE PollSynchronizationUpdateType = 3
	// The poll has been prematurely terminated by something/someone.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_TERMINATE PollSynchronizationUpdateType = 4
	// The poll has been archived so the public can't view it.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_ARCHIVE PollSynchronizationUpdateType = 5
	// The poll has been moderated so nobody can see it.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_MODERATE PollSynchronizationUpdateType = 6
)

var PollSynchronizationUpdateType_name = map[int32]string{
	0: "POLL_SYNCHRONIZATION_UPDATE_TYPE_INVALID",
	1: "POLL_SYNCHRONIZATION_UPDATE_TYPE_CREATE",
	2: "POLL_SYNCHRONIZATION_UPDATE_TYPE_UPDATE",
	3: "POLL_SYNCHRONIZATION_UPDATE_TYPE_COMPLETE",
	4: "POLL_SYNCHRONIZATION_UPDATE_TYPE_TERMINATE",
	5: "POLL_SYNCHRONIZATION_UPDATE_TYPE_ARCHIVE",
	6: "POLL_SYNCHRONIZATION_UPDATE_TYPE_MODERATE",
}
var PollSynchronizationUpdateType_value = map[string]int32{
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_INVALID":   0,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_CREATE":    1,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_UPDATE":    2,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_COMPLETE":  3,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_TERMINATE": 4,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_ARCHIVE":   5,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_MODERATE":  6,
}

func (x PollSynchronizationUpdateType) String() string {
	return proto.EnumName(PollSynchronizationUpdateType_name, int32(x))
}
func (PollSynchronizationUpdateType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_e963f086fdcd63f9, []int{1}
}

// Status of a poll, describing its lifecycle state.
type Poll_PollStatus int32

const (
	// Something went wrong determining the state :monkaS:.
	Poll_POLL_STATUS_INVALID Poll_PollStatus = 0
	// Poll is ACTIVE and users can vote.
	Poll_POLL_STATUS_ACTIVE Poll_PollStatus = 1
	// Poll ran its entire duration and "naturally" completed. Users cannot
	// vote, but results are publicly visible.
	Poll_POLL_STATUS_COMPLETED Poll_PollStatus = 2
	// Poll was manually terminated by owner before it ran its entire duration.
	// Users cannot vote, but results are publicly visible.
	Poll_POLL_STATUS_TERMINATED Poll_PollStatus = 3
	// Poll is no longer publicly visible to users.
	Poll_POLL_STATUS_ARCHIVED Poll_PollStatus = 4
	// Poll is no longer visible to any user on Twitch.
	Poll_POLL_STATUS_MODERATED Poll_PollStatus = 5
)

var Poll_PollStatus_name = map[int32]string{
	0: "POLL_STATUS_INVALID",
	1: "POLL_STATUS_ACTIVE",
	2: "POLL_STATUS_COMPLETED",
	3: "POLL_STATUS_TERMINATED",
	4: "POLL_STATUS_ARCHIVED",
	5: "POLL_STATUS_MODERATED",
}
var Poll_PollStatus_value = map[string]int32{
	"POLL_STATUS_INVALID":    0,
	"POLL_STATUS_ACTIVE":     1,
	"POLL_STATUS_COMPLETED":  2,
	"POLL_STATUS_TERMINATED": 3,
	"POLL_STATUS_ARCHIVED":   4,
	"POLL_STATUS_MODERATED":  5,
}

func (x Poll_PollStatus) String() string {
	return proto.EnumName(Poll_PollStatus_name, int32(x))
}
func (Poll_PollStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_e963f086fdcd63f9, []int{1, 0}
}

// PollSynchronizationUpdate triggers when a poll is changed.
type PollSynchronizationUpdate struct {
	// What type of update the poll is receiving
	UpdateType PollSynchronizationUpdateType `protobuf:"varint,1,opt,name=update_type,json=updateType,proto3,enum=poll_synchronization.PollSynchronizationUpdateType" json:"update_type,omitempty"`
	// Type of poll being updated in the event
	PollType PollType `protobuf:"varint,2,opt,name=poll_type,json=pollType,proto3,enum=poll_synchronization.PollType" json:"poll_type,omitempty"`
	// The poll object being updated
	Poll                 *Poll    `protobuf:"bytes,3,opt,name=poll,proto3" json:"poll,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PollSynchronizationUpdate) Reset()         { *m = PollSynchronizationUpdate{} }
func (m *PollSynchronizationUpdate) String() string { return proto.CompactTextString(m) }
func (*PollSynchronizationUpdate) ProtoMessage()    {}
func (*PollSynchronizationUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_e963f086fdcd63f9, []int{0}
}
func (m *PollSynchronizationUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PollSynchronizationUpdate.Unmarshal(m, b)
}
func (m *PollSynchronizationUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PollSynchronizationUpdate.Marshal(b, m, deterministic)
}
func (dst *PollSynchronizationUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollSynchronizationUpdate.Merge(dst, src)
}
func (m *PollSynchronizationUpdate) XXX_Size() int {
	return xxx_messageInfo_PollSynchronizationUpdate.Size(m)
}
func (m *PollSynchronizationUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_PollSynchronizationUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_PollSynchronizationUpdate proto.InternalMessageInfo

func (m *PollSynchronizationUpdate) GetUpdateType() PollSynchronizationUpdateType {
	if m != nil {
		return m.UpdateType
	}
	return PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_INVALID
}

func (m *PollSynchronizationUpdate) GetPollType() PollType {
	if m != nil {
		return m.PollType
	}
	return PollType_POLL_TYPE_INVALID
}

func (m *PollSynchronizationUpdate) GetPoll() *Poll {
	if m != nil {
		return m.Poll
	}
	return nil
}

// Information about a poll.
type Poll struct {
	// This is the ID of the poll.
	PollId string `protobuf:"bytes,1,opt,name=poll_id,json=pollId,proto3" json:"poll_id,omitempty"`
	// This is the User/brand who owns the poll.
	OwnerId string `protobuf:"bytes,2,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// This is the title of the poll.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// This is the time the poll starts at.
	StartAt *timestamp.Timestamp `protobuf:"bytes,4,opt,name=start_at,json=startAt,proto3" json:"start_at,omitempty"`
	// Time the poll ends at
	EndAt *timestamp.Timestamp `protobuf:"bytes,5,opt,name=end_at,json=endAt,proto3" json:"end_at,omitempty"`
	// Duration of the poll
	Duration *duration.Duration `protobuf:"bytes,6,opt,name=duration,proto3" json:"duration,omitempty"`
	// Settings for the poll
	Settings *Poll_PollSettings `protobuf:"bytes,7,opt,name=settings,proto3" json:"settings,omitempty"`
	// Current status of the poll
	Status Poll_PollStatus `protobuf:"varint,8,opt,name=status,proto3,enum=poll_synchronization.Poll_PollStatus" json:"status,omitempty"`
	// Information about the choices.
	Choices []*Poll_Choice `protobuf:"bytes,9,rep,name=choices,proto3" json:"choices,omitempty"`
	// A breakdown of how many tokens were spent in the poll.
	TotalVotes int64 `protobuf:"varint,10,opt,name=total_votes,json=totalVotes,proto3" json:"total_votes,omitempty"`
	// Total number of unique voters in the poll. A voter can vote more than
	// once, so the number of votes don't have to match with the number of voters
	TotalVoters int64 `protobuf:"varint,11,opt,name=total_voters,json=totalVoters,proto3" json:"total_voters,omitempty"`
	// Duration remaining before poll completes. This will be nil if the remaining duration is 0 or
	// the poll is over as protobuf will drop what it considers empty.
	RemainingDuration    *duration.Duration `protobuf:"bytes,12,opt,name=remaining_duration,json=remainingDuration,proto3" json:"remaining_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Poll) Reset()         { *m = Poll{} }
func (m *Poll) String() string { return proto.CompactTextString(m) }
func (*Poll) ProtoMessage()    {}
func (*Poll) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_e963f086fdcd63f9, []int{1}
}
func (m *Poll) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Poll.Unmarshal(m, b)
}
func (m *Poll) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Poll.Marshal(b, m, deterministic)
}
func (dst *Poll) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Poll.Merge(dst, src)
}
func (m *Poll) XXX_Size() int {
	return xxx_messageInfo_Poll.Size(m)
}
func (m *Poll) XXX_DiscardUnknown() {
	xxx_messageInfo_Poll.DiscardUnknown(m)
}

var xxx_messageInfo_Poll proto.InternalMessageInfo

func (m *Poll) GetPollId() string {
	if m != nil {
		return m.PollId
	}
	return ""
}

func (m *Poll) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *Poll) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Poll) GetStartAt() *timestamp.Timestamp {
	if m != nil {
		return m.StartAt
	}
	return nil
}

func (m *Poll) GetEndAt() *timestamp.Timestamp {
	if m != nil {
		return m.EndAt
	}
	return nil
}

func (m *Poll) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *Poll) GetSettings() *Poll_PollSettings {
	if m != nil {
		return m.Settings
	}
	return nil
}

func (m *Poll) GetStatus() Poll_PollStatus {
	if m != nil {
		return m.Status
	}
	return Poll_POLL_STATUS_INVALID
}

func (m *Poll) GetChoices() []*Poll_Choice {
	if m != nil {
		return m.Choices
	}
	return nil
}

func (m *Poll) GetTotalVotes() int64 {
	if m != nil {
		return m.TotalVotes
	}
	return 0
}

func (m *Poll) GetTotalVoters() int64 {
	if m != nil {
		return m.TotalVoters
	}
	return 0
}

func (m *Poll) GetRemainingDuration() *duration.Duration {
	if m != nil {
		return m.RemainingDuration
	}
	return nil
}

// Controls settings on the poll.
type Poll_PollSettings struct {
	MultiChoice          *Poll_PollSettings_MultiChoicePollSetting `protobuf:"bytes,1,opt,name=multi_choice,json=multiChoice,proto3" json:"multi_choice,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *Poll_PollSettings) Reset()         { *m = Poll_PollSettings{} }
func (m *Poll_PollSettings) String() string { return proto.CompactTextString(m) }
func (*Poll_PollSettings) ProtoMessage()    {}
func (*Poll_PollSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_e963f086fdcd63f9, []int{1, 0}
}
func (m *Poll_PollSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Poll_PollSettings.Unmarshal(m, b)
}
func (m *Poll_PollSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Poll_PollSettings.Marshal(b, m, deterministic)
}
func (dst *Poll_PollSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Poll_PollSettings.Merge(dst, src)
}
func (m *Poll_PollSettings) XXX_Size() int {
	return xxx_messageInfo_Poll_PollSettings.Size(m)
}
func (m *Poll_PollSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_Poll_PollSettings.DiscardUnknown(m)
}

var xxx_messageInfo_Poll_PollSettings proto.InternalMessageInfo

func (m *Poll_PollSettings) GetMultiChoice() *Poll_PollSettings_MultiChoicePollSetting {
	if m != nil {
		return m.MultiChoice
	}
	return nil
}

// Controls whether users can vote for multiple choices.
type Poll_PollSettings_MultiChoicePollSetting struct {
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Poll_PollSettings_MultiChoicePollSetting) Reset() {
	*m = Poll_PollSettings_MultiChoicePollSetting{}
}
func (m *Poll_PollSettings_MultiChoicePollSetting) String() string { return proto.CompactTextString(m) }
func (*Poll_PollSettings_MultiChoicePollSetting) ProtoMessage()    {}
func (*Poll_PollSettings_MultiChoicePollSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_e963f086fdcd63f9, []int{1, 0, 0}
}
func (m *Poll_PollSettings_MultiChoicePollSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting.Unmarshal(m, b)
}
func (m *Poll_PollSettings_MultiChoicePollSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting.Marshal(b, m, deterministic)
}
func (dst *Poll_PollSettings_MultiChoicePollSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting.Merge(dst, src)
}
func (m *Poll_PollSettings_MultiChoicePollSetting) XXX_Size() int {
	return xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting.Size(m)
}
func (m *Poll_PollSettings_MultiChoicePollSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting proto.InternalMessageInfo

func (m *Poll_PollSettings_MultiChoicePollSetting) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Information about a choice in a poll.
type Poll_Choice struct {
	// ID of the poll choice
	ChoiceId string `protobuf:"bytes,1,opt,name=choice_id,json=choiceId,proto3" json:"choice_id,omitempty"`
	// Title of the choice
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Image url of the poll choice
	ImageUrl string `protobuf:"bytes,3,opt,name=image_url,json=imageUrl,proto3" json:"image_url,omitempty"`
	// A breakdown of how many votes were cast for the choice.
	TotalVotes int64 `protobuf:"varint,4,opt,name=total_votes,json=totalVotes,proto3" json:"total_votes,omitempty"`
	// Total number of unique voters for the choice.
	TotalVoters          int64    `protobuf:"varint,5,opt,name=total_voters,json=totalVoters,proto3" json:"total_voters,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Poll_Choice) Reset()         { *m = Poll_Choice{} }
func (m *Poll_Choice) String() string { return proto.CompactTextString(m) }
func (*Poll_Choice) ProtoMessage()    {}
func (*Poll_Choice) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_e963f086fdcd63f9, []int{1, 1}
}
func (m *Poll_Choice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Poll_Choice.Unmarshal(m, b)
}
func (m *Poll_Choice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Poll_Choice.Marshal(b, m, deterministic)
}
func (dst *Poll_Choice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Poll_Choice.Merge(dst, src)
}
func (m *Poll_Choice) XXX_Size() int {
	return xxx_messageInfo_Poll_Choice.Size(m)
}
func (m *Poll_Choice) XXX_DiscardUnknown() {
	xxx_messageInfo_Poll_Choice.DiscardUnknown(m)
}

var xxx_messageInfo_Poll_Choice proto.InternalMessageInfo

func (m *Poll_Choice) GetChoiceId() string {
	if m != nil {
		return m.ChoiceId
	}
	return ""
}

func (m *Poll_Choice) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Poll_Choice) GetImageUrl() string {
	if m != nil {
		return m.ImageUrl
	}
	return ""
}

func (m *Poll_Choice) GetTotalVotes() int64 {
	if m != nil {
		return m.TotalVotes
	}
	return 0
}

func (m *Poll_Choice) GetTotalVoters() int64 {
	if m != nil {
		return m.TotalVoters
	}
	return 0
}

func init() {
	proto.RegisterType((*PollSynchronizationUpdate)(nil), "poll_synchronization.PollSynchronizationUpdate")
	proto.RegisterType((*Poll)(nil), "poll_synchronization.Poll")
	proto.RegisterType((*Poll_PollSettings)(nil), "poll_synchronization.Poll.PollSettings")
	proto.RegisterType((*Poll_PollSettings_MultiChoicePollSetting)(nil), "poll_synchronization.Poll.PollSettings.MultiChoicePollSetting")
	proto.RegisterType((*Poll_Choice)(nil), "poll_synchronization.Poll.Choice")
	proto.RegisterEnum("poll_synchronization.PollType", PollType_name, PollType_value)
	proto.RegisterEnum("poll_synchronization.PollSynchronizationUpdateType", PollSynchronizationUpdateType_name, PollSynchronizationUpdateType_value)
	proto.RegisterEnum("poll_synchronization.Poll_PollStatus", Poll_PollStatus_name, Poll_PollStatus_value)
}

func init() {
	proto.RegisterFile("poll_synchronization/update.proto", fileDescriptor_update_e963f086fdcd63f9)
}

var fileDescriptor_update_e963f086fdcd63f9 = []byte{
	// 760 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x95, 0xcd, 0x6e, 0xe2, 0x48,
	0x10, 0xc7, 0xd7, 0x7c, 0x9a, 0x32, 0x5a, 0x39, 0xbd, 0x09, 0x31, 0x44, 0x9b, 0x90, 0x48, 0xab,
	0xb0, 0xd9, 0x5d, 0x47, 0x4b, 0xb4, 0xa7, 0x68, 0x47, 0xf2, 0x18, 0x4b, 0x78, 0xc4, 0x97, 0x3a,
	0x06, 0x29, 0xb9, 0x58, 0x4e, 0xe8, 0x21, 0x96, 0x8c, 0x8d, 0xec, 0x66, 0x46, 0x99, 0x67, 0x99,
	0xeb, 0x1c, 0xe6, 0x3c, 0xef, 0x33, 0x97, 0x79, 0x91, 0x91, 0xdb, 0x36, 0x38, 0x04, 0x02, 0xb7,
	0xae, 0xaa, 0xdf, 0xbf, 0xba, 0xba, 0xaa, 0x30, 0x70, 0x3a, 0xf3, 0x1c, 0xc7, 0x0c, 0x9e, 0xdc,
	0x87, 0x47, 0xdf, 0x73, 0xed, 0x4f, 0x16, 0xb5, 0x3d, 0xf7, 0x72, 0x3e, 0x1b, 0x5b, 0x94, 0xc8,
	0x33, 0xdf, 0xa3, 0x1e, 0xda, 0x5f, 0x87, 0xd4, 0x8e, 0x27, 0x9e, 0x37, 0x71, 0xc8, 0x25, 0x63,
	0xee, 0xe7, 0xef, 0x2f, 0xc7, 0x73, 0x9f, 0x45, 0x22, 0x55, 0xed, 0x64, 0x35, 0x4e, 0xed, 0x29,
	0x09, 0xa8, 0x35, 0x9d, 0x45, 0xc0, 0xd9, 0x77, 0x0e, 0xaa, 0x03, 0xcf, 0x71, 0x6e, 0x9e, 0x27,
	0x1e, 0xb2, 0xab, 0x91, 0x01, 0x42, 0x54, 0x84, 0x49, 0x9f, 0x66, 0x44, 0xe2, 0xea, 0x5c, 0xe3,
	0xd7, 0xe6, 0x95, 0xbc, 0xae, 0x14, 0x79, 0x63, 0x16, 0xe3, 0x69, 0x46, 0x30, 0xcc, 0x17, 0x67,
	0x74, 0x0d, 0x25, 0x96, 0x81, 0xe5, 0xcc, 0xb0, 0x9c, 0xc7, 0x9b, 0x73, 0x32, 0x39, 0x3f, 0x8b,
	0x4f, 0x48, 0x86, 0x5c, 0x78, 0x96, 0xb2, 0x75, 0xae, 0x21, 0x34, 0x6b, 0x9b, 0x75, 0x98, 0x71,
	0x67, 0xdf, 0x78, 0xc8, 0x85, 0x26, 0x3a, 0x84, 0x22, 0x63, 0xed, 0x31, 0x7b, 0x47, 0x09, 0x17,
	0x42, 0x53, 0x1f, 0xa3, 0x2a, 0xf0, 0xde, 0x47, 0x97, 0xf8, 0x61, 0x24, 0xc3, 0x22, 0x45, 0x66,
	0xeb, 0x63, 0xb4, 0x0f, 0x79, 0x6a, 0x53, 0x87, 0xb0, 0xdb, 0x4a, 0x38, 0x32, 0xd0, 0x7f, 0xc0,
	0x07, 0xd4, 0xf2, 0xa9, 0x69, 0x51, 0x29, 0x17, 0x97, 0x11, 0xf5, 0x59, 0x4e, 0xfa, 0x2c, 0x1b,
	0x49, 0x9f, 0x71, 0x91, 0xb1, 0x0a, 0x45, 0xff, 0x42, 0x81, 0xb8, 0xe3, 0x50, 0x94, 0xdf, 0x2a,
	0xca, 0x13, 0x77, 0xac, 0xd0, 0xf0, 0xa6, 0x64, 0xa0, 0x52, 0x81, 0x89, 0xaa, 0x2f, 0x44, 0xad,
	0x18, 0xc0, 0x0b, 0x14, 0xa9, 0xc0, 0x07, 0x84, 0x52, 0xdb, 0x9d, 0x04, 0x52, 0x91, 0xc9, 0xce,
	0x37, 0xf7, 0x29, 0x1a, 0x5c, 0x8c, 0xe3, 0x85, 0x10, 0xfd, 0x0f, 0x85, 0x80, 0x5a, 0x74, 0x1e,
	0x48, 0x3c, 0x1b, 0xd1, 0x1f, 0xdb, 0x52, 0x30, 0x18, 0xc7, 0x22, 0x74, 0x0d, 0xc5, 0x87, 0x47,
	0xcf, 0x7e, 0x20, 0x81, 0x54, 0xaa, 0x67, 0x1b, 0x42, 0xf3, 0xf4, 0x15, 0xbd, 0xca, 0x48, 0x9c,
	0x28, 0xd0, 0x09, 0x08, 0xd4, 0xa3, 0x96, 0x63, 0x7e, 0xf0, 0x28, 0x09, 0x24, 0xa8, 0x73, 0x8d,
	0x2c, 0x06, 0xe6, 0x1a, 0x85, 0x1e, 0x74, 0x0a, 0xe5, 0x25, 0xe0, 0x07, 0x92, 0xc0, 0x08, 0x61,
	0x41, 0xf8, 0x01, 0x6a, 0x03, 0xf2, 0xc9, 0xd4, 0xb2, 0x5d, 0xdb, 0x9d, 0x98, 0x8b, 0x2e, 0x96,
	0xb7, 0x75, 0x71, 0x6f, 0x21, 0x4a, 0x5c, 0xb5, 0x2f, 0x1c, 0x94, 0xd3, 0x4d, 0x42, 0x16, 0x94,
	0xa7, 0x73, 0x87, 0xda, 0x66, 0x54, 0x2f, 0xdb, 0x27, 0xa1, 0xf9, 0x66, 0xc7, 0x1e, 0xcb, 0xdd,
	0x50, 0x1b, 0x3d, 0x39, 0xe5, 0xc7, 0xc2, 0x74, 0xe9, 0xaf, 0x35, 0xa1, 0xb2, 0x1e, 0x43, 0x12,
	0x14, 0x89, 0x6b, 0xdd, 0x3b, 0x24, 0xda, 0x63, 0x1e, 0x27, 0x66, 0xed, 0x33, 0x07, 0x85, 0x88,
	0x47, 0x47, 0x50, 0x8a, 0x6a, 0x5b, 0xae, 0x3b, 0x1f, 0x39, 0xd2, 0x5b, 0x9d, 0x49, 0x6f, 0xf5,
	0x11, 0x94, 0xec, 0xa9, 0x35, 0x21, 0xe6, 0xdc, 0x77, 0xe2, 0x7d, 0xe7, 0x99, 0x63, 0xe8, 0x3b,
	0xab, 0x03, 0xc9, 0x6d, 0x1d, 0x48, 0xfe, 0xc5, 0x40, 0xce, 0xbe, 0x72, 0x00, 0xcb, 0x45, 0x41,
	0x87, 0xf0, 0xdb, 0xa0, 0xdf, 0xe9, 0x98, 0x37, 0x86, 0x62, 0x0c, 0x6f, 0x4c, 0xbd, 0x37, 0x52,
	0x3a, 0x7a, 0x4b, 0xfc, 0x05, 0x55, 0x00, 0xa5, 0x03, 0x8a, 0x6a, 0xe8, 0x23, 0x4d, 0xe4, 0x50,
	0x15, 0x0e, 0xd2, 0x7e, 0xb5, 0xdf, 0x1d, 0x74, 0x34, 0x43, 0x6b, 0x89, 0x19, 0x54, 0x83, 0x4a,
	0x3a, 0x64, 0x68, 0xb8, 0xab, 0xf7, 0x94, 0x30, 0x96, 0x45, 0x12, 0xec, 0x3f, 0x4b, 0x87, 0xd5,
	0xb6, 0x3e, 0xd2, 0x5a, 0x62, 0x6e, 0x35, 0x61, 0xb7, 0xdf, 0xd2, 0x30, 0x13, 0xe5, 0x2f, 0xde,
	0x01, 0x9f, 0x7c, 0x7b, 0xd0, 0x01, 0xec, 0x31, 0xcc, 0xb8, 0x1d, 0x68, 0xa9, 0x32, 0x9f, 0xb9,
	0xd5, 0xb6, 0xd2, 0xeb, 0x69, 0x1d, 0x91, 0x43, 0x22, 0x94, 0x97, 0x6e, 0xa5, 0x25, 0x66, 0x2e,
	0x7e, 0x64, 0xe0, 0xf7, 0x57, 0x3f, 0x8e, 0xe8, 0x6f, 0x68, 0x44, 0x85, 0xdc, 0xf6, 0xd4, 0x36,
	0xee, 0xf7, 0xf4, 0x3b, 0xc5, 0xd0, 0xfb, 0x3d, 0x73, 0x38, 0x68, 0x29, 0x86, 0xb6, 0x7a, 0xf1,
	0x5f, 0x70, 0xbe, 0x95, 0x56, 0xb1, 0xa6, 0x18, 0x61, 0xd3, 0x76, 0x81, 0xa3, 0xb3, 0x98, 0x41,
	0xff, 0xc0, 0x9f, 0xdb, 0x33, 0xc7, 0x6d, 0x17, 0xb3, 0x48, 0x86, 0x8b, 0xad, 0xf8, 0x62, 0x14,
	0x62, 0x6e, 0xa7, 0x67, 0xc6, 0xe3, 0x11, 0xf3, 0x3b, 0x15, 0x93, 0x8c, 0x4c, 0x2c, 0xbc, 0xad,
	0xdc, 0xad, 0xfd, 0x87, 0xbc, 0x2f, 0xb0, 0x9f, 0xf8, 0xd5, 0xcf, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xab, 0x29, 0x7e, 0xb6, 0x63, 0x07, 0x00, 0x00,
}
