// Code generated by protoc-gen-go. DO NOT EDIT.
// source: user_recover/create.proto

package user_recover

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// SourceType is the source type of the account recovery.
type SourceType int32

const (
	// default to invalid
	SourceType_SOURCE_TYPE_INVALID SourceType = 0
	// if source type is unknown
	SourceType_SOURCE_TYPE_OTHER SourceType = 1
	// if request came from a SIRT mass account run
	SourceType_SOURCE_TYPE_BULK SourceType = 2
	// if request came from admin panel
	SourceType_SOURCE_TYPE_MANUAL SourceType = 3
)

var SourceType_name = map[int32]string{
	0: "SOURCE_TYPE_INVALID",
	1: "SOURCE_TYPE_OTHER",
	2: "SOURCE_TYPE_BULK",
	3: "SOURCE_TYPE_MANUAL",
}
var SourceType_value = map[string]int32{
	"SOURCE_TYPE_INVALID": 0,
	"SOURCE_TYPE_OTHER":   1,
	"SOURCE_TYPE_BULK":    2,
	"SOURCE_TYPE_MANUAL":  3,
}

func (x SourceType) String() string {
	return proto.EnumName(SourceType_name, int32(x))
}
func (SourceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_92b3a233b8b1fcbe, []int{0}
}

// UserRecoverCreate triggers when a account goes though the recovery process either in bulk during a SIRT or though admin panel.
type UserRecoverCreate struct {
	// user id that was recovered
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// ldap of the staff who initiated the account-recovery , required
	LdapRunner string `protobuf:"bytes,2,opt,name=ldap_runner,json=ldapRunner,proto3" json:"ldap_runner,omitempty"`
	// What is the type/source of recovery being preformed, required
	// “manual”, “bulk”, “other”
	SourceType SourceType `protobuf:"varint,3,opt,name=source_type,json=sourceType,proto3,enum=user_recover.SourceType" json:"source_type,omitempty"`
	// detail of the source, shows in admin panel audits, for example "SIRT-257" or "customer requested recovery"
	SourceDetail string `protobuf:"bytes,4,opt,name=source_detail,json=sourceDetail,proto3" json:"source_detail,omitempty"`
	// optional, when did the account become compromised
	CompromisedAt        *timestamp.Timestamp `protobuf:"bytes,5,opt,name=compromised_at,json=compromisedAt,proto3" json:"compromised_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UserRecoverCreate) Reset()         { *m = UserRecoverCreate{} }
func (m *UserRecoverCreate) String() string { return proto.CompactTextString(m) }
func (*UserRecoverCreate) ProtoMessage()    {}
func (*UserRecoverCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_92b3a233b8b1fcbe, []int{0}
}
func (m *UserRecoverCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserRecoverCreate.Unmarshal(m, b)
}
func (m *UserRecoverCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserRecoverCreate.Marshal(b, m, deterministic)
}
func (dst *UserRecoverCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserRecoverCreate.Merge(dst, src)
}
func (m *UserRecoverCreate) XXX_Size() int {
	return xxx_messageInfo_UserRecoverCreate.Size(m)
}
func (m *UserRecoverCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_UserRecoverCreate.DiscardUnknown(m)
}

var xxx_messageInfo_UserRecoverCreate proto.InternalMessageInfo

func (m *UserRecoverCreate) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UserRecoverCreate) GetLdapRunner() string {
	if m != nil {
		return m.LdapRunner
	}
	return ""
}

func (m *UserRecoverCreate) GetSourceType() SourceType {
	if m != nil {
		return m.SourceType
	}
	return SourceType_SOURCE_TYPE_INVALID
}

func (m *UserRecoverCreate) GetSourceDetail() string {
	if m != nil {
		return m.SourceDetail
	}
	return ""
}

func (m *UserRecoverCreate) GetCompromisedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CompromisedAt
	}
	return nil
}

func init() {
	proto.RegisterType((*UserRecoverCreate)(nil), "user_recover.UserRecoverCreate")
	proto.RegisterEnum("user_recover.SourceType", SourceType_name, SourceType_value)
}

func init() { proto.RegisterFile("user_recover/create.proto", fileDescriptor_create_92b3a233b8b1fcbe) }

var fileDescriptor_create_92b3a233b8b1fcbe = []byte{
	// 314 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0x91, 0x4b, 0x4f, 0xfa, 0x40,
	0x14, 0xc5, 0xff, 0x85, 0xbf, 0x18, 0x2f, 0x8f, 0x94, 0xf1, 0x41, 0x65, 0x03, 0xd1, 0x0d, 0x71,
	0x51, 0x12, 0x5c, 0xb9, 0x2c, 0x8f, 0x44, 0x22, 0x82, 0x19, 0x5a, 0x13, 0xdd, 0x34, 0xa5, 0xbd,
	0x92, 0x1a, 0xca, 0x4c, 0x66, 0xa6, 0x26, 0x7c, 0x6b, 0x3f, 0x82, 0x61, 0x2a, 0x3a, 0xee, 0xda,
	0xdf, 0xb9, 0xe7, 0xe4, 0x9c, 0x0c, 0x5c, 0xe6, 0x12, 0x45, 0x28, 0x30, 0x66, 0x1f, 0x28, 0xfa,
	0xb1, 0xc0, 0x48, 0xa1, 0xcb, 0x05, 0x53, 0x8c, 0xd4, 0x4c, 0xa9, 0xdd, 0x59, 0x33, 0xb6, 0xde,
	0x60, 0x5f, 0x6b, 0xab, 0xfc, 0xad, 0xaf, 0xd2, 0x0c, 0xa5, 0x8a, 0x32, 0x5e, 0x9c, 0x5f, 0x7d,
	0x5a, 0xd0, 0x0c, 0x24, 0x0a, 0x5a, 0x18, 0x46, 0x3a, 0x8a, 0xb4, 0xe0, 0x58, 0xc7, 0xa4, 0x89,
	0x63, 0x75, 0xad, 0xde, 0x09, 0xad, 0xec, 0x7f, 0xa7, 0x09, 0xe9, 0x40, 0x75, 0x93, 0x44, 0x3c,
	0x14, 0xf9, 0x76, 0x8b, 0xc2, 0x29, 0x69, 0x11, 0xf6, 0x88, 0x6a, 0x42, 0xee, 0xa0, 0x2a, 0x59,
	0x2e, 0x62, 0x0c, 0xd5, 0x8e, 0xa3, 0x53, 0xee, 0x5a, 0xbd, 0xc6, 0xc0, 0x71, 0xcd, 0x52, 0xee,
	0x52, 0x1f, 0xf8, 0x3b, 0x8e, 0x14, 0xe4, 0xcf, 0x37, 0xb9, 0x86, 0xfa, 0xb7, 0x35, 0x41, 0x15,
	0xa5, 0x1b, 0xe7, 0xbf, 0x4e, 0xaf, 0x15, 0x70, 0xac, 0x19, 0xf1, 0xa0, 0x11, 0xb3, 0x8c, 0x0b,
	0x96, 0xa5, 0x12, 0x93, 0x30, 0x52, 0xce, 0x51, 0xd7, 0xea, 0x55, 0x07, 0x6d, 0xb7, 0x58, 0xea,
	0x1e, 0x96, 0xba, 0xfe, 0x61, 0x29, 0xad, 0x1b, 0x0e, 0x4f, 0xdd, 0xbc, 0x03, 0xfc, 0x36, 0x20,
	0x2d, 0x38, 0x5d, 0x2e, 0x02, 0x3a, 0x9a, 0x84, 0xfe, 0xcb, 0xd3, 0x24, 0x9c, 0xce, 0x9f, 0xbd,
	0xd9, 0x74, 0x6c, 0xff, 0x23, 0xe7, 0xd0, 0x34, 0x85, 0x85, 0x7f, 0x3f, 0xa1, 0xb6, 0x45, 0xce,
	0xc0, 0x36, 0xf1, 0x30, 0x98, 0x3d, 0xd8, 0x25, 0x72, 0x01, 0xc4, 0xa4, 0x8f, 0xde, 0x3c, 0xf0,
	0x66, 0x76, 0x79, 0xd8, 0x78, 0xfd, 0xf3, 0x1e, 0xab, 0x8a, 0xae, 0x77, 0xfb, 0x15, 0x00, 0x00,
	0xff, 0xff, 0x56, 0x01, 0x12, 0xbd, 0xc1, 0x01, 0x00, 0x00,
}
