// Code generated by protoc-gen-go. DO NOT EDIT.
// source: user_subscribe_user_notice/create.proto

package user_subscribe_user_notice

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// SubTier is the enumerated values that a sub is normally.
type SubTier int32

const (
	// default case is an invalid sub tier
	SubTier_SUB_TIER_INVALID SubTier = 0
	// tier 1 subs
	SubTier_SUB_TIER_1 SubTier = 1
	// tier 2 subs
	SubTier_SUB_TIER_2 SubTier = 2
	// tier 3 subs
	SubTier_SUB_TIER_3 SubTier = 3
)

var SubTier_name = map[int32]string{
	0: "SUB_TIER_INVALID",
	1: "SUB_TIER_1",
	2: "SUB_TIER_2",
	3: "SUB_TIER_3",
}
var SubTier_value = map[string]int32{
	"SUB_TIER_INVALID": 0,
	"SUB_TIER_1":       1,
	"SUB_TIER_2":       2,
	"SUB_TIER_3":       3,
}

func (x SubTier) String() string {
	return proto.EnumName(SubTier_name, int32(x))
}
func (SubTier) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{0}
}

// UserSubscribeUserNoticeCreate is triggered when a subscription entitlement has notified the user's channel.
type UserSubscribeUserNoticeCreate struct {
	// the owner (i.e. twitch viewer) of the subscription entitlement (i.e. viewer who is subscribing)
	FromUserId string `protobuf:"bytes,1,opt,name=from_user_id,json=fromUserId,proto3" json:"from_user_id,omitempty"`
	// the user/broadcaster that the subscriber is entitled subscription benefits to (i.e. twitch.tv/michael)
	ToUserId string `protobuf:"bytes,2,opt,name=to_user_id,json=toUserId,proto3" json:"to_user_id,omitempty"`
	// The information pertaining to the current subscription for the user
	SubscriptionInfo *Subscription `protobuf:"bytes,3,opt,name=subscription_info,json=subscriptionInfo,proto3" json:"subscription_info,omitempty"`
	// The details of the user notice that can include:
	// - subscription, in which the user transitioned from unsubscribed to subscribed
	// - resubscription, in which the user shared their resubscription user notice
	// - gifted_subscription, in which the user has been gifted a subscription
	// - tier_upgrade, in which the user upgraded their subscription to a different tier
	// - prime_upgrade, in which the user has transitioned from a prime sub to a paid sub
	// - gift_upgrade, in which the user has transitioned from a gifted sub to a paid sub
	// - pay_it_forward, in which the user has gifted a sub after being gifted a sub themselves
	// - extend_subscription, in which the user has extended their sub before their sub has expired
	//
	// Types that are valid to be assigned to UserNotice:
	//	*UserSubscribeUserNoticeCreate_Subscription
	//	*UserSubscribeUserNoticeCreate_Resubscription
	//	*UserSubscribeUserNoticeCreate_GiftedSubscription
	//	*UserSubscribeUserNoticeCreate_TierUpgrade
	//	*UserSubscribeUserNoticeCreate_GiftUpgrade
	//	*UserSubscribeUserNoticeCreate_PayItForward
	//	*UserSubscribeUserNoticeCreate_ExtendSubscription
	//	*UserSubscribeUserNoticeCreate_PrimeUpgrade
	//	*UserSubscribeUserNoticeCreate_DeprecatedPrimeToPaid
	UserNotice           isUserSubscribeUserNoticeCreate_UserNotice `protobuf_oneof:"user_notice"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *UserSubscribeUserNoticeCreate) Reset()         { *m = UserSubscribeUserNoticeCreate{} }
func (m *UserSubscribeUserNoticeCreate) String() string { return proto.CompactTextString(m) }
func (*UserSubscribeUserNoticeCreate) ProtoMessage()    {}
func (*UserSubscribeUserNoticeCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{0}
}
func (m *UserSubscribeUserNoticeCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserSubscribeUserNoticeCreate.Unmarshal(m, b)
}
func (m *UserSubscribeUserNoticeCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserSubscribeUserNoticeCreate.Marshal(b, m, deterministic)
}
func (dst *UserSubscribeUserNoticeCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserSubscribeUserNoticeCreate.Merge(dst, src)
}
func (m *UserSubscribeUserNoticeCreate) XXX_Size() int {
	return xxx_messageInfo_UserSubscribeUserNoticeCreate.Size(m)
}
func (m *UserSubscribeUserNoticeCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_UserSubscribeUserNoticeCreate.DiscardUnknown(m)
}

var xxx_messageInfo_UserSubscribeUserNoticeCreate proto.InternalMessageInfo

func (m *UserSubscribeUserNoticeCreate) GetFromUserId() string {
	if m != nil {
		return m.FromUserId
	}
	return ""
}

func (m *UserSubscribeUserNoticeCreate) GetToUserId() string {
	if m != nil {
		return m.ToUserId
	}
	return ""
}

func (m *UserSubscribeUserNoticeCreate) GetSubscriptionInfo() *Subscription {
	if m != nil {
		return m.SubscriptionInfo
	}
	return nil
}

type isUserSubscribeUserNoticeCreate_UserNotice interface {
	isUserSubscribeUserNoticeCreate_UserNotice()
}

type UserSubscribeUserNoticeCreate_Subscription struct {
	Subscription *SubscriptionUserNotice `protobuf:"bytes,4,opt,name=subscription,proto3,oneof"`
}

type UserSubscribeUserNoticeCreate_Resubscription struct {
	Resubscription *SubscriptionUserNotice `protobuf:"bytes,5,opt,name=resubscription,proto3,oneof"`
}

type UserSubscribeUserNoticeCreate_GiftedSubscription struct {
	GiftedSubscription *GiftedSubscriptionUserNotice `protobuf:"bytes,6,opt,name=gifted_subscription,json=giftedSubscription,proto3,oneof"`
}

type UserSubscribeUserNoticeCreate_TierUpgrade struct {
	TierUpgrade *TierUpgradeUserNotice `protobuf:"bytes,7,opt,name=tier_upgrade,json=tierUpgrade,proto3,oneof"`
}

type UserSubscribeUserNoticeCreate_GiftUpgrade struct {
	GiftUpgrade *GiftToPaidUserNotice `protobuf:"bytes,9,opt,name=gift_upgrade,json=giftUpgrade,proto3,oneof"`
}

type UserSubscribeUserNoticeCreate_PayItForward struct {
	PayItForward *PayItForwardUserNotice `protobuf:"bytes,10,opt,name=pay_it_forward,json=payItForward,proto3,oneof"`
}

type UserSubscribeUserNoticeCreate_ExtendSubscription struct {
	ExtendSubscription *ExtendSubscriptionUserNotice `protobuf:"bytes,11,opt,name=extend_subscription,json=extendSubscription,proto3,oneof"`
}

type UserSubscribeUserNoticeCreate_PrimeUpgrade struct {
	PrimeUpgrade *PrimeToPaidUserNotice `protobuf:"bytes,12,opt,name=prime_upgrade,json=primeUpgrade,proto3,oneof"`
}

type UserSubscribeUserNoticeCreate_DeprecatedPrimeToPaid struct {
	DeprecatedPrimeToPaid *SubscriptionUserNotice `protobuf:"bytes,8,opt,name=deprecated_prime_to_paid,json=deprecatedPrimeToPaid,proto3,oneof"`
}

func (*UserSubscribeUserNoticeCreate_Subscription) isUserSubscribeUserNoticeCreate_UserNotice() {}

func (*UserSubscribeUserNoticeCreate_Resubscription) isUserSubscribeUserNoticeCreate_UserNotice() {}

func (*UserSubscribeUserNoticeCreate_GiftedSubscription) isUserSubscribeUserNoticeCreate_UserNotice() {
}

func (*UserSubscribeUserNoticeCreate_TierUpgrade) isUserSubscribeUserNoticeCreate_UserNotice() {}

func (*UserSubscribeUserNoticeCreate_GiftUpgrade) isUserSubscribeUserNoticeCreate_UserNotice() {}

func (*UserSubscribeUserNoticeCreate_PayItForward) isUserSubscribeUserNoticeCreate_UserNotice() {}

func (*UserSubscribeUserNoticeCreate_ExtendSubscription) isUserSubscribeUserNoticeCreate_UserNotice() {
}

func (*UserSubscribeUserNoticeCreate_PrimeUpgrade) isUserSubscribeUserNoticeCreate_UserNotice() {}

func (*UserSubscribeUserNoticeCreate_DeprecatedPrimeToPaid) isUserSubscribeUserNoticeCreate_UserNotice() {
}

func (m *UserSubscribeUserNoticeCreate) GetUserNotice() isUserSubscribeUserNoticeCreate_UserNotice {
	if m != nil {
		return m.UserNotice
	}
	return nil
}

func (m *UserSubscribeUserNoticeCreate) GetSubscription() *SubscriptionUserNotice {
	if x, ok := m.GetUserNotice().(*UserSubscribeUserNoticeCreate_Subscription); ok {
		return x.Subscription
	}
	return nil
}

func (m *UserSubscribeUserNoticeCreate) GetResubscription() *SubscriptionUserNotice {
	if x, ok := m.GetUserNotice().(*UserSubscribeUserNoticeCreate_Resubscription); ok {
		return x.Resubscription
	}
	return nil
}

func (m *UserSubscribeUserNoticeCreate) GetGiftedSubscription() *GiftedSubscriptionUserNotice {
	if x, ok := m.GetUserNotice().(*UserSubscribeUserNoticeCreate_GiftedSubscription); ok {
		return x.GiftedSubscription
	}
	return nil
}

func (m *UserSubscribeUserNoticeCreate) GetTierUpgrade() *TierUpgradeUserNotice {
	if x, ok := m.GetUserNotice().(*UserSubscribeUserNoticeCreate_TierUpgrade); ok {
		return x.TierUpgrade
	}
	return nil
}

func (m *UserSubscribeUserNoticeCreate) GetGiftUpgrade() *GiftToPaidUserNotice {
	if x, ok := m.GetUserNotice().(*UserSubscribeUserNoticeCreate_GiftUpgrade); ok {
		return x.GiftUpgrade
	}
	return nil
}

func (m *UserSubscribeUserNoticeCreate) GetPayItForward() *PayItForwardUserNotice {
	if x, ok := m.GetUserNotice().(*UserSubscribeUserNoticeCreate_PayItForward); ok {
		return x.PayItForward
	}
	return nil
}

func (m *UserSubscribeUserNoticeCreate) GetExtendSubscription() *ExtendSubscriptionUserNotice {
	if x, ok := m.GetUserNotice().(*UserSubscribeUserNoticeCreate_ExtendSubscription); ok {
		return x.ExtendSubscription
	}
	return nil
}

func (m *UserSubscribeUserNoticeCreate) GetPrimeUpgrade() *PrimeToPaidUserNotice {
	if x, ok := m.GetUserNotice().(*UserSubscribeUserNoticeCreate_PrimeUpgrade); ok {
		return x.PrimeUpgrade
	}
	return nil
}

func (m *UserSubscribeUserNoticeCreate) GetDeprecatedPrimeToPaid() *SubscriptionUserNotice {
	if x, ok := m.GetUserNotice().(*UserSubscribeUserNoticeCreate_DeprecatedPrimeToPaid); ok {
		return x.DeprecatedPrimeToPaid
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UserSubscribeUserNoticeCreate) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UserSubscribeUserNoticeCreate_OneofMarshaler, _UserSubscribeUserNoticeCreate_OneofUnmarshaler, _UserSubscribeUserNoticeCreate_OneofSizer, []interface{}{
		(*UserSubscribeUserNoticeCreate_Subscription)(nil),
		(*UserSubscribeUserNoticeCreate_Resubscription)(nil),
		(*UserSubscribeUserNoticeCreate_GiftedSubscription)(nil),
		(*UserSubscribeUserNoticeCreate_TierUpgrade)(nil),
		(*UserSubscribeUserNoticeCreate_GiftUpgrade)(nil),
		(*UserSubscribeUserNoticeCreate_PayItForward)(nil),
		(*UserSubscribeUserNoticeCreate_ExtendSubscription)(nil),
		(*UserSubscribeUserNoticeCreate_PrimeUpgrade)(nil),
		(*UserSubscribeUserNoticeCreate_DeprecatedPrimeToPaid)(nil),
	}
}

func _UserSubscribeUserNoticeCreate_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UserSubscribeUserNoticeCreate)
	// user_notice
	switch x := m.UserNotice.(type) {
	case *UserSubscribeUserNoticeCreate_Subscription:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Subscription); err != nil {
			return err
		}
	case *UserSubscribeUserNoticeCreate_Resubscription:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Resubscription); err != nil {
			return err
		}
	case *UserSubscribeUserNoticeCreate_GiftedSubscription:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GiftedSubscription); err != nil {
			return err
		}
	case *UserSubscribeUserNoticeCreate_TierUpgrade:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TierUpgrade); err != nil {
			return err
		}
	case *UserSubscribeUserNoticeCreate_GiftUpgrade:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GiftUpgrade); err != nil {
			return err
		}
	case *UserSubscribeUserNoticeCreate_PayItForward:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PayItForward); err != nil {
			return err
		}
	case *UserSubscribeUserNoticeCreate_ExtendSubscription:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExtendSubscription); err != nil {
			return err
		}
	case *UserSubscribeUserNoticeCreate_PrimeUpgrade:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PrimeUpgrade); err != nil {
			return err
		}
	case *UserSubscribeUserNoticeCreate_DeprecatedPrimeToPaid:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeprecatedPrimeToPaid); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UserSubscribeUserNoticeCreate.UserNotice has unexpected type %T", x)
	}
	return nil
}

func _UserSubscribeUserNoticeCreate_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UserSubscribeUserNoticeCreate)
	switch tag {
	case 4: // user_notice.subscription
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SubscriptionUserNotice)
		err := b.DecodeMessage(msg)
		m.UserNotice = &UserSubscribeUserNoticeCreate_Subscription{msg}
		return true, err
	case 5: // user_notice.resubscription
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SubscriptionUserNotice)
		err := b.DecodeMessage(msg)
		m.UserNotice = &UserSubscribeUserNoticeCreate_Resubscription{msg}
		return true, err
	case 6: // user_notice.gifted_subscription
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GiftedSubscriptionUserNotice)
		err := b.DecodeMessage(msg)
		m.UserNotice = &UserSubscribeUserNoticeCreate_GiftedSubscription{msg}
		return true, err
	case 7: // user_notice.tier_upgrade
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TierUpgradeUserNotice)
		err := b.DecodeMessage(msg)
		m.UserNotice = &UserSubscribeUserNoticeCreate_TierUpgrade{msg}
		return true, err
	case 9: // user_notice.gift_upgrade
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GiftToPaidUserNotice)
		err := b.DecodeMessage(msg)
		m.UserNotice = &UserSubscribeUserNoticeCreate_GiftUpgrade{msg}
		return true, err
	case 10: // user_notice.pay_it_forward
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PayItForwardUserNotice)
		err := b.DecodeMessage(msg)
		m.UserNotice = &UserSubscribeUserNoticeCreate_PayItForward{msg}
		return true, err
	case 11: // user_notice.extend_subscription
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExtendSubscriptionUserNotice)
		err := b.DecodeMessage(msg)
		m.UserNotice = &UserSubscribeUserNoticeCreate_ExtendSubscription{msg}
		return true, err
	case 12: // user_notice.prime_upgrade
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PrimeToPaidUserNotice)
		err := b.DecodeMessage(msg)
		m.UserNotice = &UserSubscribeUserNoticeCreate_PrimeUpgrade{msg}
		return true, err
	case 8: // user_notice.deprecated_prime_to_paid
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SubscriptionUserNotice)
		err := b.DecodeMessage(msg)
		m.UserNotice = &UserSubscribeUserNoticeCreate_DeprecatedPrimeToPaid{msg}
		return true, err
	default:
		return false, nil
	}
}

func _UserSubscribeUserNoticeCreate_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UserSubscribeUserNoticeCreate)
	// user_notice
	switch x := m.UserNotice.(type) {
	case *UserSubscribeUserNoticeCreate_Subscription:
		s := proto.Size(x.Subscription)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserSubscribeUserNoticeCreate_Resubscription:
		s := proto.Size(x.Resubscription)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserSubscribeUserNoticeCreate_GiftedSubscription:
		s := proto.Size(x.GiftedSubscription)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserSubscribeUserNoticeCreate_TierUpgrade:
		s := proto.Size(x.TierUpgrade)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserSubscribeUserNoticeCreate_GiftUpgrade:
		s := proto.Size(x.GiftUpgrade)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserSubscribeUserNoticeCreate_PayItForward:
		s := proto.Size(x.PayItForward)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserSubscribeUserNoticeCreate_ExtendSubscription:
		s := proto.Size(x.ExtendSubscription)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserSubscribeUserNoticeCreate_PrimeUpgrade:
		s := proto.Size(x.PrimeUpgrade)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserSubscribeUserNoticeCreate_DeprecatedPrimeToPaid:
		s := proto.Size(x.DeprecatedPrimeToPaid)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// ExtendSubscriptionUserNotice when the user has extended their current sub duration.
type ExtendSubscriptionUserNotice struct {
	// the amount of months the sub was extended
	BenefitEndMonth int64 `protobuf:"varint,1,opt,name=benefit_end_month,json=benefitEndMonth,proto3" json:"benefit_end_month,omitempty"`
	// The tier of sub that was extended
	Tier *Tier `protobuf:"bytes,2,opt,name=tier,proto3" json:"tier,omitempty"`
	// A custom message that the user has created to share their feelings about that sick sub to the Taco Premium Club
	CustomMessage string `protobuf:"bytes,3,opt,name=custom_message,json=customMessage,proto3" json:"custom_message,omitempty"`
	// The amount of months the user extended their subscription by
	Quantity             int64    `protobuf:"varint,4,opt,name=quantity,proto3" json:"quantity,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExtendSubscriptionUserNotice) Reset()         { *m = ExtendSubscriptionUserNotice{} }
func (m *ExtendSubscriptionUserNotice) String() string { return proto.CompactTextString(m) }
func (*ExtendSubscriptionUserNotice) ProtoMessage()    {}
func (*ExtendSubscriptionUserNotice) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{1}
}
func (m *ExtendSubscriptionUserNotice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExtendSubscriptionUserNotice.Unmarshal(m, b)
}
func (m *ExtendSubscriptionUserNotice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExtendSubscriptionUserNotice.Marshal(b, m, deterministic)
}
func (dst *ExtendSubscriptionUserNotice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExtendSubscriptionUserNotice.Merge(dst, src)
}
func (m *ExtendSubscriptionUserNotice) XXX_Size() int {
	return xxx_messageInfo_ExtendSubscriptionUserNotice.Size(m)
}
func (m *ExtendSubscriptionUserNotice) XXX_DiscardUnknown() {
	xxx_messageInfo_ExtendSubscriptionUserNotice.DiscardUnknown(m)
}

var xxx_messageInfo_ExtendSubscriptionUserNotice proto.InternalMessageInfo

func (m *ExtendSubscriptionUserNotice) GetBenefitEndMonth() int64 {
	if m != nil {
		return m.BenefitEndMonth
	}
	return 0
}

func (m *ExtendSubscriptionUserNotice) GetTier() *Tier {
	if m != nil {
		return m.Tier
	}
	return nil
}

func (m *ExtendSubscriptionUserNotice) GetCustomMessage() string {
	if m != nil {
		return m.CustomMessage
	}
	return ""
}

func (m *ExtendSubscriptionUserNotice) GetQuantity() int64 {
	if m != nil {
		return m.Quantity
	}
	return 0
}

// PayItForwardUserNotice when a user that was gifted a sub then gifts another sub because they're a nice human / creature.
type PayItForwardUserNotice struct {
	// The gifter who paid it forward
	PriorGifterId string `protobuf:"bytes,1,opt,name=prior_gifter_id,json=priorGifterId,proto3" json:"prior_gifter_id,omitempty"`
	// Flag to determine if the prior gifter was anonymous
	IsPriorGifterAnonymous bool `protobuf:"varint,2,opt,name=is_prior_gifter_anonymous,json=isPriorGifterAnonymous,proto3" json:"is_prior_gifter_anonymous,omitempty"`
	// The tier of sub that was gifted
	Tier *Tier `protobuf:"bytes,3,opt,name=tier,proto3" json:"tier,omitempty"`
	// the user who receives the pay it forward sub
	RecipientId          string   `protobuf:"bytes,4,opt,name=recipient_id,json=recipientId,proto3" json:"recipient_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PayItForwardUserNotice) Reset()         { *m = PayItForwardUserNotice{} }
func (m *PayItForwardUserNotice) String() string { return proto.CompactTextString(m) }
func (*PayItForwardUserNotice) ProtoMessage()    {}
func (*PayItForwardUserNotice) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{2}
}
func (m *PayItForwardUserNotice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PayItForwardUserNotice.Unmarshal(m, b)
}
func (m *PayItForwardUserNotice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PayItForwardUserNotice.Marshal(b, m, deterministic)
}
func (dst *PayItForwardUserNotice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PayItForwardUserNotice.Merge(dst, src)
}
func (m *PayItForwardUserNotice) XXX_Size() int {
	return xxx_messageInfo_PayItForwardUserNotice.Size(m)
}
func (m *PayItForwardUserNotice) XXX_DiscardUnknown() {
	xxx_messageInfo_PayItForwardUserNotice.DiscardUnknown(m)
}

var xxx_messageInfo_PayItForwardUserNotice proto.InternalMessageInfo

func (m *PayItForwardUserNotice) GetPriorGifterId() string {
	if m != nil {
		return m.PriorGifterId
	}
	return ""
}

func (m *PayItForwardUserNotice) GetIsPriorGifterAnonymous() bool {
	if m != nil {
		return m.IsPriorGifterAnonymous
	}
	return false
}

func (m *PayItForwardUserNotice) GetTier() *Tier {
	if m != nil {
		return m.Tier
	}
	return nil
}

func (m *PayItForwardUserNotice) GetRecipientId() string {
	if m != nil {
		return m.RecipientId
	}
	return ""
}

// TierUpgradeUserNotice when a user changes their sub to a new tier.
type TierUpgradeUserNotice struct {
	// The previous tier of their sub
	OldTier *Tier `protobuf:"bytes,1,opt,name=old_tier,json=oldTier,proto3" json:"old_tier,omitempty"`
	// The new tier of their sub
	NewTier              *Tier    `protobuf:"bytes,2,opt,name=new_tier,json=newTier,proto3" json:"new_tier,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TierUpgradeUserNotice) Reset()         { *m = TierUpgradeUserNotice{} }
func (m *TierUpgradeUserNotice) String() string { return proto.CompactTextString(m) }
func (*TierUpgradeUserNotice) ProtoMessage()    {}
func (*TierUpgradeUserNotice) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{3}
}
func (m *TierUpgradeUserNotice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TierUpgradeUserNotice.Unmarshal(m, b)
}
func (m *TierUpgradeUserNotice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TierUpgradeUserNotice.Marshal(b, m, deterministic)
}
func (dst *TierUpgradeUserNotice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TierUpgradeUserNotice.Merge(dst, src)
}
func (m *TierUpgradeUserNotice) XXX_Size() int {
	return xxx_messageInfo_TierUpgradeUserNotice.Size(m)
}
func (m *TierUpgradeUserNotice) XXX_DiscardUnknown() {
	xxx_messageInfo_TierUpgradeUserNotice.DiscardUnknown(m)
}

var xxx_messageInfo_TierUpgradeUserNotice proto.InternalMessageInfo

func (m *TierUpgradeUserNotice) GetOldTier() *Tier {
	if m != nil {
		return m.OldTier
	}
	return nil
}

func (m *TierUpgradeUserNotice) GetNewTier() *Tier {
	if m != nil {
		return m.NewTier
	}
	return nil
}

// GiftToPaidUserNotice when a user has converted their gifted sub into a paid sub.
type GiftToPaidUserNotice struct {
	// the original user who gifted the sub to the user
	OriginalGifterId string `protobuf:"bytes,1,opt,name=original_gifter_id,json=originalGifterId,proto3" json:"original_gifter_id,omitempty"`
	// the tier of sub that the user has started to pay for
	PaidTier             *Tier    `protobuf:"bytes,2,opt,name=paid_tier,json=paidTier,proto3" json:"paid_tier,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GiftToPaidUserNotice) Reset()         { *m = GiftToPaidUserNotice{} }
func (m *GiftToPaidUserNotice) String() string { return proto.CompactTextString(m) }
func (*GiftToPaidUserNotice) ProtoMessage()    {}
func (*GiftToPaidUserNotice) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{4}
}
func (m *GiftToPaidUserNotice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GiftToPaidUserNotice.Unmarshal(m, b)
}
func (m *GiftToPaidUserNotice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GiftToPaidUserNotice.Marshal(b, m, deterministic)
}
func (dst *GiftToPaidUserNotice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GiftToPaidUserNotice.Merge(dst, src)
}
func (m *GiftToPaidUserNotice) XXX_Size() int {
	return xxx_messageInfo_GiftToPaidUserNotice.Size(m)
}
func (m *GiftToPaidUserNotice) XXX_DiscardUnknown() {
	xxx_messageInfo_GiftToPaidUserNotice.DiscardUnknown(m)
}

var xxx_messageInfo_GiftToPaidUserNotice proto.InternalMessageInfo

func (m *GiftToPaidUserNotice) GetOriginalGifterId() string {
	if m != nil {
		return m.OriginalGifterId
	}
	return ""
}

func (m *GiftToPaidUserNotice) GetPaidTier() *Tier {
	if m != nil {
		return m.PaidTier
	}
	return nil
}

// PrimeToPaidUserNotice when a user has converted their prime sub into a paid sub.
type PrimeToPaidUserNotice struct {
	// the tier of sub that the user has started to pay for
	PaidTier             *Tier    `protobuf:"bytes,1,opt,name=paid_tier,json=paidTier,proto3" json:"paid_tier,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PrimeToPaidUserNotice) Reset()         { *m = PrimeToPaidUserNotice{} }
func (m *PrimeToPaidUserNotice) String() string { return proto.CompactTextString(m) }
func (*PrimeToPaidUserNotice) ProtoMessage()    {}
func (*PrimeToPaidUserNotice) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{5}
}
func (m *PrimeToPaidUserNotice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrimeToPaidUserNotice.Unmarshal(m, b)
}
func (m *PrimeToPaidUserNotice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrimeToPaidUserNotice.Marshal(b, m, deterministic)
}
func (dst *PrimeToPaidUserNotice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrimeToPaidUserNotice.Merge(dst, src)
}
func (m *PrimeToPaidUserNotice) XXX_Size() int {
	return xxx_messageInfo_PrimeToPaidUserNotice.Size(m)
}
func (m *PrimeToPaidUserNotice) XXX_DiscardUnknown() {
	xxx_messageInfo_PrimeToPaidUserNotice.DiscardUnknown(m)
}

var xxx_messageInfo_PrimeToPaidUserNotice proto.InternalMessageInfo

func (m *PrimeToPaidUserNotice) GetPaidTier() *Tier {
	if m != nil {
		return m.PaidTier
	}
	return nil
}

// GiftedSubscriptionUserNotice when a user has been gifted a sub to a channel.
type GiftedSubscriptionUserNotice struct {
	// the ID of the gifter, which could be the anonymous gifter ID
	GifterId string `protobuf:"bytes,1,opt,name=gifter_id,json=gifterId,proto3" json:"gifter_id,omitempty"`
	// If the gift was anonymous. both of these fields are set since it is required to have the anonymous user ID passed from Subs services.
	IsAnon bool `protobuf:"varint,2,opt,name=is_anon,json=isAnon,proto3" json:"is_anon,omitempty"`
	// The tier of sub that was gifted.
	Tier                 *Tier    `protobuf:"bytes,3,opt,name=tier,proto3" json:"tier,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GiftedSubscriptionUserNotice) Reset()         { *m = GiftedSubscriptionUserNotice{} }
func (m *GiftedSubscriptionUserNotice) String() string { return proto.CompactTextString(m) }
func (*GiftedSubscriptionUserNotice) ProtoMessage()    {}
func (*GiftedSubscriptionUserNotice) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{6}
}
func (m *GiftedSubscriptionUserNotice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GiftedSubscriptionUserNotice.Unmarshal(m, b)
}
func (m *GiftedSubscriptionUserNotice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GiftedSubscriptionUserNotice.Marshal(b, m, deterministic)
}
func (dst *GiftedSubscriptionUserNotice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GiftedSubscriptionUserNotice.Merge(dst, src)
}
func (m *GiftedSubscriptionUserNotice) XXX_Size() int {
	return xxx_messageInfo_GiftedSubscriptionUserNotice.Size(m)
}
func (m *GiftedSubscriptionUserNotice) XXX_DiscardUnknown() {
	xxx_messageInfo_GiftedSubscriptionUserNotice.DiscardUnknown(m)
}

var xxx_messageInfo_GiftedSubscriptionUserNotice proto.InternalMessageInfo

func (m *GiftedSubscriptionUserNotice) GetGifterId() string {
	if m != nil {
		return m.GifterId
	}
	return ""
}

func (m *GiftedSubscriptionUserNotice) GetIsAnon() bool {
	if m != nil {
		return m.IsAnon
	}
	return false
}

func (m *GiftedSubscriptionUserNotice) GetTier() *Tier {
	if m != nil {
		return m.Tier
	}
	return nil
}

// Subscription information pertaining to the subscription that was updated.
type SubscriptionUserNotice struct {
	// the cumulative amount of months the user has been subscribed to the user, between lapses in subscription periods
	CumulativeTenureMonths int64 `protobuf:"varint,1,opt,name=cumulative_tenure_months,json=cumulativeTenureMonths,proto3" json:"cumulative_tenure_months,omitempty"`
	// a message the user has written to share about their current subscription tenure
	CustomMessage string `protobuf:"bytes,2,opt,name=custom_message,json=customMessage,proto3" json:"custom_message,omitempty"`
	// the tier of subscription
	Tier *Tier `protobuf:"bytes,3,opt,name=tier,proto3" json:"tier,omitempty"`
	// information about the tenure streak, which provides additional information
	Streak               *TenureStreak `protobuf:"bytes,4,opt,name=streak,proto3" json:"streak,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *SubscriptionUserNotice) Reset()         { *m = SubscriptionUserNotice{} }
func (m *SubscriptionUserNotice) String() string { return proto.CompactTextString(m) }
func (*SubscriptionUserNotice) ProtoMessage()    {}
func (*SubscriptionUserNotice) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{7}
}
func (m *SubscriptionUserNotice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SubscriptionUserNotice.Unmarshal(m, b)
}
func (m *SubscriptionUserNotice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SubscriptionUserNotice.Marshal(b, m, deterministic)
}
func (dst *SubscriptionUserNotice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubscriptionUserNotice.Merge(dst, src)
}
func (m *SubscriptionUserNotice) XXX_Size() int {
	return xxx_messageInfo_SubscriptionUserNotice.Size(m)
}
func (m *SubscriptionUserNotice) XXX_DiscardUnknown() {
	xxx_messageInfo_SubscriptionUserNotice.DiscardUnknown(m)
}

var xxx_messageInfo_SubscriptionUserNotice proto.InternalMessageInfo

func (m *SubscriptionUserNotice) GetCumulativeTenureMonths() int64 {
	if m != nil {
		return m.CumulativeTenureMonths
	}
	return 0
}

func (m *SubscriptionUserNotice) GetCustomMessage() string {
	if m != nil {
		return m.CustomMessage
	}
	return ""
}

func (m *SubscriptionUserNotice) GetTier() *Tier {
	if m != nil {
		return m.Tier
	}
	return nil
}

func (m *SubscriptionUserNotice) GetStreak() *TenureStreak {
	if m != nil {
		return m.Streak
	}
	return nil
}

// Subscription defines a user's entitlement to product for a time period.
type Subscription struct {
	// the ID Of the subscription
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The product ID of the subscription
	ProductId string `protobuf:"bytes,2,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
	// The payment ID of the subscription
	OriginId string `protobuf:"bytes,3,opt,name=origin_id,json=originId,proto3" json:"origin_id,omitempty"`
	// The time the benefits of the subscription starts
	BenefitStartsAt *timestamp.Timestamp `protobuf:"bytes,4,opt,name=benefit_starts_at,json=benefitStartsAt,proto3" json:"benefit_starts_at,omitempty"`
	// The time the benefits of the subscription ends
	BenefitEndsAt *timestamp.Timestamp `protobuf:"bytes,5,opt,name=benefit_ends_at,json=benefitEndsAt,proto3" json:"benefit_ends_at,omitempty"`
	// The time the benefits were updated
	UpdatedAt *timestamp.Timestamp `protobuf:"bytes,6,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// The original time the benefit was created
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The string that denotes the actor that created the subscription
	CreatedBy            string   `protobuf:"bytes,8,opt,name=created_by,json=createdBy,proto3" json:"created_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Subscription) Reset()         { *m = Subscription{} }
func (m *Subscription) String() string { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()    {}
func (*Subscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{8}
}
func (m *Subscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Subscription.Unmarshal(m, b)
}
func (m *Subscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Subscription.Marshal(b, m, deterministic)
}
func (dst *Subscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subscription.Merge(dst, src)
}
func (m *Subscription) XXX_Size() int {
	return xxx_messageInfo_Subscription.Size(m)
}
func (m *Subscription) XXX_DiscardUnknown() {
	xxx_messageInfo_Subscription.DiscardUnknown(m)
}

var xxx_messageInfo_Subscription proto.InternalMessageInfo

func (m *Subscription) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Subscription) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *Subscription) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *Subscription) GetBenefitStartsAt() *timestamp.Timestamp {
	if m != nil {
		return m.BenefitStartsAt
	}
	return nil
}

func (m *Subscription) GetBenefitEndsAt() *timestamp.Timestamp {
	if m != nil {
		return m.BenefitEndsAt
	}
	return nil
}

func (m *Subscription) GetUpdatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *Subscription) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Subscription) GetCreatedBy() string {
	if m != nil {
		return m.CreatedBy
	}
	return ""
}

// TenureStreak is the wrapper around tenure streaks for the user subscribed to the broadcaster.
type TenureStreak struct {
	// A boolean flag that says if the tenure streak should be shared.
	ShouldShare bool `protobuf:"varint,1,opt,name=should_share,json=shouldShare,proto3" json:"should_share,omitempty"`
	// The consecutive months that the user has been subscribed to the broadcaster.
	Months               int64    `protobuf:"varint,2,opt,name=months,proto3" json:"months,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TenureStreak) Reset()         { *m = TenureStreak{} }
func (m *TenureStreak) String() string { return proto.CompactTextString(m) }
func (*TenureStreak) ProtoMessage()    {}
func (*TenureStreak) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{9}
}
func (m *TenureStreak) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TenureStreak.Unmarshal(m, b)
}
func (m *TenureStreak) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TenureStreak.Marshal(b, m, deterministic)
}
func (dst *TenureStreak) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TenureStreak.Merge(dst, src)
}
func (m *TenureStreak) XXX_Size() int {
	return xxx_messageInfo_TenureStreak.Size(m)
}
func (m *TenureStreak) XXX_DiscardUnknown() {
	xxx_messageInfo_TenureStreak.DiscardUnknown(m)
}

var xxx_messageInfo_TenureStreak proto.InternalMessageInfo

func (m *TenureStreak) GetShouldShare() bool {
	if m != nil {
		return m.ShouldShare
	}
	return false
}

func (m *TenureStreak) GetMonths() int64 {
	if m != nil {
		return m.Months
	}
	return 0
}

// Tier the tier value of sub that is attached.
type Tier struct {
	// the value can be either
	// - an enumerated value (tier 1, 2, 3 subs)
	// - a custom string value (OWL ticket product, legacy ticket products)
	//
	// Types that are valid to be assigned to Value:
	//	*Tier_Numeral
	//	*Tier_Custom
	Value                isTier_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Tier) Reset()         { *m = Tier{} }
func (m *Tier) String() string { return proto.CompactTextString(m) }
func (*Tier) ProtoMessage()    {}
func (*Tier) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f333ebd7ce5e5d7a, []int{10}
}
func (m *Tier) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tier.Unmarshal(m, b)
}
func (m *Tier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tier.Marshal(b, m, deterministic)
}
func (dst *Tier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tier.Merge(dst, src)
}
func (m *Tier) XXX_Size() int {
	return xxx_messageInfo_Tier.Size(m)
}
func (m *Tier) XXX_DiscardUnknown() {
	xxx_messageInfo_Tier.DiscardUnknown(m)
}

var xxx_messageInfo_Tier proto.InternalMessageInfo

type isTier_Value interface {
	isTier_Value()
}

type Tier_Numeral struct {
	Numeral SubTier `protobuf:"varint,1,opt,name=numeral,proto3,enum=user_subscribe_user_notice.SubTier,oneof"`
}

type Tier_Custom struct {
	Custom string `protobuf:"bytes,2,opt,name=custom,proto3,oneof"`
}

func (*Tier_Numeral) isTier_Value() {}

func (*Tier_Custom) isTier_Value() {}

func (m *Tier) GetValue() isTier_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Tier) GetNumeral() SubTier {
	if x, ok := m.GetValue().(*Tier_Numeral); ok {
		return x.Numeral
	}
	return SubTier_SUB_TIER_INVALID
}

func (m *Tier) GetCustom() string {
	if x, ok := m.GetValue().(*Tier_Custom); ok {
		return x.Custom
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Tier) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Tier_OneofMarshaler, _Tier_OneofUnmarshaler, _Tier_OneofSizer, []interface{}{
		(*Tier_Numeral)(nil),
		(*Tier_Custom)(nil),
	}
}

func _Tier_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Tier)
	// value
	switch x := m.Value.(type) {
	case *Tier_Numeral:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Numeral))
	case *Tier_Custom:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Custom)
	case nil:
	default:
		return fmt.Errorf("Tier.Value has unexpected type %T", x)
	}
	return nil
}

func _Tier_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Tier)
	switch tag {
	case 1: // value.numeral
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &Tier_Numeral{SubTier(x)}
		return true, err
	case 2: // value.custom
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &Tier_Custom{x}
		return true, err
	default:
		return false, nil
	}
}

func _Tier_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Tier)
	// value
	switch x := m.Value.(type) {
	case *Tier_Numeral:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Numeral))
	case *Tier_Custom:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Custom)))
		n += len(x.Custom)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*UserSubscribeUserNoticeCreate)(nil), "user_subscribe_user_notice.UserSubscribeUserNoticeCreate")
	proto.RegisterType((*ExtendSubscriptionUserNotice)(nil), "user_subscribe_user_notice.ExtendSubscriptionUserNotice")
	proto.RegisterType((*PayItForwardUserNotice)(nil), "user_subscribe_user_notice.PayItForwardUserNotice")
	proto.RegisterType((*TierUpgradeUserNotice)(nil), "user_subscribe_user_notice.TierUpgradeUserNotice")
	proto.RegisterType((*GiftToPaidUserNotice)(nil), "user_subscribe_user_notice.GiftToPaidUserNotice")
	proto.RegisterType((*PrimeToPaidUserNotice)(nil), "user_subscribe_user_notice.PrimeToPaidUserNotice")
	proto.RegisterType((*GiftedSubscriptionUserNotice)(nil), "user_subscribe_user_notice.GiftedSubscriptionUserNotice")
	proto.RegisterType((*SubscriptionUserNotice)(nil), "user_subscribe_user_notice.SubscriptionUserNotice")
	proto.RegisterType((*Subscription)(nil), "user_subscribe_user_notice.Subscription")
	proto.RegisterType((*TenureStreak)(nil), "user_subscribe_user_notice.TenureStreak")
	proto.RegisterType((*Tier)(nil), "user_subscribe_user_notice.Tier")
	proto.RegisterEnum("user_subscribe_user_notice.SubTier", SubTier_name, SubTier_value)
}

func init() {
	proto.RegisterFile("user_subscribe_user_notice/create.proto", fileDescriptor_create_f333ebd7ce5e5d7a)
}

var fileDescriptor_create_f333ebd7ce5e5d7a = []byte{
	// 1045 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdf, 0x6f, 0x1b, 0xc5,
	0x13, 0xcf, 0x39, 0x89, 0x7d, 0x1e, 0x3b, 0x8e, 0xbb, 0xdf, 0xc6, 0xdf, 0x23, 0xa4, 0x22, 0x18,
	0x01, 0x51, 0x85, 0x1c, 0xea, 0xf2, 0xd0, 0x0a, 0x21, 0x88, 0x21, 0x25, 0x27, 0xd1, 0x12, 0x9d,
	0xed, 0xa8, 0xaa, 0x90, 0x4e, 0x6b, 0xdf, 0xda, 0x59, 0xea, 0xbb, 0xbd, 0xee, 0xee, 0x35, 0xf8,
	0x99, 0x37, 0xde, 0xf8, 0x4b, 0xf8, 0x23, 0xf8, 0x17, 0xf8, 0x47, 0x78, 0xe6, 0x05, 0xed, 0xde,
	0x0f, 0xfb, 0x12, 0xff, 0x68, 0xc2, 0xdb, 0xed, 0xcc, 0x7c, 0x3e, 0x33, 0x3b, 0x3b, 0x33, 0x37,
	0xf0, 0x69, 0x24, 0x08, 0x77, 0x45, 0x34, 0x10, 0x43, 0x4e, 0x07, 0xc4, 0xd5, 0xc7, 0x80, 0x49,
	0x3a, 0x24, 0xc7, 0x43, 0x4e, 0xb0, 0x24, 0xad, 0x90, 0x33, 0xc9, 0xd0, 0xfe, 0x72, 0xc3, 0xfd,
	0x0f, 0xc6, 0x8c, 0x8d, 0x27, 0xe4, 0x58, 0x5b, 0x0e, 0xa2, 0xd1, 0xb1, 0xa4, 0x3e, 0x11, 0x12,
	0xfb, 0x61, 0x0c, 0x6e, 0xfe, 0x61, 0xc2, 0x83, 0xbe, 0x20, 0xbc, 0x9b, 0xc2, 0xd5, 0xe1, 0x85,
	0x06, 0x7f, 0xab, 0x9d, 0xa0, 0x43, 0xa8, 0x8e, 0x38, 0xf3, 0x63, 0x5a, 0xea, 0x59, 0xc6, 0xa1,
	0x71, 0x54, 0x76, 0x40, 0xc9, 0x94, 0xad, 0xed, 0xa1, 0x03, 0x00, 0xc9, 0x32, 0x7d, 0x41, 0xeb,
	0x4d, 0xc9, 0x12, 0x6d, 0x1f, 0xee, 0x25, 0xb1, 0x85, 0x92, 0xb2, 0xc0, 0xa5, 0xc1, 0x88, 0x59,
	0x9b, 0x87, 0xc6, 0x51, 0xa5, 0x7d, 0xd4, 0x5a, 0x1e, 0x7a, 0xab, 0x3b, 0x07, 0x72, 0xea, 0xf3,
	0x14, 0x76, 0x30, 0x62, 0xe8, 0x25, 0x54, 0xe7, 0x65, 0xd6, 0x96, 0x66, 0x6c, 0xbf, 0x2b, 0xe3,
	0xec, 0x9a, 0x67, 0x1b, 0x4e, 0x8e, 0x09, 0xfd, 0x04, 0x35, 0x4e, 0x72, 0xdc, 0xdb, 0xff, 0x81,
	0xfb, 0x1a, 0x17, 0x7a, 0x0d, 0xff, 0x1b, 0xd3, 0x91, 0x24, 0x9e, 0x9b, 0x73, 0x51, 0xd4, 0x2e,
	0x9e, 0xac, 0x72, 0xf1, 0xbd, 0x86, 0x2d, 0x75, 0x84, 0xc6, 0x37, 0xf4, 0xe8, 0x02, 0xaa, 0x92,
	0x12, 0xee, 0x46, 0xe1, 0x98, 0x63, 0x8f, 0x58, 0x25, 0xed, 0xe5, 0xd1, 0x2a, 0x2f, 0x3d, 0x4a,
	0x78, 0x3f, 0x36, 0xcf, 0xd1, 0x57, 0xe4, 0x4c, 0x81, 0xfa, 0x50, 0x55, 0xde, 0x32, 0xde, 0xb2,
	0xe6, 0xfd, 0x7c, 0x5d, 0xf4, 0x3d, 0x76, 0x8e, 0xa9, 0x97, 0xa7, 0x55, 0x3c, 0x29, 0xed, 0x2b,
	0xa8, 0x85, 0x78, 0xea, 0x52, 0xe9, 0x8e, 0x18, 0xbf, 0xc2, 0xdc, 0xb3, 0x60, 0x7d, 0xe6, 0xcf,
	0xf1, 0xd4, 0x96, 0xcf, 0x62, 0xfb, 0xfc, 0xab, 0x86, 0x73, 0x1a, 0x95, 0x77, 0xf2, 0x8b, 0x24,
	0xc1, 0xb5, 0xbc, 0x57, 0xd6, 0xe7, 0xfd, 0x54, 0xc3, 0x96, 0xe7, 0x9d, 0xdc, 0xd0, 0xa3, 0x97,
	0xb0, 0x13, 0x72, 0xea, 0x93, 0x2c, 0x41, 0xd5, 0xf5, 0x89, 0x3f, 0x57, 0x80, 0x05, 0x19, 0xaa,
	0x6a, 0xa6, 0x34, 0x45, 0x6f, 0xc0, 0xf2, 0x48, 0xc8, 0xc9, 0x10, 0xab, 0x12, 0x8a, 0x9d, 0x48,
	0xe6, 0x86, 0x98, 0x7a, 0x96, 0x79, 0xd7, 0x32, 0xed, 0x14, 0x2c, 0xe3, 0x6c, 0xc3, 0xd9, 0x9b,
	0x31, 0xcf, 0x05, 0xd3, 0xd9, 0x81, 0xca, 0x1c, 0x45, 0xf3, 0x4f, 0x03, 0x0e, 0x56, 0xa5, 0x04,
	0x3d, 0x84, 0x7b, 0x03, 0x12, 0x90, 0x11, 0x95, 0xae, 0x4a, 0xb7, 0xcf, 0x02, 0x79, 0xa9, 0xa7,
	0xc6, 0xa6, 0xb3, 0x9b, 0x28, 0x4e, 0x03, 0xef, 0xb9, 0x12, 0xa3, 0x2f, 0x60, 0x4b, 0xd5, 0x95,
	0x1e, 0x1a, 0x95, 0xf6, 0xe1, 0xba, 0xc2, 0x74, 0xb4, 0x35, 0xfa, 0x18, 0x6a, 0xc3, 0x48, 0x48,
	0xe6, 0xbb, 0x3e, 0x11, 0x02, 0x8f, 0x89, 0x9e, 0x27, 0x65, 0x67, 0x27, 0x96, 0x3e, 0x8f, 0x85,
	0x68, 0x1f, 0xcc, 0x37, 0x11, 0x0e, 0x24, 0x95, 0x53, 0x3d, 0x1e, 0x36, 0x9d, 0xec, 0xdc, 0xfc,
	0xcb, 0x80, 0xc6, 0xe2, 0xca, 0x41, 0x9f, 0xc0, 0x6e, 0xc8, 0x29, 0xe3, 0xae, 0x6e, 0xa8, 0xb9,
	0x99, 0xb7, 0xa3, 0xc5, 0xba, 0x0d, 0xd5, 0x60, 0x7b, 0x0a, 0xef, 0x51, 0xe1, 0xe6, 0x4c, 0x71,
	0xc0, 0x82, 0xa9, 0xcf, 0x22, 0xa1, 0x2f, 0x64, 0x3a, 0x0d, 0x2a, 0xce, 0x67, 0x98, 0x93, 0x54,
	0x9b, 0x5d, 0x7b, 0xf3, 0x56, 0xd7, 0xfe, 0x10, 0xaa, 0x9c, 0x0c, 0x69, 0x48, 0x49, 0x20, 0x55,
	0x54, 0x5b, 0x3a, 0xaa, 0x4a, 0x26, 0xb3, 0xbd, 0xe6, 0xef, 0x06, 0xec, 0x2d, 0xec, 0x60, 0xf4,
	0x25, 0x98, 0x6c, 0xe2, 0xb9, 0xda, 0xad, 0xf1, 0x8e, 0x6e, 0x4b, 0x6c, 0xe2, 0xa9, 0x0f, 0x05,
	0x0e, 0xc8, 0x95, 0x7b, 0xab, 0xa7, 0x2a, 0x05, 0xe4, 0x4a, 0x7d, 0x34, 0x7f, 0x35, 0xe0, 0xfe,
	0xa2, 0xee, 0x47, 0x9f, 0x01, 0x62, 0x9c, 0x8e, 0x69, 0x80, 0x27, 0x37, 0x72, 0x5d, 0x4f, 0x35,
	0x59, 0xba, 0xbf, 0x82, 0xb2, 0xaa, 0xf2, 0xdb, 0x05, 0x61, 0x2a, 0x88, 0x8e, 0xe2, 0x02, 0xf6,
	0x16, 0x76, 0x58, 0x9e, 0xd7, 0xb8, 0x35, 0xef, 0x6f, 0x06, 0x1c, 0xac, 0x9a, 0xcc, 0xe8, 0x7d,
	0x28, 0x5f, 0xbf, 0x9c, 0x39, 0x4e, 0x2f, 0xf5, 0x7f, 0x28, 0x51, 0xa1, 0xcb, 0x26, 0xa9, 0x98,
	0x22, 0x15, 0xaa, 0x4c, 0xee, 0x56, 0x21, 0xcd, 0xbf, 0x0d, 0x68, 0x2c, 0x09, 0xe3, 0x09, 0x58,
	0xc3, 0xc8, 0x8f, 0x26, 0x58, 0xd2, 0xb7, 0xc4, 0x95, 0x24, 0x88, 0x38, 0x89, 0x7b, 0x53, 0x24,
	0xcd, 0xd9, 0x98, 0xe9, 0x7b, 0x5a, 0xad, 0x5b, 0x54, 0x2c, 0xe8, 0xb6, 0xc2, 0xa2, 0x6e, 0xbb,
	0x5b, 0x4d, 0x7f, 0x03, 0x45, 0x21, 0x39, 0xc1, 0xaf, 0x93, 0x1f, 0xf8, 0xca, 0x95, 0x20, 0x0e,
	0xab, 0xab, 0xed, 0x9d, 0x04, 0xd7, 0xfc, 0xa7, 0x00, 0xd5, 0xdc, 0xf0, 0xad, 0x41, 0x21, 0xcb,
	0x74, 0x81, 0x7a, 0xe8, 0x01, 0x40, 0xc8, 0x99, 0x17, 0x0d, 0xe5, 0x6c, 0x3d, 0x29, 0x27, 0x12,
	0xdb, 0x53, 0xef, 0x13, 0xd7, 0x9a, 0xd2, 0xc6, 0x73, 0xc4, 0x8c, 0x05, 0xb6, 0x87, 0x9e, 0xcd,
	0x66, 0x99, 0x90, 0x98, 0x4b, 0xe1, 0x62, 0x99, 0x44, 0xba, 0xdf, 0x8a, 0x77, 0xab, 0x56, 0xba,
	0x5b, 0xb5, 0x7a, 0xe9, 0x6e, 0x95, 0xcd, 0xb9, 0xae, 0xc6, 0x9c, 0x48, 0xd4, 0x81, 0xdd, 0xb9,
	0x99, 0xa8, 0x59, 0xb6, 0xd7, 0xb2, 0xec, 0xcc, 0xa6, 0xa5, 0xe2, 0x78, 0x0a, 0x10, 0x85, 0x9e,
	0x9e, 0xfb, 0x58, 0x26, 0x0b, 0xc3, 0x2a, 0x78, 0x39, 0xb1, 0x8e, 0xa1, 0xf1, 0xca, 0xa8, 0xa1,
	0xa5, 0xf5, 0xd0, 0xc4, 0xfa, 0x44, 0xaa, 0xec, 0xa5, 0xd0, 0xc1, 0x54, 0xff, 0x62, 0xca, 0x99,
	0xba, 0x33, 0x6d, 0xda, 0x50, 0x9d, 0x7f, 0x15, 0x35, 0xa3, 0xc4, 0x25, 0x8b, 0x26, 0x9e, 0x2b,
	0x2e, 0x31, 0x27, 0xfa, 0x19, 0x4c, 0xa7, 0x12, 0xcb, 0xba, 0x4a, 0x84, 0x1a, 0x50, 0x4c, 0xea,
	0xae, 0xa0, 0xeb, 0x2e, 0x39, 0x35, 0x7f, 0x86, 0x2d, 0x3d, 0x6c, 0xbe, 0x86, 0x52, 0x10, 0xf9,
	0x84, 0xe3, 0x89, 0x46, 0xd7, 0xda, 0x1f, 0xad, 0xf9, 0xa3, 0x29, 0xd4, 0xd9, 0x86, 0x93, 0xa2,
	0x90, 0x05, 0xc5, 0xb8, 0x34, 0xe3, 0xc7, 0x3e, 0xdb, 0x70, 0x92, 0x73, 0xa7, 0x04, 0xdb, 0x6f,
	0xf1, 0x24, 0x22, 0x0f, 0x7f, 0x84, 0x52, 0x02, 0x44, 0xf7, 0xa1, 0xde, 0xed, 0x77, 0xdc, 0x9e,
	0x7d, 0xea, 0xb8, 0xf6, 0x8b, 0x8b, 0x93, 0x1f, 0xec, 0xef, 0xea, 0x1b, 0xa8, 0x06, 0x90, 0x49,
	0x1f, 0xd5, 0x8d, 0xdc, 0xb9, 0x5d, 0x2f, 0xe4, 0xce, 0x8f, 0xeb, 0x9b, 0x9d, 0x83, 0x57, 0x2b,
	0xd6, 0xf0, 0x41, 0x51, 0xe7, 0xf8, 0xf1, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x40, 0xea, 0xf8,
	0x7f, 0xd4, 0x0b, 0x00, 0x00,
}
