locals {
  region = "us-west-2"
}

provider "aws" {
  version = "~> 2.0"
  region  = local.region
}

terraform {
  required_version = ">= 0.11"

  backend "s3" {
    bucket = "twitch-eventbus-prod"
    key    = "tfstate/eventbus/twitch-eventbus-prod/account/terraform.tfstate"
    region = "us-west-2"
  }
}

resource "aws_ecr_repository" "controlplane_httpserver" {
  name = "controlplane-httpserver"
}

resource "aws_ecr_lifecycle_policy" "controlplane_httpserver_lifecycle_policy" {
  repository = aws_ecr_repository.controlplane_httpserver.name

  policy = <<EOF
{
    "rules": [
        {
            "rulePriority": 1,
            "description": "Keep 30 most recent images",
            "selection": {
                "tagStatus": "any",
                "countType": "imageCountMoreThan",
                "countNumber": 30
            },
            "action": {
                "type": "expire"
            }
        }
    ]
}
EOF

}

resource "aws_ecr_repository" "controlplane_converger" {
  name = "controlplane-converger"
}

resource "aws_ecr_lifecycle_policy" "controlplane_converger_lifecycle_policy" {
  repository = aws_ecr_repository.controlplane_converger.name

  policy = <<EOF
{
    "rules": [
        {
            "rulePriority": 1,
            "description": "Keep 30 most recent images",
            "selection": {
                "tagStatus": "any",
                "countType": "imageCountMoreThan",
                "countNumber": 30
            },
            "action": {
                "type": "expire"
            }
        }
    ]
}
EOF

}

resource "aws_ecr_repository" "controlplane_validator" {
  name = "controlplane-validator"
}

resource "aws_ecr_lifecycle_policy" "controlplane_validator_lifecycle_policy" {
  repository = aws_ecr_repository.controlplane_validator.name

  policy = <<EOF
{
    "rules": [
        {
            "rulePriority": 1,
            "description": "Keep 30 most recent images",
            "selection": {
                "tagStatus": "any",
                "countType": "imageCountMoreThan",
                "countNumber": 30
            },
            "action": {
                "type": "expire"
            }
        }
    ]
}
EOF

}

resource "aws_ecr_repository" "dashboard" {
  name = "dashboard"
}

resource "aws_ecr_lifecycle_policy" "dashboard-lifecycle-policy" {
  repository = aws_ecr_repository.dashboard.name

  policy = <<EOF
{
    "rules": [
        {
            "rulePriority": 1,
            "description": "Keep 30 most recent images",
            "selection": {
                "tagStatus": "any",
                "countType": "imageCountMoreThan",
                "countNumber": 30
            },
            "action": {
                "type": "expire"
            }
        }
    ]
}
EOF

}

# Create the CloudWatch read-only role for exporting CloudWatch metrics to Grafana
# https://wiki.twitch.com/display/SYS/Grafana+-+Adding+New+Cloudwatch+Data+Source
module "grafana_cloudwatch" {
  source      = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/grafana_datasource.git?ref=v1.1.1"
  aws_region  = "us-west-2"
  aws_profile = ""
}

module "osiris" {
  source = "../../modules/osiris"
  vpc_id = "vpc-0977d2d3037202c79"
}

module "guardian" {
  source                 = "../../modules/guardian"
  vpc_id                 = "vpc-0977d2d3037202c79"
  subnet_ids             = ["subnet-00a5db39a43685408", "subnet-0930151ba3b01750a", "subnet-0a7a978cd1d8837d3"]
  ingress_security_group = "sg-078dd23c6313c6529"
}

module "s2s" {
  source = "../../modules/s2s"
}

module "badges" {
  source             = "../../modules/badges"
  environment        = "production"
  s3_bucket          = "event-bus-badges"
  vpc_id             = "vpc-0977d2d3037202c79"
  security_group_ids = ["sg-078dd23c6313c6529"]
}

resource "aws_s3_bucket" "eventbus_client_logs" {
  bucket = "eventbus-client-logs-production"
  acl    = "log-delivery-write"
}

resource "aws_s3_bucket" "eventbus_config" {
  bucket = "eventbus-config.internal.justin.tv"
  acl    = "private"

  versioning {
    enabled = true
  }

  logging {
    target_bucket = aws_s3_bucket.eventbus_client_logs.id
  }
}

module "authorized_fields_usage" {
  source      = "../../modules/authorized_fields_usage"
  environment = "production"
  account_id  = "859517684765"
}

module "a2z_dns" {
  source = "../../modules/dns_delegation_setup"
  zone   = "prod.eventbus.twitch.a2z.com"
}

module "xarth_dns" {
  source = "../../modules/dns_delegation_setup"
  zone   = "eventbus.xarth.tv"
}

module "admin_cli_cicd" {
  source      = "../../modules/admin_cli_cicd"
  environment = "production"
}