provider "aws" {
  version = "~> 2.0"
  region  = "us-west-2"
}

locals {
  region       = "us-west-2"
  environment  = "e2e-test"
  account_name = "twitch-eventbus-pub-test"
  account_id   = "567312298267"
}

terraform {
  required_version = ">= 0.11"

  backend "s3" {
    bucket = "twitch-eventbus-pub-test"
    key    = "tfstate/eventbus/twitch-eventbus-pub-test/terraform.state"
    region = "us-west-2"
  }
}

# A role the E2E test can use to publish messages
resource "aws_iam_role" "e2e_publisher_role" {
  name = "e2e-publisher-role"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "AWS": "arn:aws:iam::793846415324:role/e2e-test-runner"
      },
      "Effect": "Allow"
    }
  ]
}
EOF
}

# Onboard this E2E test account to the real EventBus CFN
resource "aws_cloudformation_stack" "eventbus" {
  name         = "EventBus"
  capabilities = ["CAPABILITY_NAMED_IAM"]
  template_url = "https://eventbus-e2e-test-setup.s3.us-west-2.amazonaws.com/cloudformation.yaml"
}

// Allow the e2e test execution role to behave like an eventbus publisher with the proper role attached
resource "aws_iam_role_policy_attachment" "eventbus_access_attachment" {
  role       = "${aws_iam_role.e2e_publisher_role.name}"
  policy_arn = "${aws_cloudformation_stack.eventbus.outputs["EventBusAccessPolicyARN"]}"
}
