locals {
  jenkins_aws_account_id = "043714768218"
}

data "aws_caller_identity" "current" {}

resource "aws_s3_bucket" "eventbus_admin_cli_bucket" {
  bucket = "eventbus-admin-cli-${var.environment}"
  acl    = "private"
}

resource "aws_iam_role" "jenkins_s3_uploader_role" {
  name = "jenkins-admin-cli-uploader"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::${local.jenkins_aws_account_id}:root"
        ]
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "jenkins_s3_uploader_policy" {
  name = "jenkins-s3-uploader-policy"
  role = aws_iam_role.jenkins_s3_uploader_role.id

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "UploadPermissions",
            "Effect": "Allow",
            "Action": "s3:PutObject",
            "Resource": [
                "arn:aws:s3:::eventbus-admin-cli-${var.environment}/*",
                "arn:aws:s3:::eventbus-admin-cli-${var.environment}"
            ]
        }
    ]
}
EOF
}