resource "aws_cloudwatch_metric_alarm" "cpu_utilization_httpserver" {
  alarm_name                = "cpu-utilization-httpserver"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  threshold                 = "80"
  alarm_description         = "httpserver CPUUtilization has exceeded 80%"
  insufficient_data_actions = []
  ok_actions                = ["${module.pagerduty.pd_high_urgency_arn}"]
  alarm_actions             = ["${module.pagerduty.pd_high_urgency_arn}"]

  metric_query {
    id          = "m1"
    return_data = true

    metric {
      metric_name = "CPUUtilization"
      namespace   = "AWS/ECS"
      period      = "120"
      stat        = "Sum"
      unit        = "Percent"

      dimensions = {
        ClusterName = "eventbus-${var.environment}"
        ServiceName = "controlplane-httpserver-${var.environment}"
      }
    }
  }
}

resource "aws_cloudwatch_metric_alarm" "cpu_utilization_converger" {
  alarm_name                = "cpu-utilization-converger"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  threshold                 = "80"
  alarm_description         = "converger CPUUtilization has exceeded 80%"
  insufficient_data_actions = []
  ok_actions                = ["${module.pagerduty.pd_high_urgency_arn}"]
  alarm_actions             = ["${module.pagerduty.pd_high_urgency_arn}"]

  metric_query {
    id          = "m1"
    return_data = true

    metric {
      metric_name = "CPUUtilization"
      namespace   = "AWS/ECS"
      period      = "120"
      stat        = "Sum"
      unit        = "Percent"

      dimensions = {
        ClusterName = "eventbus-${var.environment}"
        ServiceName = "controlplane-converger-${var.environment}"
      }
    }
  }
}

resource "aws_cloudwatch_metric_alarm" "cpu_utilization_dashboard" {
  alarm_name                = "cpu-utilization-dashboard"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  threshold                 = "80"
  alarm_description         = "dashboard CPUUtilization has exceeded 80%"
  insufficient_data_actions = []
  ok_actions                = ["${module.pagerduty.pd_high_urgency_arn}"]
  alarm_actions             = ["${module.pagerduty.pd_high_urgency_arn}"]

  metric_query {
    id          = "m1"
    return_data = true

    metric {
      metric_name = "CPUUtilization"
      namespace   = "AWS/ECS"
      period      = "120"
      stat        = "Average"
      unit        = "Percent"

      dimensions = {
        ClusterName = "eventbus-${var.environment}"
        ServiceName = "dashboard-${var.environment}"
      }
    }
  }
}

resource "aws_cloudwatch_metric_alarm" "memory_utilization_httpserver" {
  alarm_name                = "memory-utilization-httpserver"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  threshold                 = "60"
  alarm_description         = "httpserver MemoryUtilization has exceeded 60%"
  insufficient_data_actions = []
  ok_actions                = ["${module.pagerduty.pd_high_urgency_arn}"]
  alarm_actions             = ["${module.pagerduty.pd_high_urgency_arn}"]

  metric_query {
    id          = "m1"
    return_data = true

    metric {
      metric_name = "MemoryUtilization"
      namespace   = "AWS/ECS"
      period      = "120"
      stat        = "Average"
      unit        = "Percent"

      dimensions = {
        ClusterName = "eventbus-${var.environment}"
        ServiceName = "controlplane-httpserver-${var.environment}"
      }
    }
  }
}

resource "aws_cloudwatch_metric_alarm" "memory_utilization_converger" {
  alarm_name                = "memory-utilization-converger"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  threshold                 = "60"
  alarm_description         = "converger MemoryUtilization has exceeded 60%"
  insufficient_data_actions = []
  ok_actions                = ["${module.pagerduty.pd_high_urgency_arn}"]
  alarm_actions             = ["${module.pagerduty.pd_high_urgency_arn}"]

  metric_query {
    id          = "m1"
    return_data = true

    metric {
      metric_name = "MemoryUtilization"
      namespace   = "AWS/ECS"
      period      = "120"
      stat        = "Average"
      unit        = "Percent"

      dimensions = {
        ClusterName = "eventbus-${var.environment}"
        ServiceName = "controlplane-converger-${var.environment}"
      }
    }
  }
}

resource "aws_cloudwatch_metric_alarm" "memory_utilization_dashboard" {
  alarm_name                = "memory-utilization-dashboard"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  threshold                 = "60"
  alarm_description         = "dashboard MemoryUtilization has exceeded 60%"
  insufficient_data_actions = []
  ok_actions                = ["${module.pagerduty.pd_high_urgency_arn}"]
  alarm_actions             = ["${module.pagerduty.pd_high_urgency_arn}"]

  metric_query {
    id          = "m1"
    return_data = true

    metric {
      metric_name = "MemoryUtilization"
      namespace   = "AWS/ECS"
      period      = "120"
      stat        = "Average"
      unit        = "Percent"

      dimensions = {
        ClusterName = "eventbus-${var.environment}"
        ServiceName = "dashboard-${var.environment}"
      }
    }
  }
}
