# Alarms to monitor controlplane-updater lambda

# Alarm if any errors occur during controlplane-updater lambda invocation
resource "aws_cloudwatch_metric_alarm" "controlplane_updater_errors" {
  alarm_name                = "controlplane-updater-errors"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "1"
  threshold                 = "1" # TODO: tune
  alarm_description         = "controlplane-updater lambda is encountering errors"
  insufficient_data_actions = []
  ok_actions                = ["${module.pagerduty.pd_high_urgency_arn}"]
  alarm_actions             = ["${module.pagerduty.pd_high_urgency_arn}"]

  metric_query {
    id          = "errors"
    return_data = true

    metric {
      metric_name = "Errors"
      namespace   = "AWS/Lambda"
      period      = "300"
      stat        = "Sum"
      unit        = "Count"

      dimensions = {
        FunctionName = "controlplane-updater"
      }
    }
  }
}
