resource "aws_cloudwatch_metric_alarm" "kms_crypto_api_usage_warn" {
  alarm_name                = "kms-crypto-api-usage-warn"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "1"
  threshold                 = "${var.kms_crypto_api_max_rps * 60 * 0.05}"
  alarm_description         = "kms crypto api usage exceeded 5% of our rate limit"
  insufficient_data_actions = []
  ok_actions                = ["${module.pagerduty.pd_low_urgency_arn}"]
  alarm_actions             = ["${module.pagerduty.pd_low_urgency_arn}"]

  metric_query {
    id          = "m1"
    return_data = true

    metric {
      metric_name = "CallCount"
      namespace   = "AWS/Usage"
      period      = "60"
      stat        = "Sum"
      unit        = "Count"

      dimensions = {
        Type     = "API"
        Resource = "CryptographicOperationsSymmetric"
        Service  = "KMS"
        Class    = "None"
      }
    }
  }
}

resource "aws_cloudwatch_metric_alarm" "kms_crypto_api_usage" {
  alarm_name                = "kms-crypto-api-usage"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "1"
  threshold                 = "${var.kms_crypto_api_max_rps * 60 * 0.10}"
  alarm_description         = "kms crypto api usage exceeded 10% of our rate limit"
  insufficient_data_actions = []
  ok_actions                = ["${module.pagerduty.pd_high_urgency_arn}"]
  alarm_actions             = ["${module.pagerduty.pd_high_urgency_arn}"]

  metric_query {
    id          = "m1"
    return_data = true

    metric {
      metric_name = "CallCount"
      namespace   = "AWS/Usage"
      period      = "60"
      stat        = "Sum"
      unit        = "Count"

      dimensions = {
        Type     = "API"
        Resource = "CryptographicOperationsSymmetric"
        Service  = "KMS"
        Class    = "None"
      }
    }
  }
}
