locals {
  ssh_sudoer_ldap_group              = "team-eventbus"
  team_name                          = "async"
  controlplane_httpserver_app_name   = "controlplane-httpserver-${var.environment}"
  controlplane_converger_app_name    = "controlplane-converger-${var.environment}"
  dashboard_app_name                 = "dashboard-${var.environment}"
  controlplane_httpserver_app_port   = 8888
  controlplane_httpserver_debug_port = 6888
  controlplane_converger_app_port    = 8889
  controlplane_converger_debug_port  = 6889
  dashboard_app_port                 = 8000
  dashboard_debug_port               = 6000
  owner_email                        = "eventbus@twitch.tv"

  region       = "us-west-2"
  cluster_name = "eventbus-${var.environment}"

  controlplane_validator_app_name   = "controlplane-validator-${var.environment}"
  controlplane_validator_app_port   = 8887
  controlplane_validator_debug_port = 6887
}

data "aws_iam_account_alias" "current" {
}

data "aws_caller_identity" "current" {
}

module "core_account" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//core_account?ref=v2.1.2"

  environment = var.environment
  team        = local.team_name
  xray_role   = "*"
}

module "ecs" {
  source = "../ecs"

  ecs_host_iam_id                     = module.core_account.container_instance_profile_id
  cluster_name                        = local.cluster_name
  owner_email                         = local.owner_email
  environment                         = var.environment
  region                              = var.region
  controlplane_httpserver_app_name    = local.controlplane_httpserver_app_name
  controlplane_converger_app_name     = local.controlplane_converger_app_name
  dashboard_app_name                  = local.dashboard_app_name
  ssh_sudoer_ldap_group               = local.ssh_sudoer_ldap_group
  service_iam_role                    = module.core_account.service_iam_role
  ec2_instance_type                   = var.ec2_instance_type
  cluster_size                        = var.cluster_size
  controlplane_httpserver_image       = var.controlplane_httpserver_image
  controlplane_converger_image        = var.controlplane_converger_image
  dashboard_image                     = var.dashboard_image
  controlplane_httpserver_app_count   = var.controlplane_httpserver_app_count
  controlplane_converger_app_count    = var.controlplane_converger_app_count
  dashboard_app_count                 = var.dashboard_app_count
  controlplane_httpserver_task_memory = var.controlplane_httpserver_task_memory
  controlplane_converger_task_memory  = var.controlplane_converger_task_memory
  dashboard_task_memory               = var.dashboard_task_memory
  controlplane_httpserver_task_cpu    = var.controlplane_httpserver_task_cpu
  controlplane_converger_task_cpu     = var.controlplane_converger_task_cpu
  dashboard_task_cpu                  = var.dashboard_task_cpu
  controlplane_httpserver_app_port    = local.controlplane_httpserver_app_port
  controlplane_httpserver_debug_port  = local.controlplane_httpserver_debug_port
  controlplane_converger_app_port     = local.controlplane_converger_app_port
  controlplane_converger_debug_port   = local.controlplane_converger_debug_port

  dashboard_app_port         = local.dashboard_app_port
  dashboard_debug_port       = local.dashboard_debug_port
  dns_servers                = var.dns_servers
  target_group_id            = var.target_group_id
  subject_alternative_name   = var.subject_alternative_name
  rds_reader_hostname        = var.rds_reader_hostname
  rds_writer_hostname        = var.rds_writer_hostname
  slack_channel              = var.slack_channel
  authorized_field_key_arn   = var.authorized_field_key_arn
  encryption_at_rest_key_arn = var.encryption_at_rest_key_arn

  controlplane_validator_app_port                   = local.controlplane_validator_app_port
  controlplane_validator_debug_port                 = local.controlplane_validator_debug_port
  controlplane_validator_task_cpu                   = var.controlplane_validator_task_cpu
  controlplane_validator_task_memory                = var.controlplane_validator_task_memory
  controlplane_validator_app_count                  = var.controlplane_validator_app_count
  controlplane_validator_app_name                   = local.controlplane_validator_app_name
  controlplane_validator_image                      = var.controlplane_validator_image
  controlplane_validator_slack_channel              = var.controlplane_validator_slack_channel
  controlplane_validator_pagerduty_enabled          = var.controlplane_validator_pagerduty_enabled
  controlplane_validator_pagerduty_high_urgency_key = var.controlplane_validator_pagerduty_high_urgency_key
  controlplane_validator_pagerduty_low_urgency_key  = var.controlplane_validator_pagerduty_low_urgency_key
}

