variable "environment" {
  description = "Keep envs separate"
}

variable "controlplane_httpserver_image" {
  description = "Docker controlplane httpserver image to run in ECS"
}

variable "controlplane_converger_image" {
  description = "Docker controlplane converger image to run in ECS"
}

variable "dashboard_image" {
  description = "Docker dashboard image to run in ECS"
}

variable "controlplane_httpserver_app_count" {
  description = "Number of docker containers to run for controlplane httpserver"
}

variable "controlplane_converger_app_count" {
  description = "Number of docker containers to run for controlplane converger"
}

variable "dashboard_app_count" {
  description = "Number of docker containers to run for dashboard"
}

variable "controlplane_httpserver_task_memory" {
  description = "Docker instance memory to provision for controlplane httpserver (in MiB)"
}

variable "controlplane_converger_task_memory" {
  description = "Docker instance memory to provision for controlplane converger (in MiB)"
}

variable "dashboard_task_memory" {
  description = "Docker instance memory to provision for dashboard (in MiB)"
}

variable "controlplane_httpserver_task_cpu" {
  description = "Docker instance CPU units to provision for controlplane httpserver (1 vCPU = 1024 CPU units)"
}

variable "controlplane_converger_task_cpu" {
  description = "Docker instance CPU units to provision for controlplane converger (1 vCPU = 1024 CPU units)"
}

variable "dashboard_task_cpu" {
  description = "Docker instance CPU units to provision for dashboard (1 vCPU = 1024 CPU units)"
}

variable "cluster_size" {
  type = map(string)

  default = {
    min     = 3
    max     = 5
    desired = 3
  }
}

variable "ec2_instance_type" {
  description = "Type of EC2 instance used in the ECS Cluster running the application"
  default     = "m5.large"
}

variable "dns_servers" {
  description = "DNS (non-production) servers for resolving the twitch.tv and justin.tv zones. The production servers should overwrite these."
  type        = list(string)

  default = ["10.202.125.133", "10.202.124.213", "10.202.126.110", "10.202.124.10"]
}

variable "target_group_id" {
  description = "If specified, the task will join this target group instead of its own load balancer's target group"
  default     = ""
}

variable "subject_alternative_name" {
  description = "For SAN to establish certs for eventbus.internal only in prod"
  default     = []
}

variable "region" {
  description = "The AWS region to create things in."
}

variable "rds_reader_hostname" {
  description = "DB hostname"
}

variable "rds_writer_hostname" {
  description = "DB hostname"
}

variable "slack_channel" {
  description = "Slack channel"
  default     = ""
}

variable "authorized_field_key_arn" {
  description = "ARN of the KMS CMK used for cryptographic operations on authorized fields"
}

variable "encryption_at_rest_key_arn" {
  description = "ARN of the KMS CMK used to encrypt payloads in SNS+SQS"
}

variable "controlplane_validator_image" {
  description = "Docker controlplane validator image to run in ECS"
}

variable "controlplane_validator_app_count" {
  description = "Number of docker containers to run for controlplane validator"
}

variable "controlplane_validator_task_memory" {
  description = "Docker instance memory to provision for controlplane validator (in MiB)"
}

variable "controlplane_validator_task_cpu" {
  description = "Docker instance CPU units to provision for controlplane validator (1 vCPU = 1024 CPU units)"
}

variable "controlplane_validator_slack_channel" {
  description = "The Slack channel in which to post validation failure messages"
}

variable "controlplane_validator_pagerduty_enabled" {
  description = "Whether or not to use the pagerduty notification channel to create alerts"
  default     = false
}

variable "controlplane_validator_pagerduty_high_urgency_key" {
  description = "The integration key of the pagerduty high urgency queue"
  default     = ""
}

variable "controlplane_validator_pagerduty_low_urgency_key" {
  description = "The integration key of the pagerduty low urgency queue"
  default     = ""
}

