resource "aws_s3_bucket" "cloudtrail_logs" {
  bucket = "eventbus-${var.environment}-authorized-fields-cloudtrail"
  acl    = "private"

  lifecycle_rule {
    enabled = true
    expiration {
      days = 30
    }
  }

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "AWSCloudTrailAclCheck20150319",
            "Effect": "Allow",
            "Principal": {"Service": "cloudtrail.amazonaws.com"},
            "Action": "s3:GetBucketAcl",
            "Resource": "arn:aws:s3:::eventbus-${var.environment}-authorized-fields-cloudtrail"
        },
        {
            "Sid": "AWSCloudTrailWrite20150319",
            "Effect": "Allow",
            "Principal": {"Service": "cloudtrail.amazonaws.com"},
            "Action": "s3:PutObject",
            "Resource": "arn:aws:s3:::eventbus-${var.environment}-authorized-fields-cloudtrail/AWSLogs/${var.account_id}/*",
            "Condition": {"StringEquals": {"s3:x-amz-acl": "bucket-owner-full-control"}}
        }
    ]
}
EOF

}

resource "aws_cloudtrail" "authorized_fields_cloudtrail" {
  name                          = "eventbus-${var.environment}-authorized-fields-cloudtrail"
  s3_bucket_name                = "${aws_s3_bucket.cloudtrail_logs.id}"
  is_multi_region_trail         = true
  include_global_service_events = true
  event_selector {
    read_write_type           = "ReadOnly"
    include_management_events = true
  }
}

