resource "aws_s3_bucket" "autoprof_bucket" {
  bucket = "autoprof-${var.service_name}-${var.environment}-${var.region}"
  acl    = "private"
}

resource "aws_iam_policy" "autoprof_iam_policy" {
  name        = "autoprof-${var.service_name}-${var.environment}-${var.region}"
  path        = "/"
  description = "Allows ${var.service_name} to post profiling data to S3"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "s3:PutObject"
      ],
      "Effect": "Allow",
      "Resource": "${aws_s3_bucket.autoprof_bucket.arn}"
    }
  ]
}
EOF
}
