variable "environment" {
  description = "The environment in which this lambda operates"
}

variable "account_id" {
  description = "The AWS account id to give access to"
}

variable "s3_bucket" {
  description = "The S3 bucket for clients to use for retrieving Event Bus metadata"
}

variable "encryption_at_rest_cmk_key_id" {
  description = "The ID for the KMS CMK which will be used to publish encrypted events to SNS"
}

variable "authorized_fields_cmk_key_id" {
  description = "The ID for the KMS CMK which will be used to encrypt and decrypt authorized fields"
}

variable "latest_version" {
  description = "The version which the latest CloudFormation bundle (cloudformation.yaml) holds"
}

