provider "aws" {
  version = "~> 2.66"
  region  = "us-west-2"
}

provider "aws" {
  alias   = "east"
  version = "~> 2.66"
  region  = "us-east-1"
}

resource "aws_kms_key" "db_backup_kms_key_west" {
  description = "kms key for cross region db backups"
}

resource "aws_kms_key" "db_backup_kms_key_east" {
  provider = aws.east

  description = "kms key for cross region db backups"
}

resource "aws_iam_role" "db_backup_role_west" {
  name               = "db_backup_role_west"
  assume_role_policy = <<POLICY
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": ["sts:AssumeRole"],
      "Effect": "allow",
      "Principal": {
        "Service": ["backup.amazonaws.com"]
      }
    }
  ]
}
POLICY
}

resource "aws_iam_role" "db_backup_role_east" {
  provider = aws.east

  name               = "db_backup_role_east"
  assume_role_policy = <<POLICY
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": ["sts:AssumeRole"],
      "Effect": "allow",
      "Principal": {
        "Service": ["backup.amazonaws.com"]
      }
    }
  ]
}
POLICY
}

resource "aws_iam_role_policy_attachment" "db_backup_role_policy_attachment_west" {
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSBackupServiceRolePolicyForBackup"
  role       = aws_iam_role.db_backup_role_west.name
}

resource "aws_iam_role_policy_attachment" "db_backup_role_policy_attachment_east" {
  provider = aws.east

  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSBackupServiceRolePolicyForBackup"
  role       = aws_iam_role.db_backup_role_east.name
}

resource "aws_backup_vault" "db_backup_vault_west" {
  name        = "db_backup_vault_west"
  kms_key_arn = aws_kms_key.db_backup_kms_key_west.arn

  tags = {
      env = var.environment
  }
}

resource "aws_backup_vault" "db_backup_vault_east" {
  provider = aws.east

  name        = "db_backup_vault_east"
  kms_key_arn = aws_kms_key.db_backup_kms_key_east.arn

  tags = {
      env = var.environment
  }
}

resource "aws_backup_plan" "db_backup_plan" {
  name = "db_backup_plan"

  rule {
    rule_name         = "db_backup_rule"
    target_vault_name = aws_backup_vault.db_backup_vault_west.name
    schedule          = "cron(0 20 ? * * *)"
    start_window      = 120
    completion_window = 720

    lifecycle {
        cold_storage_after = 0
        delete_after       = 90
    }

    copy_action {
      lifecycle {
        cold_storage_after = 0
        delete_after       = 90
      }

      destination_vault_arn = aws_backup_vault.db_backup_vault_east.arn
    }
  }

  tags = {
      env = var.environment
  }
}

resource "aws_backup_selection" "db_backup_selection" {
  iam_role_arn = aws_iam_role.db_backup_role_west.arn
  name         = "db_backup_selection"
  plan_id      = aws_backup_plan.db_backup_plan.id

  resources = [var.db_arn]
}

