data "aws_iam_policy_document" "eventbus_assume_policy" {
  statement {
    actions   = ["sts:AssumeRole"]
    effect    = "Allow"
    resources = ["arn:aws:iam::*:role/EventBus*"]
  }
}

resource "aws_iam_role_policy" "eventbus_assume_policy" {
  name   = "eventbus_assume_policy"
  policy = "${data.aws_iam_policy_document.eventbus_assume_policy.json}"
  role   = "${var.role_name}"
}

data "aws_iam_policy_document" "sns_policy" {
  statement {
    actions   = ["sns:*"]
    effect    = "Allow"
    resources = ["*"]
  }
}

resource "aws_iam_role_policy" "sns_policy" {
  name   = "sns_policy"
  policy = "${data.aws_iam_policy_document.sns_policy.json}"
  role   = "${var.role_name}"
}

data "aws_iam_policy_document" "cloudwatch_read_policy" {
  statement {
    actions   = ["cloudwatch:GetMetricData"]
    effect    = "Allow"
    resources = ["*"]
  }
}

resource "aws_iam_role_policy" "cloudwatch_read_access" {
  name   = "eventbus_cloudwatch_read"
  role   = "${var.role_name}"
  policy = "${data.aws_iam_policy_document.cloudwatch_read_policy.json}"
}

data "aws_iam_policy_document" "cloudwatch_write_policy" {
  statement {
    actions   = ["cloudwatch:PutMetricData"]
    effect    = "Allow"
    resources = ["*"]
  }
}

resource "aws_iam_role_policy" "cloudwatch_write_access" {
  name   = "eventbus_cloudwatch_write"
  role   = "${var.role_name}"
  policy = "${data.aws_iam_policy_document.cloudwatch_write_policy.json}"
}

resource "aws_iam_role_policy_attachment" "s3_role" {
  role       = "${var.role_name}"
  policy_arn = "arn:aws:iam::aws:policy/AmazonS3FullAccess"
}

data "aws_iam_policy_document" "kms_policy" {
  statement {
    actions   = ["kms:DescribeKey", "kms:GetKeyPolicy", "kms:PutKeyPolicy", "kms:CreateGrant", "kms:ListGrants", "kms:RevokeGrant", "kms:GenerateDataKey", "kms:GenerateDataKeyWithoutPlaintext", "kms:Encrypt"]
    effect    = "Allow"
    resources = ["*"]
  }
}

resource "aws_iam_role_policy" "kms_access" {
  name   = "eventbus_kms_access"
  role   = "${var.role_name}"
  policy = "${data.aws_iam_policy_document.kms_policy.json}"
}
