data "aws_route53_zone" "a2z" {
  name = "${var.environment}.eventbus.twitch.a2z.com."
}

# DNS CNAME: dashboard a2z record ==> dashboard ALB DNS name
resource "aws_route53_record" "a2z_cname" {
  zone_id = data.aws_route53_zone.a2z.zone_id
  name    = "dashboard.${var.environment}.eventbus.twitch.a2z.com"
  type    = "CNAME"
  ttl     = "300"
  records = [aws_alb.dashboard_alb.dns_name]
}

# ACM cert for above CNAME
resource "aws_acm_certificate" "dashboard_ssl_cert_a2z" {
  domain_name               = "dashboard.${var.environment}.eventbus.twitch.a2z.com"
  validation_method         = "DNS"
  subject_alternative_names = var.subject_alternative_name

  tags = {
    app = var.dashboard_app_name
    env = var.environment
  }

  lifecycle {
    create_before_destroy = true
  }
}

# Cert validation
resource "aws_route53_record" "dashboard_cert_validation_cname" {
  name    = aws_acm_certificate.dashboard_ssl_cert_a2z.domain_validation_options.0.resource_record_name
  type    = aws_acm_certificate.dashboard_ssl_cert_a2z.domain_validation_options.0.resource_record_type
  zone_id = data.aws_route53_zone.a2z.zone_id
  records = [aws_acm_certificate.dashboard_ssl_cert_a2z.domain_validation_options.0.resource_record_value]
  ttl     = 60
}

resource "aws_acm_certificate_validation" "dashboard_cert_validation_status" {
  certificate_arn         = aws_acm_certificate.dashboard_ssl_cert_a2z.arn
  validation_record_fqdns = [aws_route53_record.dashboard_cert_validation_cname.fqdn]
}

# DNS CNAME: controlplane a2z record ==> controlplane ALB DNS name
resource "aws_route53_record" "a2z_cname_controlplane" {
  zone_id = data.aws_route53_zone.a2z.zone_id
  name    = "controlplane.${var.environment}.eventbus.twitch.a2z.com"
  type    = "CNAME"
  ttl     = "300"
  records = ["${aws_alb.controlplane_httpserver.dns_name}"]
}

# ACM cert for above CNAME
resource "aws_acm_certificate" "controlplane_ssl_cert_a2z" {
  domain_name               = "controlplane.${var.environment}.eventbus.twitch.a2z.com"
  validation_method         = "DNS"
  subject_alternative_names = var.subject_alternative_name

  tags = {
    app = var.dashboard_app_name
    env = var.environment
  }

  lifecycle {
    create_before_destroy = true
  }
}

# Cert validation
resource "aws_route53_record" "controlplane_cert_validation_cname" {
  name    = aws_acm_certificate.controlplane_ssl_cert_a2z.domain_validation_options.0.resource_record_name
  type    = aws_acm_certificate.controlplane_ssl_cert_a2z.domain_validation_options.0.resource_record_type
  zone_id = data.aws_route53_zone.a2z.zone_id
  records = [aws_acm_certificate.controlplane_ssl_cert_a2z.domain_validation_options.0.resource_record_value]
  ttl     = 60
}

resource "aws_acm_certificate_validation" "controlplane_cert_validation_status" {
  certificate_arn         = aws_acm_certificate.controlplane_ssl_cert_a2z.arn
  validation_record_fqdns = [aws_route53_record.controlplane_cert_validation_cname.fqdn]
}