variable "ec2_instance_type" {
  description = "Type of EC2 instance"
}

variable "cluster_size" {
  description = "the min, max, and desired # of instances to run"
  type        = map(string)
}

variable "controlplane_httpserver_task_memory" {
  description = "Docker instance memory to provision for controlplane httpserver (in MiB)"
}

variable "controlplane_converger_task_memory" {
  description = "Docker instance memory to provision for controlplane converger (in MiB)"
}

variable "dashboard_task_memory" {
  description = "Docker instance memory to provision for dashboard (in MiB)"
}

variable "controlplane_httpserver_task_cpu" {
  description = "Docker instance CPU units to provision for controlplane httpserver (1 vCPU = 1024 CPU units)"
}

variable "controlplane_converger_task_cpu" {
  description = "Docker instance CPU units to provision for controlplane converger (1 vCPU = 1024 CPU units)"
}

variable "dashboard_task_cpu" {
  description = "Docker instance CPU units to provision for dashboard (1 vCPU = 1024 CPU units)"
}

variable "controlplane_httpserver_app_count" {
  description = "Number of docker containers to run for controlplane httpserver"
}

variable "controlplane_converger_app_count" {
  description = "Number of docker containers to run for controlplane converger"
}

variable "dashboard_app_count" {
  description = "Number of docker containers to run for dashboard"
}

variable "dns_servers" {
  description = "DNS (non-production) servers for resolving the twitch.tv and justin.tv zones"
  type        = list(string)
  default     = ["10.202.125.133", "10.202.124.213", "10.202.126.110", "10.202.124.10"]
}

variable "ecs_host_iam_id" {
  description = "ID of IAM role for the ECS Host. Should be created by the external create_account module"
}

variable "ssh_sudoer_ldap_group" {
  description = "Members of this LDAP group may sudo when ssh'd to the EC2's"
}

variable "service_iam_role" {
  description = "The ARN of the IAM role for the ECS Service"
}

variable "cluster_name" {
  description = "The name of this ECS cluster"
}

variable "environment" {
  description = "Keep envs separate"
}

variable "owner_email" {
  description = "The email of the owning group, tagged in the ASG"
}

variable "task_cleanup_wait_duration" {
  description = "Time duration to wait from when an ECS task is stopped until the Docker container is removed."
  default     = "30m"
}

variable "controlplane_httpserver_app_name" {
  description = "The controlplane httpserver app name, used with environment to create alarms"
}

variable "controlplane_converger_app_name" {
  description = "The controlplane converger app name, used with environment to create alarms"
}

variable "dashboard_app_name" {
  description = "The dashboard app name, used with environment to create alarms"
}

variable "controlplane_httpserver_app_port" {
  description = "Port exposed by the docker image to redirect traffic to controlplane httpserver"
}

variable "controlplane_converger_app_port" {
  description = "Port exposed by the docker image to redirect traffic to controlplane converger"
}

variable "controlplane_httpserver_debug_port" {
  description = "Port that serves debug traffic like healthchecks, pprof, and configuration introspection for controlplane httpserver"
}

variable "controlplane_converger_debug_port" {
  description = "Port that serves debug traffic like healthchecks, pprof, and configuration introspection for controlplane converger"
}

variable "dashboard_app_port" {
  description = "Port exposed by the docker image to redirect traffic to dashboard"
}

variable "dashboard_debug_port" {
  description = "Port that serves debug traffic like healthchecks, pprof, and configuration introspection for dashboard"
}

variable "region" {
  description = "The AWS region to create things in."
  default     = "us-west-2"
}

variable "controlplane_httpserver_image" {
  description = "Docker controlplane httpserver image to run in the ECS cluster"
}

variable "controlplane_converger_image" {
  description = "Docker controlplane converger image to run in the ECS cluster"
}

variable "dashboard_image" {
  description = "Docker dashboard image to run in the ECS cluster"
}

variable "team_name" {
  description = "The name of the team owning these resources"
  default     = "async"
}

variable "target_group_id" {
  description = "If specified, the task will join this target group instead of its own load balancer's target group"
  default     = ""
}

variable "lb_slow_start_seconds" {
  default = 0

  description = <<EOD
  The time period during which the load balancer sends a newly registered target
  a linearly increasing share of the traffic to the target group.
  The range is 30-900 seconds. The default is 0 seconds (disabled).
EOD

}

variable "app_log_retention_days" {
  description = "The number of days to log events"
  default     = 30
}

variable "subject_alternative_name" {
  description = "For SAN to establish certs for eventbus.internal only in prod"
  default     = []
}

variable "rds_reader_hostname" {
  description = "DB hostname"
}

variable "rds_writer_hostname" {
  description = "DB hostname"
}

variable "slack_channel" {
  description = "Slack channel"
}

variable "authorized_field_key_arn" {
  description = "ARN of the KMS CMK used for cryptographic operations on authorized fields"
}

variable "encryption_at_rest_key_arn" {
  description = "ARN of the KMS CMK used to encrypt every payload at rest in SNS+SQS"
}

variable "controlplane_validator_task_memory" {
  description = "Docker instance memory to provision for controlplane validator (in MiB)"
}

variable "controlplane_validator_task_cpu" {
  description = "Docker instance CPU units to provision for controlplane validator (1 vCPU = 1024 CPU units)"
}

variable "controlplane_validator_app_count" {
  description = "Number of docker containers to run for controlplane validator"
}

variable "controlplane_validator_app_name" {
  description = "The controlplane validator app name, used with environment to create alarms"
}

variable "controlplane_validator_app_port" {
  description = "Port exposed by the docker image to redirect traffic to controlplane validator"
}

variable "controlplane_validator_debug_port" {
  description = "Port that serves debug traffic like healthchecks, pprof, and configuration introspection for controlplane validator"
}

variable "controlplane_validator_image" {
  description = "Docker controlplane validator image to run in the ECS cluster"
}

variable "controlplane_validator_slack_channel" {
  description = "The Slack channel in which to post validation failure messages"
}

variable "controlplane_validator_pagerduty_enabled" {
  description = "Whether or not to use the pagerduty notification channel to create alerts"
  default     = false
}

variable "controlplane_validator_pagerduty_high_urgency_key" {
  description = "The integration key of the pagerduty high urgency queue"
  default     = ""
}

variable "controlplane_validator_pagerduty_low_urgency_key" {
  description = "The integration key of the pagerduty low urgency queue"
  default     = ""
}