locals {
  service_name = "com.amazonaws.vpce.us-west-2.vpce-svc-039dcfa9417c933ab"
}

resource "aws_security_group" "main" {
  name        = var.prefix
  description = "security group to use with guardian private link"
  vpc_id      = var.vpc_id

  lifecycle {
    // Put this here because I accidentally made prod and staging w/ different
    // descriptions, and you literally need to tear down and re-create the SG
    // in order to change this, but I can't do that without also tearing down the
    // VPC endpoint, which would require starting all over w/ working with secdev
    // to get it authorized. This is way easier, and it's just a description -nherson
    ignore_changes = [description]
  }

  ingress {
    from_port = 443
    to_port   = 443
    protocol  = "tcp"
    self      = "true"
  }

  ingress {
    from_port       = 443
    to_port         = 443
    protocol        = "tcp"
    security_groups = [var.ingress_security_group]
  }

  tags = {
    Name = var.prefix
  }
}

resource "aws_vpc_endpoint" "guardian" {
  vpc_id              = var.vpc_id
  vpc_endpoint_type   = "Interface"
  service_name        = local.service_name
  auto_accept         = false
  subnet_ids          = var.subnet_ids
  security_group_ids  = [aws_security_group.main.id]
  private_dns_enabled = false
}

