# Create a bucket to store Cloudtrail logs

resource "aws_s3_bucket" "cloudtrail_events_bucket" {
  bucket = "cloudtrail-events-${data.aws_caller_identity.current.account_id}"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "AWSCloudTrailAclCheck",
            "Effect": "Allow",
            "Principal": {
              "Service": "cloudtrail.amazonaws.com"
            },
            "Action": "s3:GetBucketAcl",
            "Resource": "arn:aws:s3:::cloudtrail-events-${data.aws_caller_identity.current.account_id}"
        },
        {
            "Sid": "AWSCloudTrailWrite",
            "Effect": "Allow",
            "Principal": {
              "Service": "cloudtrail.amazonaws.com"
            },
            "Action": "s3:PutObject",
            "Resource": "arn:aws:s3:::cloudtrail-events-${data.aws_caller_identity.current.account_id}/*",
            "Condition": {
                "StringEquals": {
                    "s3:x-amz-acl": "bucket-owner-full-control"
                }
            }
        }
    ]
}
EOF

}

# Create our Cloudtrail Trail

resource "aws_cloudtrail" "trail" {
  name = "cloudtrail-events-${data.aws_caller_identity.current.account_id}"

  s3_bucket_name = "cloudtrail-events-${data.aws_caller_identity.current.account_id}"

  include_global_service_events = true
  is_multi_region_trail         = true
  enable_log_file_validation    = true
  depends_on                    = [aws_s3_bucket.cloudtrail_events_bucket]
}

