# Create the role that security can assume
resource "aws_iam_role" "security_audit_role" {
  name = "twitch-security-audit-limited"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::508423404353:root"
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF

}

# Grant access to cloudtrail logs to security
resource "aws_iam_policy" "cloudtrail_policy" {
  name        = "Read_Only_CloudTrail_Policy"
  path        = "/"
  description = "Enables access to Cloudtrail logs"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "cloudtrail:DescribeTrails",
                "cloudtrail:GetEventSelectors",
                "cloudtrail:GetTrailStatus",
                "cloudtrail:ListPublicKeys",
                "cloudtrail:ListTags",
                "cloudtrail:LookupEvents"
            ],
            "Resource": [
                "*"
            ]
        },
        {
            "Effect": "Allow",
            "Action": [
                "s3:Get*",
                "s3:List*",
                "s3:Head*"
            ],
            "Resource": [
                "arn:aws:s3:::cloudtrail-events*"
            ]
        }
    ]

}
EOF

}

# Apply the policy to the role

resource "aws_iam_role_policy_attachment" "cloudtrail_policy_attach" {
  role       = aws_iam_role.security_audit_role.name
  policy_arn = aws_iam_policy.cloudtrail_policy.arn
}

# Grant security access to VPC Flow Logs
resource "aws_iam_policy" "vpc_flow_logs_policy" {
  name        = "Read_Only_VPC_Flow_Logs_Policy"
  path        = "/"
  description = "Enables access to VPC flow logs"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "s3:Get*",
                "s3:List*",
                "s3:Head*"
            ],
            "Resource": [
                "arn:aws:s3:::vpc-flow-logs*"
            ]
        }
    ]
}
EOF

}

# Apply the policy to the role

resource "aws_iam_role_policy_attachment" "vpc_flow_logs_policy_attach" {
  role       = aws_iam_role.security_audit_role.name
  policy_arn = aws_iam_policy.vpc_flow_logs_policy.arn
}

# Grant security generic security audit policy
resource "aws_iam_role_policy_attachment" "cloudtrail_policy_attach_2" {
  role       = aws_iam_role.security_audit_role.name
  policy_arn = "arn:aws:iam::aws:policy/SecurityAudit"
}

