resource "aws_s3_bucket" "vpc_flow_logs_bucket" {
  bucket = "vpc-flow-logs-${data.aws_caller_identity.current.account_id}"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Id": "AWSLogDeliveryWrite20150319",
    "Statement": [
        {
            "Sid": "AWSLogDeliveryWrite",
            "Effect": "Allow",
            "Principal": {
                "Service": "delivery.logs.amazonaws.com"
            },
            "Action": "s3:PutObject",
            "Resource": "arn:aws:s3:::vpc-flow-logs-${data.aws_caller_identity.current.account_id}/*",
            "Condition": {
                "StringEquals": {
                    "s3:x-amz-acl": "bucket-owner-full-control"
                }
            }
        },
        {
            "Sid": "AWSLogDeliveryAclCheck",
            "Effect": "Allow",
            "Principal": {
                "Service": "delivery.logs.amazonaws.com"
            },
            "Action": "s3:GetBucketAcl",
            "Resource": "arn:aws:s3:::vpc-flow-logs-${data.aws_caller_identity.current.account_id}"
        }
    ]
}
EOF

}

resource "aws_flow_log" "vpc_flow_logs" {
  log_destination_type = "s3"
  log_destination      = aws_s3_bucket.vpc_flow_logs_bucket.arn
  traffic_type         = "ALL"
  vpc_id               = var.vpc_id
}

