resource "aws_cloudformation_stack" "osiris" {
  name         = "osiris-${var.osiris_service_name}"
  capabilities = ["CAPABILITY_NAMED_IAM"]
  template_url = "https://s3-us-west-2.amazonaws.com/twitch-osiris-config-production-us-west-2/cf-templates/osiris-latest.yaml"

  parameters = {
    ServiceName             = var.osiris_service_name
    TeamName                = var.team_name
    TeamEmail               = var.team_email
    AdditionalDomains       = join(",", var.additional_domains) #TODO convert to var.domains once cutover done
    InternalFQDN            = var.internal_fqdn
    AlertingEnabled         = "disabled"
    AlertsEmail             = ""
    PagerDutyIntegrationURL = ""
    PingIntegrationName     = var.osiris_pf_integration
    SandstormRole           = var.sandstorm_role
    SandstormPrefix         = var.sandstorm_prefix
    VPC                     = var.vpc_id
    PublicSubnets           = join(",", var.public_subnets)
    PrivateSubnets          = join(",", var.private_subnets)
    InstanceType            = "t3.small"
  }

  depends_on = [aws_route53_record.cname_challenge]
}

resource "aws_route53_record" "a_alias" {
  count = length(var.domains)
  type = "A"
  name = lookup(var.domains[count.index], "name")
  zone_id = lookup(var.domains[count.index], "zone_id")
  alias {
    zone_id = aws_cloudformation_stack.osiris.outputs["LoadBalancerCanonicalHostedZoneID"]
    name = aws_cloudformation_stack.osiris.outputs["LoadBalancerDNSName"]
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "cname_challenge" {
  count = length(var.domains)
  type = "CNAME"
  name = "_acme-challenge.${lookup(var.domains[count.index], "name")}"
  zone_id = lookup(var.domains[count.index], "zone_id")
  records = ["_acme-challenge.${lookup(var.domains[count.index], "name")}.${var.osiris_service_name}.osiris.xarth.tv"]
  ttl = 60
}

