locals {
  pagerduty_keys = {
    prod = {
      high_urgency = "a0909dc609874c6ebaa622236819a0dc" # https://twitchoncall.pagerduty.com/services/PLZTAYL
      low_urgency  = "898b319778b444c1b154f47f639760a7" # https://twitchoncall.pagerduty.com/services/PCPP412
    }

    staging = {
      high_urgency = "3dd2208f64204130bc775e584abe392f" # https://twitchoncall.pagerduty.com/services/PV3D2ZP
      low_urgency  = "bb4a00f90a72405092e807073a2f0d90" # https://twitchoncall.pagerduty.com/services/PNZ67MD
    }
  }
}

resource "aws_sns_topic" "pd_high_urgency" {
  name         = "eventbus-alarms-high-urgency-${var.environment}"
  display_name = "eventbus-alarms-high-urgency-${var.environment}"
}

resource "aws_sns_topic_subscription" "high" {
  protocol               = "https"
  endpoint_auto_confirms = true
  endpoint               = "https://events.pagerduty.com/integration/${lookup(local.pagerduty_keys["${var.environment}"], "high_urgency")}/enqueue"
  topic_arn              = aws_sns_topic.pd_high_urgency.arn
}

resource "aws_sns_topic" "pd_low_urgency" {
  name         = "eventbus-alarms-low-urgency-${var.environment}"
  display_name = "eventbus-alarms-low-urgency-${var.environment}"
}

resource "aws_sns_topic_subscription" "low" {
  protocol               = "https"
  endpoint_auto_confirms = true
  endpoint               = "https://events.pagerduty.com/integration/${lookup(local.pagerduty_keys["${var.environment}"], "low_urgency")}/enqueue"
  topic_arn              = aws_sns_topic.pd_low_urgency.arn
}
