data "aws_iam_policy_document" "s2s_assume_role_document" {
  statement {
    # Allow s2s onboarded services to assume malachai roles in the s2s account
    actions   = ["sts:AssumeRole"]
    effect    = "Allow"
    resources = ["arn:aws:iam::180116294062:role/malachai/*"]
  }
}

resource "aws_iam_policy" "s2s_assume_role" {
  name   = "S2SAssumeRole"
  path   = "/"
  policy = data.aws_iam_policy_document.s2s_assume_role_document.json
}

