# Event Bus Schema

This repository is for hosting all the known schema conforming to the Event Bus protocol.

## Quick Start

0. Have docker installed and ready to use
1. Clone this repository
2. Change protobuf definitions as needed in `events`
3. Run `make fmt build lint`; correct errors as needed until successful

## `Makefile` Targets

* `make fmt` formats your `.proto` files according to the recommended syntax structure
* `make lint` runs Protobuf syntax checks (will fail if fmt is not run first)
* `make build`
   * Generates golang code and eventbus specific golang
   * Use this target to generate code after making a change to any protobuf definition in `events`
* `make test`
   * Protobuf backwards compatibility checks

## Submitting your Schema

When you create or update a schema, PR a branch to this repo. The Event Bus Drivers undergo a design review to make sure they [follow good practices in proto schema](https://git.xarth.tv/pages/eventbus/docs/schema/style/).

## Common Issues

### Jenkins complains about generated code

Make sure to re-run `make fmt build` after any change to the `.proto` and re-commit the generated code. The generated code contains a hashed representation of the proto file, so even a whitespace or comment change will cause the generated code to mismatch.

### Compatibility Check Fails

When running `make test` especially in the process of renaming changes due to PR comments, you may get an error that the compatiblity check has detected a rename that is 'breaking' even on events which had never existed before

This is because the compatibility check always checks your `.proto` against previous commits; if you made changes during your review that theoretically violated the compatibility, it will complain. You can solve this by re-squashing your PR down to a single commit and re-running `make test`.
