package util

import (
	descriptor "github.com/golang/protobuf/protoc-gen-go/descriptor"
)

type authFieldMetadata struct {
	goType    string
	zeroValue string
}

var authedFieldTypes = map[string]authFieldMetadata{
	".eventbus.authorization.String":  {"string", "\"\""},
	".eventbus.authorization.Float32": {"float32", "float32(0)"},
	".eventbus.authorization.Float64": {"float64", "float64(0)"},
	".eventbus.authorization.Int32":   {"int32", "int32(0)"},
	".eventbus.authorization.Int64":   {"int64", "int64(0)"},
}

func IsAuthorizedField(f *descriptor.FieldDescriptorProto) bool {
	t := f.GetTypeName()
	_, ok := authedFieldTypes[t]
	return ok
}

func AuthorizedFieldTypeToGoType(authFieldType string) string {
	return authedFieldTypes[authFieldType].goType
}

func AuthorizedFieldTypeToZeroValue(authFieldType string) string {
	ft, ok := authedFieldTypes[authFieldType]
	if !ok {
		return "nil"
	}

	return ft.zeroValue
}
