package util

import "strings"

func SnakeToUpperCamel(s string) string {
	var out string
	// First character is uppercase
	shouldUpper := true
	for _, c := range s {
		if c == '_' {
			shouldUpper = true
			continue
		}
		if shouldUpper {
			out += strings.ToUpper(string(c))
			shouldUpper = false
		} else {
			out += string(c)
		}
	}
	return out
}

func CamelToSnake(s string) string {
	var out string
	for _, c := range s {
		if c >= 'A' && c <= 'Z' {
			if len(out) > 0 {
				out += "_"

			}
			out += strings.ToLower(string(c))
		} else {
			out += string(c)
		}
	}
	return out
}
