package util

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestSnakeToUpperCamel(t *testing.T) {
	tests := []struct {
		snake      string
		upperCamel string
	}{
		{"word", "Word"},
		{"harry_potter", "HarryPotter"},
		{"jack_in_the_box", "JackInTheBox"},
		{"user_follow_user", "UserFollowUser"},
		{"a", "A"},
		{"a_b_c", "ABC"},
		{"a_b_c_def", "ABCDef"},
		{"", ""},
	}

	for _, test := range tests {
		transformedWord := SnakeToUpperCamel(test.snake)
		assert.Equalf(t, test.upperCamel, transformedWord, "expected upper camel case of %q to be %q, but was %q", test.snake, test.upperCamel, transformedWord)
	}
}

func TestCamelToSnake(t *testing.T) {
	tests := []struct {
		camel string
		snake string
	}{
		{"word", "word"},
		{"Abc", "abc"},
		{"UserFollowUser", "user_follow_user"},
		{"ABC", "a_b_c"},
		{"DEf", "d_ef"},
		{"jackInTheBox", "jack_in_the_box"},
		{"", ""},
	}

	for _, test := range tests {
		transformedWord := CamelToSnake(test.camel)
		assert.Equalf(t, test.snake, transformedWord, "expected snake case of %q to be %q, but was %q", test.camel, test.camel, transformedWord)
	}
}
