package util

import (
	"errors"
	"strings"
)

// ExpectedMessageName uses a path to deconstruct the expected
// event name and action. For instance, we expect foo_bar/create.go to make message FooBarCreate
func ExpectedMessageName(pathname string) (string, string, error) {
	pathParts := strings.Split(pathname, "/")
	if len(pathParts) < 2 {
		return "", "", errors.New("proto must be named <foo_bar>/<action>.proto")
	}
	lastDir := pathParts[len(pathParts)-2]
	filename := pathParts[len(pathParts)-1]

	if !strings.HasSuffix(filename, ".proto") || strings.Count(filename, ".") > 1 || strings.Count(filename, "_") > 0 {
		return "", "", errors.New("protofile must be named <action>.proto")
	}

	action := SnakeToUpperCamel(strings.Split(filename, ".")[0])

	return SnakeToUpperCamel(lastDir) + action, action, nil
}
