#!/usr/bin/env bash



# Iterate over every generated golang file and make sure there is no diff between it and the original
# Generated file in the checked in schema directory
for file in $(find ./tmp -type f -name "*.go") ; do
    relative_path=$(echo $file | sed 's#/tmp##')
    echo "Checking $relative_path"
    if ! diff "$file" "${relative_path}"; then
        echo "Error processing ${relative_path}"
        echo "Diff found between checked in file and freshly generated version. Did you forget to build and commit changes after modifying a protobuf definition?"
        echo "Try running 'make build' and try again."
        exit 1
    fi
done 

if [[ "$?" != "0" ]]; then
    echo "There was a problem generating code from the protobuf schemas. Review the errors above and try again."
    exit 1
fi

echo "All generated code appears up-to-date!"