package main

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestIsForbiddenFieldName(t *testing.T) {
	tests := []struct {
		name        string
		isForbidden bool
	}{
		{"channel_id", true},
		{"from_channel_id", true},
		{"to_channel_id", true},

		{"broadcaster_id", true},
		{"from_broadcaster_id", true},
		{"to_broadcaster_id", true},

		{"field", false},
		{"user_id", false},
		{"field2", false},
	}

	for _, test := range tests {
		forbidden := isForbiddenFieldName(test.name)
		if test.isForbidden {
			assert.Truef(t, forbidden, "expected field %q to be forbidden", test.name)
		} else {
			assert.Falsef(t, forbidden, "expected field %q to be allowed", test.name)
		}
	}
}

func TestIDSuffix(t *testing.T) {
	tests := []struct {
		name       string
		isIDSuffix bool
	}{
		{"id", true},
		{"field_id", true},
		{"user_id", true},
		{"user_other_field_id", true},

		{"channel", false},
		{"user", false},
		{"", false},
		{"other_crazy_field", false},
		{"lipid", false},
	}

	for _, test := range tests {
		idSuf := hasIDSuffix(test.name)
		if test.isIDSuffix {
			assert.Truef(t, idSuf, "expected field %q to be a string", test.name)
		} else {
			assert.Falsef(t, idSuf, "field %q is not expected to be an id suffixed field", test.name)
		}
	}
}
