// Code generated by protoc-gen-go. DO NOT EDIT.
// source: active_subscription/create.proto

package active_subscription

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Platform represents the platform on which the entitlement was created.
type Platform int32

const (
	Platform_PLATFORM_INVALID Platform = 0
	Platform_PLATFORM_ANDROID Platform = 1
	Platform_PLATFORM_IOS     Platform = 2
	Platform_PLATFORM_WEB     Platform = 3
)

var Platform_name = map[int32]string{
	0: "PLATFORM_INVALID",
	1: "PLATFORM_ANDROID",
	2: "PLATFORM_IOS",
	3: "PLATFORM_WEB",
}
var Platform_value = map[string]int32{
	"PLATFORM_INVALID": 0,
	"PLATFORM_ANDROID": 1,
	"PLATFORM_IOS":     2,
	"PLATFORM_WEB":     3,
}

func (x Platform) String() string {
	return proto.EnumName(Platform_name, int32(x))
}
func (Platform) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_b9b67fc130d8e94b, []int{0}
}

// A `SubscriptionType` identifies the method by which a subscription entitlement was created.
type SubscriptionType int32

const (
	SubscriptionType_SUBSCRIPTION_TYPE_INVALID SubscriptionType = 0
	SubscriptionType_SUBSCRIPTION_TYPE_GIFT    SubscriptionType = 1
	SubscriptionType_SUBSCRIPTION_TYPE_PAID    SubscriptionType = 2
	SubscriptionType_SUBSCRIPTION_TYPE_PRIME   SubscriptionType = 3
	// Signifies the user initiated the creation of this entitlement by linking their prime and twitch account.
	// A primelink subscription entitlement is always to the primelink product(s), and not to products owned by real Twitch channels.
	SubscriptionType_SUBSCRIPTION_TYPE_PRIMELINK SubscriptionType = 4
	// Can be a channel's own subscription to themself granted upon reaching Affiliate status, or a subscription created by Twitch internally.
	SubscriptionType_SUBSCRIPTION_TYPE_ADMIN           SubscriptionType = 5
	SubscriptionType_SUBSCRIPTION_TYPE_SUB_TOKEN       SubscriptionType = 6
	SubscriptionType_SUBSCRIPTION_TYPE_CODE_REDEMPTION SubscriptionType = 7
)

var SubscriptionType_name = map[int32]string{
	0: "SUBSCRIPTION_TYPE_INVALID",
	1: "SUBSCRIPTION_TYPE_GIFT",
	2: "SUBSCRIPTION_TYPE_PAID",
	3: "SUBSCRIPTION_TYPE_PRIME",
	4: "SUBSCRIPTION_TYPE_PRIMELINK",
	5: "SUBSCRIPTION_TYPE_ADMIN",
	6: "SUBSCRIPTION_TYPE_SUB_TOKEN",
	7: "SUBSCRIPTION_TYPE_CODE_REDEMPTION",
}
var SubscriptionType_value = map[string]int32{
	"SUBSCRIPTION_TYPE_INVALID":         0,
	"SUBSCRIPTION_TYPE_GIFT":            1,
	"SUBSCRIPTION_TYPE_PAID":            2,
	"SUBSCRIPTION_TYPE_PRIME":           3,
	"SUBSCRIPTION_TYPE_PRIMELINK":       4,
	"SUBSCRIPTION_TYPE_ADMIN":           5,
	"SUBSCRIPTION_TYPE_SUB_TOKEN":       6,
	"SUBSCRIPTION_TYPE_CODE_REDEMPTION": 7,
}

func (x SubscriptionType) String() string {
	return proto.EnumName(SubscriptionType_name, int32(x))
}
func (SubscriptionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_b9b67fc130d8e94b, []int{1}
}

// SubscriptionTier represents the tier of the subscription product.
type SubscriptionTier int32

const (
	SubscriptionTier_SUBSCRIPTION_TIER_INVALID SubscriptionTier = 0
	SubscriptionTier_SUBSCRIPTION_TIER_ONE     SubscriptionTier = 1
	SubscriptionTier_SUBSCRIPTION_TIER_TWO     SubscriptionTier = 2
	SubscriptionTier_SUBSCRIPTION_TIER_THREE   SubscriptionTier = 3
	SubscriptionTier_SUBSCRIPTION_TIER_CUSTOM  SubscriptionTier = 4
)

var SubscriptionTier_name = map[int32]string{
	0: "SUBSCRIPTION_TIER_INVALID",
	1: "SUBSCRIPTION_TIER_ONE",
	2: "SUBSCRIPTION_TIER_TWO",
	3: "SUBSCRIPTION_TIER_THREE",
	4: "SUBSCRIPTION_TIER_CUSTOM",
}
var SubscriptionTier_value = map[string]int32{
	"SUBSCRIPTION_TIER_INVALID": 0,
	"SUBSCRIPTION_TIER_ONE":     1,
	"SUBSCRIPTION_TIER_TWO":     2,
	"SUBSCRIPTION_TIER_THREE":   3,
	"SUBSCRIPTION_TIER_CUSTOM":  4,
}

func (x SubscriptionTier) String() string {
	return proto.EnumName(SubscriptionTier_name, int32(x))
}
func (SubscriptionTier) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_b9b67fc130d8e94b, []int{2}
}

// ActiveSubscriptionCreate is a downstream event of EntitlementSubscriptionCreate and EntitlementSubscriptionUpdate.
// It is scheduled to trigger when a user's entitled subscription becomes active, as defined by the starts_at value.
// A subscription entitlement can be canceled before it starts, meaning that the subscription entitlement will never
// become active, thus not emitting an ActiveSubscriptionCreate event.
// Despite the Create verb, this event does not represent the creation or mutation of any data, just that a previously
// created subscription entitlement has become active. EntitlementSubscriptionCreate represents the creation event, and
// is triggered when a user subscribes or commits to subscribe.
type ActiveSubscriptionCreate struct {
	// Entitlement ID
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Twitch User ID of the user who owns this entitlement.
	OwnerUserId string `protobuf:"bytes,2,opt,name=owner_user_id,json=ownerUserId,proto3" json:"owner_user_id,omitempty"`
	// The Platform from which the entitlement came from.
	Platform Platform `protobuf:"varint,3,opt,name=platform,proto3,enum=active_subscription.Platform" json:"platform,omitempty"`
	// ID for the product the user is entitled to.
	ProductId string `protobuf:"bytes,4,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
	// Twitch User ID of the broadcaster who owns the product.
	ProductOwnerUserId string `protobuf:"bytes,5,opt,name=product_owner_user_id,json=productOwnerUserId,proto3" json:"product_owner_user_id,omitempty"`
	// Identifier for the origin object that caused this entitlement.
	OriginId string `protobuf:"bytes,6,opt,name=origin_id,json=originId,proto3" json:"origin_id,omitempty"`
	// When the entitlement starts.
	StartsAt *timestamp.Timestamp `protobuf:"bytes,7,opt,name=starts_at,json=startsAt,proto3" json:"starts_at,omitempty"`
	// When the entitlement expires.
	EndsAt *timestamp.Timestamp `protobuf:"bytes,8,opt,name=ends_at,json=endsAt,proto3" json:"ends_at,omitempty"`
	// The subscription type of this entitlement.
	Type SubscriptionType `protobuf:"varint,9,opt,name=type,proto3,enum=active_subscription.SubscriptionType" json:"type,omitempty"`
	// The subscription tier represents the tier of the product associated with this subscription.
	Tier                 SubscriptionTier `protobuf:"varint,10,opt,name=tier,proto3,enum=active_subscription.SubscriptionTier" json:"tier,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ActiveSubscriptionCreate) Reset()         { *m = ActiveSubscriptionCreate{} }
func (m *ActiveSubscriptionCreate) String() string { return proto.CompactTextString(m) }
func (*ActiveSubscriptionCreate) ProtoMessage()    {}
func (*ActiveSubscriptionCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_b9b67fc130d8e94b, []int{0}
}
func (m *ActiveSubscriptionCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActiveSubscriptionCreate.Unmarshal(m, b)
}
func (m *ActiveSubscriptionCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActiveSubscriptionCreate.Marshal(b, m, deterministic)
}
func (dst *ActiveSubscriptionCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActiveSubscriptionCreate.Merge(dst, src)
}
func (m *ActiveSubscriptionCreate) XXX_Size() int {
	return xxx_messageInfo_ActiveSubscriptionCreate.Size(m)
}
func (m *ActiveSubscriptionCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_ActiveSubscriptionCreate.DiscardUnknown(m)
}

var xxx_messageInfo_ActiveSubscriptionCreate proto.InternalMessageInfo

func (m *ActiveSubscriptionCreate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ActiveSubscriptionCreate) GetOwnerUserId() string {
	if m != nil {
		return m.OwnerUserId
	}
	return ""
}

func (m *ActiveSubscriptionCreate) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_INVALID
}

func (m *ActiveSubscriptionCreate) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *ActiveSubscriptionCreate) GetProductOwnerUserId() string {
	if m != nil {
		return m.ProductOwnerUserId
	}
	return ""
}

func (m *ActiveSubscriptionCreate) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *ActiveSubscriptionCreate) GetStartsAt() *timestamp.Timestamp {
	if m != nil {
		return m.StartsAt
	}
	return nil
}

func (m *ActiveSubscriptionCreate) GetEndsAt() *timestamp.Timestamp {
	if m != nil {
		return m.EndsAt
	}
	return nil
}

func (m *ActiveSubscriptionCreate) GetType() SubscriptionType {
	if m != nil {
		return m.Type
	}
	return SubscriptionType_SUBSCRIPTION_TYPE_INVALID
}

func (m *ActiveSubscriptionCreate) GetTier() SubscriptionTier {
	if m != nil {
		return m.Tier
	}
	return SubscriptionTier_SUBSCRIPTION_TIER_INVALID
}

func init() {
	proto.RegisterType((*ActiveSubscriptionCreate)(nil), "active_subscription.ActiveSubscriptionCreate")
	proto.RegisterEnum("active_subscription.Platform", Platform_name, Platform_value)
	proto.RegisterEnum("active_subscription.SubscriptionType", SubscriptionType_name, SubscriptionType_value)
	proto.RegisterEnum("active_subscription.SubscriptionTier", SubscriptionTier_name, SubscriptionTier_value)
}

func init() {
	proto.RegisterFile("active_subscription/create.proto", fileDescriptor_create_b9b67fc130d8e94b)
}

var fileDescriptor_create_b9b67fc130d8e94b = []byte{
	// 559 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x94, 0xd1, 0x4e, 0xdb, 0x3e,
	0x18, 0xc5, 0xff, 0x49, 0x4b, 0x69, 0x3e, 0xfe, 0x20, 0xcb, 0x83, 0x2d, 0x94, 0x21, 0x3a, 0x24,
	0x24, 0x84, 0xb4, 0x54, 0x83, 0x8b, 0x89, 0xdd, 0xa5, 0x4d, 0xd8, 0x2c, 0xda, 0xa4, 0x72, 0xd2,
	0xa1, 0x71, 0x13, 0xa5, 0x8d, 0xa9, 0x2c, 0xd1, 0x26, 0x72, 0x5c, 0x26, 0xde, 0x61, 0x4f, 0xb0,
	0xcb, 0xbd, 0xc3, 0x9e, 0x6a, 0x2f, 0x31, 0xd5, 0x6d, 0xb7, 0x96, 0x66, 0xda, 0x2e, 0x73, 0xce,
	0xef, 0x7c, 0xfe, 0x72, 0x12, 0x19, 0xea, 0xf1, 0x40, 0xf2, 0x07, 0x16, 0xe5, 0x93, 0x7e, 0x3e,
	0x10, 0x3c, 0x93, 0x3c, 0x1d, 0x37, 0x06, 0x82, 0xc5, 0x92, 0x59, 0x99, 0x48, 0x65, 0x8a, 0x9f,
	0x15, 0x10, 0xb5, 0x5d, 0xf6, 0xc0, 0xc6, 0xb2, 0x3f, 0xc9, 0x1b, 0xe9, 0xe7, 0x31, 0x13, 0x33,
	0xb4, 0x76, 0x34, 0x4c, 0xd3, 0xe1, 0x3d, 0x6b, 0xa8, 0xa7, 0xfe, 0xe4, 0xae, 0x21, 0xf9, 0x88,
	0xe5, 0x32, 0x1e, 0x65, 0x33, 0xe0, 0xf8, 0x47, 0x09, 0x4c, 0x5b, 0x8d, 0x0b, 0x96, 0xa6, 0xb5,
	0xd4, 0x71, 0x78, 0x07, 0x74, 0x9e, 0x98, 0x5a, 0x5d, 0x3b, 0x35, 0xa8, 0xce, 0x13, 0x7c, 0x0c,
	0xdb, 0x6a, 0x78, 0x34, 0xc9, 0x99, 0x88, 0x78, 0x62, 0xea, 0xca, 0xda, 0x52, 0x62, 0x2f, 0x67,
	0x82, 0x24, 0xf8, 0x12, 0xaa, 0xd9, 0x7d, 0x2c, 0xef, 0x52, 0x31, 0x32, 0x4b, 0x75, 0xed, 0x74,
	0xe7, 0xfc, 0xd0, 0x2a, 0xd8, 0xd7, 0xea, 0xce, 0x21, 0xfa, 0x0b, 0xc7, 0x87, 0x00, 0x99, 0x48,
	0x93, 0xc9, 0x40, 0x4e, 0x67, 0x97, 0xd5, 0x6c, 0x63, 0xae, 0x90, 0x04, 0xbf, 0x81, 0xbd, 0x85,
	0xbd, 0xba, 0xc5, 0x86, 0x22, 0xf1, 0xdc, 0xf4, 0x97, 0x96, 0x39, 0x00, 0x23, 0x15, 0x7c, 0xc8,
	0xc7, 0x53, 0xac, 0xa2, 0xb0, 0xea, 0x4c, 0x20, 0x09, 0x7e, 0x0b, 0x46, 0x2e, 0x63, 0x21, 0xf3,
	0x28, 0x96, 0xe6, 0x66, 0x5d, 0x3b, 0xdd, 0x3a, 0xaf, 0x59, 0xb3, 0xbe, 0xac, 0x45, 0x5f, 0x56,
	0xb8, 0xe8, 0x8b, 0x56, 0x67, 0xb0, 0x2d, 0xf1, 0x05, 0x6c, 0xb2, 0x71, 0xa2, 0x62, 0xd5, 0xbf,
	0xc6, 0x2a, 0x53, 0xd4, 0x96, 0xf8, 0x12, 0xca, 0xf2, 0x31, 0x63, 0xa6, 0xa1, 0x3a, 0x39, 0x29,
	0xec, 0x64, 0xf9, 0x13, 0x84, 0x8f, 0x19, 0xa3, 0x2a, 0xa2, 0xa2, 0x9c, 0x09, 0x13, 0xfe, 0x35,
	0xca, 0x99, 0xa0, 0x2a, 0xf2, 0x6e, 0xfb, 0xeb, 0x77, 0xd3, 0x90, 0x2c, 0x1e, 0xbd, 0x9e, 0xd2,
	0x67, 0xb7, 0x50, 0x5d, 0xf4, 0x8e, 0x77, 0x01, 0x75, 0xdb, 0x76, 0x78, 0xe5, 0xd3, 0x4e, 0x44,
	0xbc, 0x8f, 0x76, 0x9b, 0x38, 0xe8, 0xbf, 0x15, 0xd5, 0xf6, 0x1c, 0xea, 0x13, 0x07, 0x69, 0x18,
	0xc1, 0xff, 0xbf, 0x59, 0x3f, 0x40, 0xfa, 0x8a, 0x72, 0xe3, 0x36, 0x51, 0xe9, 0xec, 0x8b, 0x0e,
	0xe8, 0xe9, 0x0b, 0xe0, 0x43, 0xd8, 0x0f, 0x7a, 0xcd, 0xa0, 0x45, 0x49, 0x37, 0x24, 0xbe, 0x17,
	0x85, 0x9f, 0xba, 0xee, 0xd2, 0x69, 0x35, 0x78, 0xbe, 0x6e, 0xbf, 0x27, 0x57, 0x21, 0xd2, 0x8a,
	0xbd, 0xae, 0x4d, 0x1c, 0xa4, 0xe3, 0x03, 0x78, 0x51, 0xe0, 0x51, 0xd2, 0x71, 0x51, 0x09, 0x1f,
	0xc1, 0xc1, 0x1f, 0xcc, 0x36, 0xf1, 0xae, 0x51, 0xb9, 0x38, 0x6d, 0x3b, 0x1d, 0xe2, 0xa1, 0x8d,
	0xe2, 0x74, 0xd0, 0x6b, 0x46, 0xa1, 0x7f, 0xed, 0x7a, 0xa8, 0x82, 0x4f, 0xe0, 0xd5, 0x3a, 0xd0,
	0xf2, 0x1d, 0x37, 0xa2, 0xae, 0xe3, 0x76, 0x94, 0x88, 0x36, 0xcf, 0xbe, 0x69, 0x4f, 0xea, 0xe0,
	0x4c, 0xac, 0xd7, 0x41, 0x5c, 0xba, 0x54, 0xc7, 0x3e, 0xec, 0xad, 0xdb, 0xbe, 0xe7, 0x22, 0xad,
	0xd8, 0x0a, 0x6f, 0xfc, 0xa2, 0x32, 0x94, 0xf5, 0x81, 0xba, 0xd3, 0x32, 0x5e, 0x82, 0xb9, 0x6e,
	0xb6, 0x7a, 0x41, 0xe8, 0x77, 0x50, 0xb9, 0xb9, 0x77, 0x5b, 0x74, 0x97, 0xf4, 0x2b, 0xea, 0x3f,
	0xbe, 0xf8, 0x19, 0x00, 0x00, 0xff, 0xff, 0x35, 0x4c, 0xb9, 0x61, 0x8b, 0x04, 0x00, 0x00,
}
