// Code generated by protoc-gen-go. DO NOT EDIT.
// source: active_subscription/delete.proto

package active_subscription

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// ActiveSubscriptionDelete is a downstream of EntitlementSubscriptionCreate and EntitlementSubscriptionUpdate that is
// scheduled to trigger when an *active* subscription entitlement ends.
// A subscription entitlement is considered active when `starts_at <= time.Now() < ends_at`. Similarly, an active
// subscription ends (or "expires") when `starts_at < ends_at <= time.Now()`. This means that a future subscription
// entitlement (`time.Now() < starts_at`) that is canceled before it starts will not emit a ActiveSubscriptionDelete
// event since it was never active.
type ActiveSubscriptionDelete struct {
	// Entitlement ID
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Twitch User ID of the user who owns this entitlement.
	OwnerUserId string `protobuf:"bytes,2,opt,name=owner_user_id,json=ownerUserId,proto3" json:"owner_user_id,omitempty"`
	// The Platform from which the entitlement came from.
	Platform Platform `protobuf:"varint,3,opt,name=platform,proto3,enum=active_subscription.Platform" json:"platform,omitempty"`
	// ID for the product the user is entitled to.
	ProductId string `protobuf:"bytes,4,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
	// Twitch User ID of the broadcaster who owns the product.
	ProductOwnerUserId string `protobuf:"bytes,5,opt,name=product_owner_user_id,json=productOwnerUserId,proto3" json:"product_owner_user_id,omitempty"`
	// Identifier for the origin object that caused this entitlement.
	OriginId string `protobuf:"bytes,6,opt,name=origin_id,json=originId,proto3" json:"origin_id,omitempty"`
	// When the entitlement starts.
	StartsAt *timestamp.Timestamp `protobuf:"bytes,7,opt,name=starts_at,json=startsAt,proto3" json:"starts_at,omitempty"`
	// When the entitlement expires.
	EndsAt *timestamp.Timestamp `protobuf:"bytes,8,opt,name=ends_at,json=endsAt,proto3" json:"ends_at,omitempty"`
	// The subscription type of this entitlement.
	Type SubscriptionType `protobuf:"varint,9,opt,name=type,proto3,enum=active_subscription.SubscriptionType" json:"type,omitempty"`
	// The subscription tier represents the tier of the product associated with this subscription.
	Tier                 SubscriptionTier `protobuf:"varint,10,opt,name=tier,proto3,enum=active_subscription.SubscriptionTier" json:"tier,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ActiveSubscriptionDelete) Reset()         { *m = ActiveSubscriptionDelete{} }
func (m *ActiveSubscriptionDelete) String() string { return proto.CompactTextString(m) }
func (*ActiveSubscriptionDelete) ProtoMessage()    {}
func (*ActiveSubscriptionDelete) Descriptor() ([]byte, []int) {
	return fileDescriptor_delete_1261a738d6f647d9, []int{0}
}
func (m *ActiveSubscriptionDelete) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActiveSubscriptionDelete.Unmarshal(m, b)
}
func (m *ActiveSubscriptionDelete) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActiveSubscriptionDelete.Marshal(b, m, deterministic)
}
func (dst *ActiveSubscriptionDelete) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActiveSubscriptionDelete.Merge(dst, src)
}
func (m *ActiveSubscriptionDelete) XXX_Size() int {
	return xxx_messageInfo_ActiveSubscriptionDelete.Size(m)
}
func (m *ActiveSubscriptionDelete) XXX_DiscardUnknown() {
	xxx_messageInfo_ActiveSubscriptionDelete.DiscardUnknown(m)
}

var xxx_messageInfo_ActiveSubscriptionDelete proto.InternalMessageInfo

func (m *ActiveSubscriptionDelete) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ActiveSubscriptionDelete) GetOwnerUserId() string {
	if m != nil {
		return m.OwnerUserId
	}
	return ""
}

func (m *ActiveSubscriptionDelete) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_INVALID
}

func (m *ActiveSubscriptionDelete) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *ActiveSubscriptionDelete) GetProductOwnerUserId() string {
	if m != nil {
		return m.ProductOwnerUserId
	}
	return ""
}

func (m *ActiveSubscriptionDelete) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *ActiveSubscriptionDelete) GetStartsAt() *timestamp.Timestamp {
	if m != nil {
		return m.StartsAt
	}
	return nil
}

func (m *ActiveSubscriptionDelete) GetEndsAt() *timestamp.Timestamp {
	if m != nil {
		return m.EndsAt
	}
	return nil
}

func (m *ActiveSubscriptionDelete) GetType() SubscriptionType {
	if m != nil {
		return m.Type
	}
	return SubscriptionType_SUBSCRIPTION_TYPE_INVALID
}

func (m *ActiveSubscriptionDelete) GetTier() SubscriptionTier {
	if m != nil {
		return m.Tier
	}
	return SubscriptionTier_SUBSCRIPTION_TIER_INVALID
}

func init() {
	proto.RegisterType((*ActiveSubscriptionDelete)(nil), "active_subscription.ActiveSubscriptionDelete")
}

func init() {
	proto.RegisterFile("active_subscription/delete.proto", fileDescriptor_delete_1261a738d6f647d9)
}

var fileDescriptor_delete_1261a738d6f647d9 = []byte{
	// 359 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0x41, 0x6b, 0xe2, 0x40,
	0x1c, 0xc5, 0x89, 0xba, 0x9a, 0x8c, 0xe8, 0x61, 0x76, 0x85, 0xc1, 0x45, 0x36, 0x08, 0x0b, 0x5e,
	0x36, 0x61, 0xf5, 0x50, 0xec, 0xcd, 0xd2, 0x8b, 0xa7, 0x96, 0xd4, 0x5e, 0x7a, 0x09, 0x49, 0xe6,
	0xaf, 0x0c, 0x98, 0x4c, 0x98, 0xf9, 0xc7, 0xe2, 0x57, 0xe9, 0xf7, 0xe8, 0xa7, 0xea, 0x97, 0x28,
	0x99, 0x24, 0xc5, 0x42, 0xa0, 0x3d, 0xe6, 0xfd, 0x7f, 0xef, 0xf1, 0x78, 0x19, 0xe2, 0x46, 0x09,
	0x8a, 0x13, 0x84, 0xba, 0x88, 0x75, 0xa2, 0x44, 0x8e, 0x42, 0x66, 0x3e, 0x87, 0x23, 0x20, 0x78,
	0xb9, 0x92, 0x28, 0xe9, 0xcf, 0x16, 0x62, 0xda, 0x6a, 0x4b, 0x14, 0x44, 0x8d, 0x6d, 0xfa, 0x0b,
	0x4e, 0x90, 0x61, 0x5c, 0x68, 0x5f, 0x3e, 0x67, 0xa0, 0x6a, 0xf5, 0xcf, 0x41, 0xca, 0xc3, 0x11,
	0x7c, 0xf3, 0x15, 0x17, 0x7b, 0x1f, 0x45, 0x0a, 0x1a, 0xa3, 0x34, 0xaf, 0x80, 0xf9, 0x5b, 0x97,
	0xb0, 0x8d, 0xc9, 0x7e, 0xb8, 0x88, 0xbe, 0x35, 0x85, 0xe8, 0x98, 0x74, 0x04, 0x67, 0x96, 0x6b,
	0x2d, 0x9c, 0xa0, 0x23, 0x38, 0x9d, 0x93, 0x91, 0x09, 0x0f, 0x0b, 0x0d, 0x2a, 0x14, 0x9c, 0x75,
	0xcc, 0x69, 0x68, 0xc4, 0x47, 0x0d, 0x6a, 0xcb, 0xe9, 0x9a, 0xd8, 0xf9, 0x31, 0xc2, 0xbd, 0x54,
	0x29, 0xeb, 0xba, 0xd6, 0x62, 0xbc, 0x9c, 0x79, 0x2d, 0xe5, 0xbd, 0xfb, 0x1a, 0x0a, 0x3e, 0x70,
	0x3a, 0x23, 0x24, 0x57, 0x92, 0x17, 0x09, 0x96, 0xd9, 0x3d, 0x93, 0xed, 0xd4, 0xca, 0x96, 0xd3,
	0xff, 0x64, 0xd2, 0x9c, 0x3f, 0xb7, 0xf8, 0x61, 0x48, 0x5a, 0x1f, 0xef, 0x2e, 0xca, 0xfc, 0x26,
	0x8e, 0x54, 0xe2, 0x20, 0xb2, 0x12, 0xeb, 0x1b, 0xcc, 0xae, 0x84, 0x2d, 0xa7, 0x57, 0xc4, 0xd1,
	0x18, 0x29, 0xd4, 0x61, 0x84, 0x6c, 0xe0, 0x5a, 0x8b, 0xe1, 0x72, 0xea, 0x55, 0x7b, 0x79, 0xcd,
	0x5e, 0xde, 0xae, 0xd9, 0x2b, 0xb0, 0x2b, 0x78, 0x83, 0x74, 0x45, 0x06, 0x90, 0x71, 0x63, 0xb3,
	0xbf, 0xb4, 0xf5, 0x4b, 0x74, 0x83, 0x74, 0x4d, 0x7a, 0x78, 0xce, 0x81, 0x39, 0x66, 0x93, 0xbf,
	0xad, 0x9b, 0x5c, 0xfe, 0x82, 0xdd, 0x39, 0x87, 0xc0, 0x58, 0x8c, 0x55, 0x80, 0x62, 0xe4, 0xbb,
	0x56, 0x01, 0x2a, 0x30, 0x96, 0xeb, 0xd1, 0xcb, 0x2b, 0x73, 0x10, 0xa2, 0xf4, 0x5f, 0x49, 0xdf,
	0x4c, 0x9e, 0xda, 0x5e, 0x57, 0xdc, 0x37, 0xbd, 0x57, 0xef, 0x01, 0x00, 0x00, 0xff, 0xff, 0x99,
	0x05, 0xa2, 0x97, 0x9d, 0x02, 0x00, 0x00,
}
