// Code generated by protoc-gen-go. DO NOT EDIT.
// source: boost_order/create.proto

package boost_order

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// OrderType are the different types a Boost Order can be ordered from.
type OrderType int32

const (
	OrderType_ORDER_TYPE_INVALID OrderType = 0
	OrderType_ORDER_TYPE_EARNED  OrderType = 1
	OrderType_ORDER_TYPE_PAID    OrderType = 2
)

var OrderType_name = map[int32]string{
	0: "ORDER_TYPE_INVALID",
	1: "ORDER_TYPE_EARNED",
	2: "ORDER_TYPE_PAID",
}
var OrderType_value = map[string]int32{
	"ORDER_TYPE_INVALID": 0,
	"ORDER_TYPE_EARNED":  1,
	"ORDER_TYPE_PAID":    2,
}

func (x OrderType) String() string {
	return proto.EnumName(OrderType_name, int32(x))
}
func (OrderType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_19e579d6913fda6a, []int{0}
}

// OrderState is the different type of states an order can be in.
type OrderState int32

const (
	OrderState_ORDER_STATE_INVALID    OrderState = 0
	OrderState_ORDER_STATE_DELIVERING OrderState = 1
	OrderState_ORDER_STATE_FULFILLED  OrderState = 2
	OrderState_ORDER_STATE_PENDING    OrderState = 3
	OrderState_ORDER_STATE_CANCELLED  OrderState = 4
)

var OrderState_name = map[int32]string{
	0: "ORDER_STATE_INVALID",
	1: "ORDER_STATE_DELIVERING",
	2: "ORDER_STATE_FULFILLED",
	3: "ORDER_STATE_PENDING",
	4: "ORDER_STATE_CANCELLED",
}
var OrderState_value = map[string]int32{
	"ORDER_STATE_INVALID":    0,
	"ORDER_STATE_DELIVERING": 1,
	"ORDER_STATE_FULFILLED":  2,
	"ORDER_STATE_PENDING":    3,
	"ORDER_STATE_CANCELLED":  4,
}

func (x OrderState) String() string {
	return proto.EnumName(OrderState_name, int32(x))
}
func (OrderState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_19e579d6913fda6a, []int{1}
}

// BoostOrderCreate triggers when a Boost Order is created.
type BoostOrderCreate struct {
	// The unique identifier of the Boost Order
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The type of Boost Order (whether paid or earned)
	Type OrderType `protobuf:"varint,2,opt,name=type,proto3,enum=boost_order.OrderType" json:"type,omitempty"`
	// The state of the Boost Order
	State OrderState `protobuf:"varint,3,opt,name=state,proto3,enum=boost_order.OrderState" json:"state,omitempty"`
	// The current progress of the Boost Order being fulfilled
	GoalProgress int64 `protobuf:"varint,4,opt,name=goal_progress,json=goalProgress,proto3" json:"goal_progress,omitempty"`
	// The the total progress required for a Boost Order to be fulfilled
	GoalTarget int64 `protobuf:"varint,5,opt,name=goal_target,json=goalTarget,proto3" json:"goal_target,omitempty"`
	// Twitch User ID of who Boost Order was redeemed for
	BoostOwnerId string `protobuf:"bytes,6,opt,name=boost_owner_id,json=boostOwnerId,proto3" json:"boost_owner_id,omitempty"`
	// Twitch User ID Identifier of who made the Boost Order (only applicable for paid)
	PurchaserId string `protobuf:"bytes,7,opt,name=purchaser_id,json=purchaserId,proto3" json:"purchaser_id,omitempty"`
	// The total quantity of Boosts within the Boost Order
	Quantity int64 `protobuf:"varint,8,opt,name=quantity,proto3" json:"quantity,omitempty"`
	// The time at which the Boost Order was created
	OpenedAt             *timestamp.Timestamp `protobuf:"bytes,9,opt,name=opened_at,json=openedAt,proto3" json:"opened_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *BoostOrderCreate) Reset()         { *m = BoostOrderCreate{} }
func (m *BoostOrderCreate) String() string { return proto.CompactTextString(m) }
func (*BoostOrderCreate) ProtoMessage()    {}
func (*BoostOrderCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_19e579d6913fda6a, []int{0}
}
func (m *BoostOrderCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoostOrderCreate.Unmarshal(m, b)
}
func (m *BoostOrderCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoostOrderCreate.Marshal(b, m, deterministic)
}
func (dst *BoostOrderCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoostOrderCreate.Merge(dst, src)
}
func (m *BoostOrderCreate) XXX_Size() int {
	return xxx_messageInfo_BoostOrderCreate.Size(m)
}
func (m *BoostOrderCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_BoostOrderCreate.DiscardUnknown(m)
}

var xxx_messageInfo_BoostOrderCreate proto.InternalMessageInfo

func (m *BoostOrderCreate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *BoostOrderCreate) GetType() OrderType {
	if m != nil {
		return m.Type
	}
	return OrderType_ORDER_TYPE_INVALID
}

func (m *BoostOrderCreate) GetState() OrderState {
	if m != nil {
		return m.State
	}
	return OrderState_ORDER_STATE_INVALID
}

func (m *BoostOrderCreate) GetGoalProgress() int64 {
	if m != nil {
		return m.GoalProgress
	}
	return 0
}

func (m *BoostOrderCreate) GetGoalTarget() int64 {
	if m != nil {
		return m.GoalTarget
	}
	return 0
}

func (m *BoostOrderCreate) GetBoostOwnerId() string {
	if m != nil {
		return m.BoostOwnerId
	}
	return ""
}

func (m *BoostOrderCreate) GetPurchaserId() string {
	if m != nil {
		return m.PurchaserId
	}
	return ""
}

func (m *BoostOrderCreate) GetQuantity() int64 {
	if m != nil {
		return m.Quantity
	}
	return 0
}

func (m *BoostOrderCreate) GetOpenedAt() *timestamp.Timestamp {
	if m != nil {
		return m.OpenedAt
	}
	return nil
}

func init() {
	proto.RegisterType((*BoostOrderCreate)(nil), "boost_order.BoostOrderCreate")
	proto.RegisterEnum("boost_order.OrderType", OrderType_name, OrderType_value)
	proto.RegisterEnum("boost_order.OrderState", OrderState_name, OrderState_value)
}

func init() { proto.RegisterFile("boost_order/create.proto", fileDescriptor_create_19e579d6913fda6a) }

var fileDescriptor_create_19e579d6913fda6a = []byte{
	// 455 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x92, 0xdf, 0x6e, 0xd3, 0x30,
	0x14, 0xc6, 0x49, 0xda, 0x8d, 0xf6, 0xb4, 0x2b, 0xc1, 0x63, 0x9d, 0xc9, 0xcd, 0xca, 0x9f, 0x8b,
	0xaa, 0xd2, 0x52, 0x69, 0x5c, 0x20, 0x71, 0x97, 0x35, 0x1e, 0x8a, 0x14, 0xa5, 0x95, 0x17, 0x26,
	0xc1, 0x4d, 0xe4, 0x2e, 0x26, 0x44, 0x5a, 0xeb, 0xe0, 0xb8, 0xa0, 0xbe, 0x05, 0xd7, 0xbc, 0x07,
	0xcf, 0xc5, 0x2b, 0xa0, 0x38, 0x5b, 0xb1, 0xba, 0x4b, 0xff, 0xce, 0xef, 0x7c, 0xa7, 0xfd, 0x14,
	0xc0, 0x4b, 0x21, 0x2a, 0x95, 0x0a, 0x99, 0x71, 0x39, 0xbd, 0x95, 0x9c, 0x29, 0xee, 0x95, 0x52,
	0x28, 0x81, 0x7a, 0xc6, 0xc4, 0x7d, 0xc1, 0x7f, 0xf0, 0xb5, 0x5a, 0x6e, 0xaa, 0xa9, 0xf8, 0xb9,
	0xe6, 0xb2, 0x51, 0xdc, 0xb3, 0x5c, 0x88, 0xfc, 0x8e, 0x4f, 0xf5, 0x6b, 0xb9, 0xf9, 0x3a, 0x55,
	0xc5, 0x8a, 0x57, 0x8a, 0xad, 0xca, 0x46, 0x78, 0xfd, 0xd7, 0x06, 0xe7, 0xb2, 0x8e, 0x99, 0xd7,
	0x29, 0x33, 0x1d, 0x8f, 0x06, 0x60, 0x17, 0x19, 0xb6, 0x46, 0xd6, 0xb8, 0x4b, 0xed, 0x22, 0x43,
	0x13, 0x68, 0xab, 0x6d, 0xc9, 0xb1, 0x3d, 0xb2, 0xc6, 0x83, 0x8b, 0xa1, 0x67, 0xdc, 0xf5, 0xf4,
	0x5e, 0xb2, 0x2d, 0x39, 0xd5, 0x0e, 0x3a, 0x87, 0x83, 0x4a, 0x31, 0xc5, 0x71, 0x4b, 0xcb, 0xa7,
	0x8f, 0xe5, 0xeb, 0x7a, 0x4c, 0x1b, 0x0b, 0xbd, 0x81, 0xa3, 0x5c, 0xb0, 0xbb, 0xb4, 0x94, 0x22,
	0x97, 0xbc, 0xaa, 0x70, 0x7b, 0x64, 0x8d, 0x5b, 0xb4, 0x5f, 0xc3, 0xc5, 0x3d, 0x43, 0x67, 0xd0,
	0xd3, 0x92, 0x62, 0x32, 0xe7, 0x0a, 0x1f, 0x68, 0x05, 0x6a, 0x94, 0x68, 0x82, 0xde, 0xc2, 0xe0,
	0xfe, 0x4c, 0xfd, 0xdf, 0xd3, 0x22, 0xc3, 0x87, 0xfa, 0xc7, 0xf7, 0x35, 0x9d, 0xd7, 0x30, 0xcc,
	0xd0, 0x2b, 0xe8, 0x97, 0x1b, 0x79, 0xfb, 0x8d, 0x55, 0x8d, 0xf3, 0x54, 0x3b, 0xbd, 0x1d, 0x0b,
	0x33, 0xe4, 0x42, 0xe7, 0xfb, 0x86, 0xad, 0x55, 0xa1, 0xb6, 0xb8, 0xa3, 0xcf, 0xec, 0xde, 0xe8,
	0x3d, 0x74, 0x45, 0xc9, 0xd7, 0x3c, 0x4b, 0x99, 0xc2, 0xdd, 0x91, 0x35, 0xee, 0x5d, 0xb8, 0x5e,
	0xd3, 0xaf, 0xf7, 0xd0, 0xaf, 0x97, 0x3c, 0xf4, 0x4b, 0x3b, 0x8d, 0xec, 0xab, 0x0f, 0xfd, 0xdf,
	0x7f, 0x70, 0x47, 0x71, 0xb6, 0x3a, 0x67, 0x59, 0x35, 0x99, 0x43, 0x77, 0xd7, 0x19, 0x1a, 0x02,
	0x9a, 0xd3, 0x80, 0xd0, 0x34, 0xf9, 0xbc, 0x20, 0x69, 0x18, 0xdf, 0xf8, 0x51, 0x18, 0x38, 0x4f,
	0xd0, 0x09, 0x3c, 0x37, 0x38, 0xf1, 0x69, 0x4c, 0x02, 0xc7, 0x42, 0xc7, 0xf0, 0xcc, 0xc0, 0x0b,
	0x3f, 0x0c, 0x1c, 0x7b, 0xf2, 0xcb, 0x02, 0xf8, 0x5f, 0x2c, 0x3a, 0x85, 0xe3, 0xc6, 0xb9, 0x4e,
	0xfc, 0xc4, 0xcc, 0x74, 0x61, 0x68, 0x0e, 0x02, 0x12, 0x85, 0x37, 0x84, 0x86, 0xf1, 0x47, 0xc7,
	0x42, 0x2f, 0xe1, 0xc4, 0x9c, 0x5d, 0x7d, 0x8a, 0xae, 0xc2, 0x28, 0x22, 0x81, 0x63, 0xef, 0xe7,
	0x2d, 0x48, 0x1c, 0xd4, 0x3b, 0xad, 0xfd, 0x9d, 0x99, 0x1f, 0xcf, 0x88, 0xde, 0x69, 0x5f, 0x1e,
	0x7d, 0x31, 0xbf, 0xcd, 0xe5, 0xa1, 0xae, 0xe7, 0xdd, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x18,
	0x84, 0x14, 0x02, 0xcb, 0x02, 0x00, 0x00,
}
