// Code generated by protoc-gen-go. DO NOT EDIT.
// source: channel_points_custom_reward_redemption/create.proto

package channel_points_custom_reward_redemption

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// RedemptionStatus is the different statuses a custom reward redemption can be in.
type RedemptionStatus int32

const (
	RedemptionStatus_REDEMPTION_STATUS_INVALID RedemptionStatus = 0
	// The redemption hasn’t had an action taken on it.
	RedemptionStatus_REDEMPTION_STATUS_UNFULFILLED RedemptionStatus = 1
	// The redemption has been acted upon and fulfilled.
	RedemptionStatus_REDEMPTION_STATUS_FULFILLED RedemptionStatus = 2
	// The redemption has been canceled and the points were refunded.
	RedemptionStatus_REDEMPTION_STATUS_CANCELED RedemptionStatus = 3
	// The redemption was reported.
	RedemptionStatus_REDEMPTION_STATUS_REPORTED RedemptionStatus = 4
)

var RedemptionStatus_name = map[int32]string{
	0: "REDEMPTION_STATUS_INVALID",
	1: "REDEMPTION_STATUS_UNFULFILLED",
	2: "REDEMPTION_STATUS_FULFILLED",
	3: "REDEMPTION_STATUS_CANCELED",
	4: "REDEMPTION_STATUS_REPORTED",
}
var RedemptionStatus_value = map[string]int32{
	"REDEMPTION_STATUS_INVALID":     0,
	"REDEMPTION_STATUS_UNFULFILLED": 1,
	"REDEMPTION_STATUS_FULFILLED":   2,
	"REDEMPTION_STATUS_CANCELED":    3,
	"REDEMPTION_STATUS_REPORTED":    4,
}

func (x RedemptionStatus) String() string {
	return proto.EnumName(RedemptionStatus_name, int32(x))
}
func (RedemptionStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_f8248d445050426c, []int{0}
}

// ChannelPointsCustomRewardRedemptionCreate is triggered when a custom reward is redeemed on a channel.
type ChannelPointsCustomRewardRedemptionCreate struct {
	// The redemption's unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the user who redeemed the reward.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// The ID of the channel the reward was redeemed on.
	BroadcasterUserId string `protobuf:"bytes,3,opt,name=broadcaster_user_id,json=broadcasterUserId,proto3" json:"broadcaster_user_id,omitempty"`
	// The reward that was redeemed.
	Reward *CustomReward `protobuf:"bytes,4,opt,name=reward,proto3" json:"reward,omitempty"`
	// The user-supplied input, if any.
	UserInput string `protobuf:"bytes,5,opt,name=user_input,json=userInput,proto3" json:"user_input,omitempty"`
	// The status of the redemption (UNFULFILLED, FULFILLED etc).
	Status RedemptionStatus `protobuf:"varint,6,opt,name=status,proto3,enum=channel_points_custom_reward_redemption.RedemptionStatus" json:"status,omitempty"`
	// The time the redemption was redeemed.
	RedeemedAt           *timestamp.Timestamp `protobuf:"bytes,7,opt,name=redeemed_at,json=redeemedAt,proto3" json:"redeemed_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ChannelPointsCustomRewardRedemptionCreate) Reset() {
	*m = ChannelPointsCustomRewardRedemptionCreate{}
}
func (m *ChannelPointsCustomRewardRedemptionCreate) String() string { return proto.CompactTextString(m) }
func (*ChannelPointsCustomRewardRedemptionCreate) ProtoMessage()    {}
func (*ChannelPointsCustomRewardRedemptionCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f8248d445050426c, []int{0}
}
func (m *ChannelPointsCustomRewardRedemptionCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate.Unmarshal(m, b)
}
func (m *ChannelPointsCustomRewardRedemptionCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate.Marshal(b, m, deterministic)
}
func (dst *ChannelPointsCustomRewardRedemptionCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate.Merge(dst, src)
}
func (m *ChannelPointsCustomRewardRedemptionCreate) XXX_Size() int {
	return xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate.Size(m)
}
func (m *ChannelPointsCustomRewardRedemptionCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelPointsCustomRewardRedemptionCreate proto.InternalMessageInfo

func (m *ChannelPointsCustomRewardRedemptionCreate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetBroadcasterUserId() string {
	if m != nil {
		return m.BroadcasterUserId
	}
	return ""
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetReward() *CustomReward {
	if m != nil {
		return m.Reward
	}
	return nil
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetUserInput() string {
	if m != nil {
		return m.UserInput
	}
	return ""
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetStatus() RedemptionStatus {
	if m != nil {
		return m.Status
	}
	return RedemptionStatus_REDEMPTION_STATUS_INVALID
}

func (m *ChannelPointsCustomRewardRedemptionCreate) GetRedeemedAt() *timestamp.Timestamp {
	if m != nil {
		return m.RedeemedAt
	}
	return nil
}

// CustomReward contains basic information about the reward that was redeemed.
type CustomReward struct {
	// The reward’s unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the channel the reward belongs to.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// A short title used to describe the reward.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// The user-facing prompt that was shown when the user redeemed the reward.
	Prompt string `protobuf:"bytes,4,opt,name=prompt,proto3" json:"prompt,omitempty"`
	// Number of points the reward cost.
	Cost                 int64    `protobuf:"varint,5,opt,name=cost,proto3" json:"cost,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CustomReward) Reset()         { *m = CustomReward{} }
func (m *CustomReward) String() string { return proto.CompactTextString(m) }
func (*CustomReward) ProtoMessage()    {}
func (*CustomReward) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_f8248d445050426c, []int{1}
}
func (m *CustomReward) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomReward.Unmarshal(m, b)
}
func (m *CustomReward) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomReward.Marshal(b, m, deterministic)
}
func (dst *CustomReward) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomReward.Merge(dst, src)
}
func (m *CustomReward) XXX_Size() int {
	return xxx_messageInfo_CustomReward.Size(m)
}
func (m *CustomReward) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomReward.DiscardUnknown(m)
}

var xxx_messageInfo_CustomReward proto.InternalMessageInfo

func (m *CustomReward) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CustomReward) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *CustomReward) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *CustomReward) GetPrompt() string {
	if m != nil {
		return m.Prompt
	}
	return ""
}

func (m *CustomReward) GetCost() int64 {
	if m != nil {
		return m.Cost
	}
	return 0
}

func init() {
	proto.RegisterType((*ChannelPointsCustomRewardRedemptionCreate)(nil), "channel_points_custom_reward_redemption.ChannelPointsCustomRewardRedemptionCreate")
	proto.RegisterType((*CustomReward)(nil), "channel_points_custom_reward_redemption.CustomReward")
	proto.RegisterEnum("channel_points_custom_reward_redemption.RedemptionStatus", RedemptionStatus_name, RedemptionStatus_value)
}

func init() {
	proto.RegisterFile("channel_points_custom_reward_redemption/create.proto", fileDescriptor_create_f8248d445050426c)
}

var fileDescriptor_create_f8248d445050426c = []byte{
	// 467 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x93, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0x86, 0x71, 0x92, 0xba, 0xca, 0x14, 0x55, 0x61, 0x5b, 0x51, 0x13, 0x14, 0x1a, 0x7a, 0x21,
	0x45, 0xc2, 0x91, 0x0a, 0x1c, 0x80, 0x53, 0x70, 0x5c, 0xc9, 0x52, 0x9a, 0x86, 0x8d, 0xc3, 0x81,
	0x8b, 0xb5, 0xb1, 0x97, 0x62, 0x29, 0xf6, 0x5a, 0xbb, 0x63, 0x2a, 0x5e, 0x05, 0x9e, 0xa3, 0xef,
	0x87, 0xbc, 0x9b, 0xd0, 0x40, 0x38, 0xf8, 0xe6, 0xd9, 0xf9, 0x76, 0xfe, 0xf9, 0x7f, 0x6b, 0xe1,
	0x4d, 0xfc, 0x8d, 0xe5, 0x39, 0x5f, 0x45, 0x85, 0x48, 0x73, 0x54, 0x51, 0x5c, 0x2a, 0x14, 0x59,
	0x24, 0xf9, 0x2d, 0x93, 0x49, 0x24, 0x79, 0xc2, 0xb3, 0x02, 0x53, 0x91, 0x0f, 0x63, 0xc9, 0x19,
	0x72, 0xb7, 0x90, 0x02, 0x05, 0x79, 0x51, 0xf3, 0x56, 0xf7, 0x98, 0x7f, 0xe7, 0x39, 0x2e, 0x4b,
	0x35, 0x14, 0xb7, 0x39, 0x97, 0xe6, 0x7a, 0xf7, 0xf4, 0x46, 0x88, 0x9b, 0x15, 0x1f, 0xea, 0x6a,
	0x59, 0x7e, 0x1d, 0x62, 0x9a, 0x71, 0x85, 0x2c, 0x2b, 0x0c, 0x70, 0xf6, 0xab, 0x09, 0xe7, 0x9e,
	0x91, 0x98, 0x69, 0x05, 0x4f, 0x0b, 0x50, 0x3d, 0x9f, 0xfe, 0x19, 0xef, 0xe9, 0x9d, 0xc8, 0x21,
	0x34, 0xd2, 0xc4, 0xb1, 0xfa, 0xd6, 0xa0, 0x4d, 0x1b, 0x69, 0x42, 0x4e, 0x60, 0xbf, 0x54, 0x5c,
	0x46, 0x69, 0xe2, 0x34, 0xf4, 0xa1, 0x5d, 0x95, 0x41, 0x42, 0x5c, 0x38, 0x5a, 0x4a, 0xc1, 0x92,
	0x98, 0x29, 0xe4, 0x32, 0xda, 0x40, 0x4d, 0x0d, 0x3d, 0xda, 0x6a, 0x2d, 0x0c, 0x7f, 0x05, 0xb6,
	0xb1, 0xe4, 0xb4, 0xfa, 0xd6, 0xe0, 0xe0, 0xe2, 0xad, 0x5b, 0xd3, 0xb7, 0xfb, 0xd7, 0xbe, 0xeb,
	0x21, 0xa4, 0x07, 0x60, 0x24, 0xf3, 0xa2, 0x44, 0x67, 0x4f, 0xab, 0xb6, 0xf5, 0x6a, 0xd5, 0x01,
	0xf9, 0x04, 0xb6, 0x42, 0x86, 0xa5, 0x72, 0xec, 0xbe, 0x35, 0x38, 0xbc, 0x78, 0x57, 0x5b, 0xed,
	0x3e, 0x91, 0xb9, 0x1e, 0x40, 0xd7, 0x83, 0xc8, 0x07, 0x38, 0xa8, 0x30, 0x9e, 0xf1, 0x24, 0x62,
	0xe8, 0xec, 0x6b, 0x17, 0x5d, 0xd7, 0xc4, 0xef, 0x6e, 0xe2, 0x77, 0xc3, 0x4d, 0xfc, 0x14, 0x36,
	0xf8, 0x08, 0xdf, 0x9f, 0xfc, 0xbc, 0x73, 0x8e, 0x90, 0xb3, 0xec, 0x55, 0x2c, 0xb2, 0xac, 0xcc,
	0xd3, 0x98, 0x55, 0x12, 0xea, 0xec, 0x07, 0x3c, 0xdc, 0xf6, 0x57, 0x3f, 0xff, 0x63, 0xd8, 0xc3,
	0x14, 0x57, 0x7c, 0x9d, 0xb8, 0x29, 0xc8, 0x63, 0xb0, 0x0b, 0x29, 0xb2, 0x02, 0x75, 0xca, 0x6d,
	0xba, 0xae, 0x08, 0x81, 0x56, 0x2c, 0x94, 0x09, 0xaa, 0x49, 0xf5, 0xf7, 0xcb, 0x3b, 0x0b, 0x3a,
	0xff, 0xba, 0x25, 0x3d, 0x78, 0x42, 0xfd, 0xb1, 0x7f, 0x35, 0x0b, 0x83, 0xeb, 0x69, 0x34, 0x0f,
	0x47, 0xe1, 0x62, 0x1e, 0x05, 0xd3, 0xcf, 0xa3, 0x49, 0x30, 0xee, 0x3c, 0x20, 0xcf, 0xa1, 0xb7,
	0xdb, 0x5e, 0x4c, 0x2f, 0x17, 0x93, 0xcb, 0x60, 0x32, 0xf1, 0xc7, 0x1d, 0x8b, 0x9c, 0xc2, 0xd3,
	0x5d, 0xe4, 0x1e, 0x68, 0x90, 0x67, 0xd0, 0xdd, 0x05, 0xbc, 0xd1, 0xd4, 0xf3, 0xab, 0x7e, 0xf3,
	0xff, 0x7d, 0xea, 0xcf, 0xae, 0x69, 0xe8, 0x8f, 0x3b, 0xad, 0x8f, 0xe7, 0x5f, 0xea, 0x3e, 0x99,
	0xa5, 0xad, 0x7f, 0xcb, 0xeb, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x92, 0xf1, 0x1a, 0x60, 0x9a,
	0x03, 0x00, 0x00,
}
